/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.GraphValidationException;

public class DefaultResolverResults
implements ResolverResults {
    private ResolvedConfiguration resolvedConfiguration;
    private ResolutionResult resolutionResult;
    private ResolveException fatalFailure;
    private ResolveException nonFatalFailure;
    private ResolvedLocalComponentsResult resolvedLocalComponentsResult;
    private Object artifactResolveState;
    private VisitedArtifactSet visitedArtifacts;

    @Override
    public boolean hasError() {
        if (this.fatalFailure != null || this.nonFatalFailure != null) {
            return true;
        }
        return this.resolvedConfiguration != null && this.resolvedConfiguration.hasError();
    }

    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        this.assertHasArtifactResult();
        return this.resolvedConfiguration;
    }

    @Override
    public ResolutionResult getResolutionResult() {
        this.assertHasGraphResult();
        return this.resolutionResult;
    }

    @Override
    public ResolvedLocalComponentsResult getResolvedLocalComponents() {
        this.assertHasGraphResult();
        return this.resolvedLocalComponentsResult;
    }

    @Override
    public VisitedArtifactSet getVisitedArtifacts() {
        this.assertHasVisitResult();
        return this.visitedArtifacts;
    }

    private void assertHasVisitResult() {
        this.maybeRethrowFatalError();
        if (this.visitedArtifacts == null) {
            throw new IllegalStateException("Resolution result has not been attached.");
        }
    }

    private void assertHasGraphResult() {
        this.maybeRethrowFatalError();
        if (this.resolvedLocalComponentsResult == null) {
            throw new IllegalStateException("Resolution result has not been attached.");
        }
    }

    private void maybeRethrowFatalError() {
        if (this.fatalFailure != null) {
            throw this.fatalFailure;
        }
    }

    private void maybeRethrowAnyError() {
        this.maybeRethrowFatalError();
        if (this.nonFatalFailure != null) {
            throw this.nonFatalFailure;
        }
    }

    private void assertHasArtifactResult() {
        if (this.resolvedConfiguration == null) {
            throw new IllegalStateException("Resolution artifacts have not been attached.");
        }
    }

    @Override
    public void graphResolved(VisitedArtifactSet visitedArtifacts) {
        this.visitedArtifacts = visitedArtifacts;
        this.resolvedLocalComponentsResult = null;
        this.resolutionResult = null;
        this.fatalFailure = null;
    }

    @Override
    public void graphResolved(ResolutionResult resolutionResult, ResolvedLocalComponentsResult resolvedLocalComponentsResult, VisitedArtifactSet visitedArtifacts) {
        this.resolutionResult = resolutionResult;
        this.resolvedLocalComponentsResult = resolvedLocalComponentsResult;
        this.visitedArtifacts = visitedArtifacts;
        this.fatalFailure = null;
    }

    @Override
    public void failed(ResolveException failure) {
        if (DefaultResolverResults.isNonFatalError(failure)) {
            this.nonFatalFailure = failure;
        } else {
            this.resolutionResult = null;
            this.resolvedLocalComponentsResult = null;
            this.fatalFailure = failure;
        }
    }

    private static boolean isNonFatalError(ResolveException failure) {
        return failure.getCause() instanceof GraphValidationException;
    }

    @Override
    public void artifactsResolved(ResolvedConfiguration resolvedConfiguration, VisitedArtifactSet visitedArtifacts) {
        this.resolvedConfiguration = resolvedConfiguration;
        this.visitedArtifacts = visitedArtifacts;
        this.artifactResolveState = null;
    }

    @Override
    public ResolveException consumeNonFatalFailure() {
        try {
            ResolveException resolveException = this.nonFatalFailure;
            return resolveException;
        }
        finally {
            this.nonFatalFailure = null;
        }
    }

    @Override
    public Throwable getFailure() {
        if (this.fatalFailure != null) {
            return this.fatalFailure;
        }
        if (this.nonFatalFailure != null) {
            return this.nonFatalFailure;
        }
        return null;
    }

    @Override
    public boolean hasResolutionResult() {
        return this.resolutionResult != null;
    }

    @Override
    public void retainState(Object artifactResolveState) {
        this.artifactResolveState = artifactResolveState;
    }

    @Override
    public Object getArtifactResolveState() {
        this.maybeRethrowAnyError();
        return this.artifactResolveState;
    }
}

