/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildableSingleResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.TransformArtifactOperation;
import org.gradle.api.internal.artifacts.transform.TransformFileOperation;
import org.gradle.api.internal.artifacts.transform.UserCodeBackedTransformer;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public abstract class TransformNode
extends Node {
    private static final AtomicInteger ORDER_COUNTER = new AtomicInteger();
    private final int order = ORDER_COUNTER.incrementAndGet();
    protected final UserCodeBackedTransformer artifactTransformer;
    protected List<File> result;
    protected Throwable failure;

    public static TransformNode chained(UserCodeBackedTransformer current, TransformNode previous, ComponentArtifactIdentifier artifactId) {
        return new ChainedTransformNode(current, previous, artifactId);
    }

    public static TransformNode initial(UserCodeBackedTransformer initial, BuildableSingleResolvedArtifactSet artifact) {
        return new InitialTransformNode(initial, artifact);
    }

    protected TransformNode(UserCodeBackedTransformer artifactTransformer) {
        this.artifactTransformer = artifactTransformer;
    }

    public abstract void execute(BuildOperationExecutor var1, ArtifactTransformListener var2);

    public String toString() {
        return this.artifactTransformer.getDisplayName();
    }

    private List<File> getResult() {
        if (this.failure != null) {
            throw new IllegalStateException("Transformation has failed", this.failure);
        }
        if (this.result == null) {
            throw new IllegalStateException("Transformation hasn't been executed yet");
        }
        return this.result;
    }

    @Nullable
    private Throwable getFailure() {
        if (this.result == null) {
            throw new IllegalStateException("Transformation hasn't been executed yet");
        }
        return this.failure;
    }

    public void prepareForExecution() {
    }

    public void collectTaskInto(ImmutableCollection.Builder<Task> builder) {
    }

    public Throwable getNodeFailure() {
        return null;
    }

    public void rethrowNodeFailure() {
    }

    public int compareTo(Node other) {
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return ((Object)((Object)this)).getClass().getName().compareTo(other.getClass().getName());
        }
        TransformNode otherTransform = (TransformNode)other;
        return this.order - otherTransform.order;
    }

    private static class ResolveOnlyAsyncArtifactListener
    implements ResolvedArtifactSet.AsyncArtifactListener {
        private ResolveOnlyAsyncArtifactListener() {
        }

        @Override
        public void artifactAvailable(ResolvableArtifact artifact) {
        }

        @Override
        public boolean requireArtifactFiles() {
            return true;
        }

        @Override
        public boolean includeFileDependencies() {
            return false;
        }

        @Override
        public void fileAvailable(File file) {
        }
    }

    private static class ResolveArtifacts
    implements Action<BuildOperationQueue<RunnableBuildOperation>> {
        private final ResolvedArtifactSet artifactSet;
        private ResolvedArtifactSet.Completion result;

        public ResolveArtifacts(ResolvedArtifactSet artifactSet) {
            this.artifactSet = artifactSet;
        }

        public void execute(BuildOperationQueue<RunnableBuildOperation> actions) {
            this.result = this.artifactSet.startVisit(actions, new ResolveOnlyAsyncArtifactListener());
        }

        public ResolvedArtifactSet.Completion getResult() {
            return this.result;
        }
    }

    private static class ChainedTransformNode
    extends TransformNode {
        private final TransformNode previousTransform;
        private final ComponentArtifactIdentifier artifactId;

        public ChainedTransformNode(UserCodeBackedTransformer artifactTransformer, TransformNode previousTransform, ComponentArtifactIdentifier artifactId) {
            super(artifactTransformer);
            this.previousTransform = previousTransform;
            this.artifactId = artifactId;
        }

        @Override
        public void execute(BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
            ChainedArtifactTransformStepOperation chainedArtifactTransformStep = new ChainedArtifactTransformStepOperation(transformListener);
            buildOperationExecutor.run((RunnableBuildOperation)chainedArtifactTransformStep);
            this.result = chainedArtifactTransformStep.getResult();
            this.failure = chainedArtifactTransformStep.getFailure();
        }

        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
            this.addDependencySuccessor(this.previousTransform);
            processHardSuccessor.execute((Object)this.previousTransform);
        }

        private class ChainedArtifactTransformStepOperation
        implements RunnableBuildOperation {
            private final ArtifactTransformListener transformListener;
            private List<File> result;
            private Throwable failure;

            public ChainedArtifactTransformStepOperation(ArtifactTransformListener transformListener) {
                this.transformListener = transformListener;
            }

            public void run(BuildOperationContext context) {
                Throwable previousFailure = ChainedTransformNode.this.previousTransform.getFailure();
                if (previousFailure != null) {
                    this.failure = previousFailure;
                    this.result = Collections.emptyList();
                    return;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (File inputFile : ChainedTransformNode.this.previousTransform.getResult()) {
                    TransformFileOperation operation = new TransformFileOperation(inputFile, ChainedTransformNode.this.artifactTransformer, this.transformListener);
                    operation.run(context);
                    if (operation.getFailure() != null) {
                        this.failure = operation.getFailure();
                        this.result = Collections.emptyList();
                        return;
                    }
                    List<File> result = operation.getResult();
                    if (result == null) continue;
                    builder.addAll(result);
                }
                this.result = builder.build();
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Transform " + ChainedTransformNode.this.artifactId.getDisplayName() + " with " + ChainedTransformNode.this.artifactTransformer.getDisplayName();
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).operationType(BuildOperationCategory.TRANSFORM);
            }

            public List<File> getResult() {
                return this.result;
            }

            public Throwable getFailure() {
                return this.failure;
            }
        }
    }

    private static class InitialTransformNode
    extends TransformNode {
        private final BuildableSingleResolvedArtifactSet artifactSet;

        public InitialTransformNode(UserCodeBackedTransformer artifactTransformer, BuildableSingleResolvedArtifactSet artifactSet) {
            super(artifactTransformer);
            this.artifactSet = artifactSet;
        }

        @Override
        public void execute(BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
            InitialArtifactTransformationStepOperation transformationStep = new InitialArtifactTransformationStepOperation(buildOperationExecutor, transformListener);
            buildOperationExecutor.run((RunnableBuildOperation)transformationStep);
            this.result = transformationStep.getResult();
            this.failure = transformationStep.getFailure();
        }

        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
            Set<Node> dependencies = this.getDependencies(dependencyResolver);
            for (Node dependency : dependencies) {
                this.addDependencySuccessor(dependency);
                processHardSuccessor.execute((Object)dependency);
            }
        }

        private Set<Node> getDependencies(TaskDependencyResolver dependencyResolver) {
            return dependencyResolver.resolveDependenciesFor(null, (Object)new TaskDependencyContainer(){

                public void visitDependencies(final TaskDependencyResolveContext context) {
                    artifactSet.collectBuildDependencies(new BuildDependenciesVisitor(){

                        @Override
                        public void visitDependency(Object dep) {
                            context.add(dep);
                        }

                        @Override
                        public void attachFinalizerTo(Task task, Action<? super Task> action) {
                            context.attachFinalizerTo(task, action);
                        }

                        @Override
                        public void visitFailure(Throwable failure) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)failure);
                        }
                    });
                }
            });
        }

        private class InitialArtifactTransformationStepOperation
        implements RunnableBuildOperation {
            private List<File> result;
            private Throwable failure;
            private final BuildOperationExecutor buildOperationExecutor;
            private final ArtifactTransformListener transformListener;

            public InitialArtifactTransformationStepOperation(BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
                this.buildOperationExecutor = buildOperationExecutor;
                this.transformListener = transformListener;
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Transform " + InitialTransformNode.this.artifactSet.getArtifactId().getDisplayName() + " with " + InitialTransformNode.this.artifactTransformer.getDisplayName();
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).operationType(BuildOperationCategory.TRANSFORM);
            }

            public void run(BuildOperationContext context) {
                ResolveArtifacts resolveArtifacts = new ResolveArtifacts(InitialTransformNode.this.artifactSet);
                this.buildOperationExecutor.runAll((Action)resolveArtifacts);
                ResolvedArtifactCollectingVisitor visitor = new ResolvedArtifactCollectingVisitor();
                resolveArtifacts.getResult().visit(visitor);
                Set<Throwable> failures = visitor.getFailures();
                if (!failures.isEmpty()) {
                    Object failure = failures.size() == 1 && Iterables.getOnlyElement(failures) instanceof ResolveException ? (Throwable)Iterables.getOnlyElement(failures) : new DefaultLenientConfiguration.ArtifactResolveException("artifacts", InitialTransformNode.this.artifactTransformer.getDisplayName(), "artifact transform", failures);
                    this.failure = failure;
                    this.result = Collections.emptyList();
                    return;
                }
                ResolvedArtifactResult artifact = (ResolvedArtifactResult)Iterables.getOnlyElement(visitor.getArtifacts());
                TransformArtifactOperation operation = new TransformArtifactOperation(artifact.getId(), artifact.getFile(), InitialTransformNode.this.artifactTransformer, this.transformListener);
                operation.run(context);
                this.failure = operation.getFailure();
                this.result = operation.getResult();
            }

            public List<File> getResult() {
                return this.result;
            }

            public Throwable getFailure() {
                return this.failure;
            }
        }
    }
}

