/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultAfterPreviousExecutionState;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.SnapshotSerializer;

public class DefaultPreviousExecutionStateSerializer
extends AbstractSerializer<AfterPreviousExecutionState> {
    private final Serializer<FileCollectionFingerprint> fileCollectionFingerprintSerializer;
    private final Serializer<ImplementationSnapshot> implementationSnapshotSerializer;
    private final Serializer<ValueSnapshot> valueSnapshotSerializer = new SnapshotSerializer();

    public DefaultPreviousExecutionStateSerializer(Serializer<FileCollectionFingerprint> fileCollectionFingerprintSerializer) {
        this.fileCollectionFingerprintSerializer = fileCollectionFingerprintSerializer;
        this.implementationSnapshotSerializer = new ImplementationSnapshot.SerializerImpl();
    }

    public AfterPreviousExecutionState read(Decoder decoder) throws Exception {
        OriginMetadata originMetadata = OriginMetadata.fromPreviousBuild((UniqueId)UniqueId.from((String)decoder.readString()), (long)decoder.readLong());
        ImplementationSnapshot taskImplementation = (ImplementationSnapshot)this.implementationSnapshotSerializer.read(decoder);
        int taskActionsCount = decoder.readSmallInt();
        ImmutableList.Builder taskActionImplementationsBuilder = ImmutableList.builder();
        for (int j = 0; j < taskActionsCount; ++j) {
            ImplementationSnapshot actionImpl = (ImplementationSnapshot)this.implementationSnapshotSerializer.read(decoder);
            taskActionImplementationsBuilder.add((Object)actionImpl);
        }
        ImmutableList taskActionImplementations = taskActionImplementationsBuilder.build();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = this.readInputProperties(decoder);
        ImmutableSortedMap<String, FileCollectionFingerprint> inputFilesFingerprints = this.readFingerprints(decoder);
        ImmutableSortedMap<String, FileCollectionFingerprint> outputFilesFingerprints = this.readFingerprints(decoder);
        boolean successful = decoder.readBoolean();
        return new DefaultAfterPreviousExecutionState(originMetadata, taskImplementation, (ImmutableList<ImplementationSnapshot>)taskActionImplementations, inputProperties, inputFilesFingerprints, outputFilesFingerprints, successful);
    }

    public void write(Encoder encoder, AfterPreviousExecutionState execution) throws Exception {
        OriginMetadata originMetadata = execution.getOriginMetadata();
        encoder.writeString((CharSequence)originMetadata.getBuildInvocationId().asString());
        encoder.writeLong(originMetadata.getExecutionTime());
        this.implementationSnapshotSerializer.write(encoder, (Object)execution.getImplementation());
        ImmutableList<ImplementationSnapshot> additionalImplementations = execution.getAdditionalImplementations();
        encoder.writeSmallInt(additionalImplementations.size());
        for (ImplementationSnapshot actionImpl : additionalImplementations) {
            this.implementationSnapshotSerializer.write(encoder, (Object)actionImpl);
        }
        this.writeInputProperties(encoder, (ImmutableMap<String, ValueSnapshot>)execution.getInputProperties());
        this.writeFingerprints(encoder, (Map<String, FileCollectionFingerprint>)execution.getInputFileProperties());
        this.writeFingerprints(encoder, (Map<String, FileCollectionFingerprint>)execution.getOutputFileProperties());
        encoder.writeBoolean(execution.isSuccessful());
    }

    public ImmutableSortedMap<String, ValueSnapshot> readInputProperties(Decoder decoder) throws Exception {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableSortedMap.of();
        }
        if (size == 1) {
            return ImmutableSortedMap.of((Comparable)((Object)decoder.readString()), (Object)this.readValueSnapshot(decoder));
        }
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)decoder.readString(), (Object)this.readValueSnapshot(decoder));
        }
        return builder.build();
    }

    public void writeInputProperties(Encoder encoder, ImmutableMap<String, ValueSnapshot> properties) throws Exception {
        encoder.writeSmallInt(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.writeValueSnapshot(encoder, (ValueSnapshot)entry.getValue());
        }
    }

    private ImmutableSortedMap<String, FileCollectionFingerprint> readFingerprints(Decoder decoder) throws Exception {
        int count = decoder.readSmallInt();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int fingerprintIdx = 0; fingerprintIdx < count; ++fingerprintIdx) {
            String property = decoder.readString();
            FileCollectionFingerprint fingerprint = (FileCollectionFingerprint)this.fileCollectionFingerprintSerializer.read(decoder);
            builder.put((Object)property, (Object)fingerprint);
        }
        return builder.build();
    }

    private void writeFingerprints(Encoder encoder, Map<String, FileCollectionFingerprint> fingerprints) throws Exception {
        encoder.writeSmallInt(fingerprints.size());
        for (Map.Entry<String, FileCollectionFingerprint> entry : fingerprints.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.fileCollectionFingerprintSerializer.write(encoder, (Object)entry.getValue());
        }
    }

    private ValueSnapshot readValueSnapshot(Decoder decoder) throws Exception {
        return (ValueSnapshot)this.valueSnapshotSerializer.read(decoder);
    }

    private void writeValueSnapshot(Encoder encoder, ValueSnapshot snapshot) throws Exception {
        this.valueSnapshotSerializer.write(encoder, (Object)snapshot);
    }
}

