/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.KeepAliveMode;

public class DaemonForkOptionsBuilder {
    private final JavaForkOptionsInternal javaForkOptions;
    private final PathToFileResolver fileResolver;
    private Iterable<File> classpath = Collections.emptyList();
    private Iterable<String> sharedPackages = Collections.emptyList();
    private KeepAliveMode keepAliveMode = KeepAliveMode.DAEMON;

    public DaemonForkOptionsBuilder(PathToFileResolver resolver) {
        this.fileResolver = resolver;
        this.javaForkOptions = new DefaultJavaForkOptions(resolver);
    }

    public DaemonForkOptionsBuilder classpath(Iterable<File> classpath) {
        this.classpath = classpath;
        return this;
    }

    public DaemonForkOptionsBuilder sharedPackages(Iterable<String> sharedPackages) {
        this.sharedPackages = sharedPackages;
        return this;
    }

    public DaemonForkOptionsBuilder keepAliveMode(KeepAliveMode keepAliveMode) {
        this.keepAliveMode = keepAliveMode;
        return this;
    }

    public DaemonForkOptionsBuilder javaForkOptions(JavaForkOptions javaForkOptions) {
        javaForkOptions.copyTo((JavaForkOptions)this.javaForkOptions);
        return this;
    }

    public DaemonForkOptions build() {
        return new DaemonForkOptions(this.buildJavaForkOptions(), this.classpath, this.sharedPackages, this.keepAliveMode);
    }

    private ImmutableJavaForkOptions buildJavaForkOptions() {
        DefaultJavaForkOptions delegate = new DefaultJavaForkOptions(this.fileResolver);
        this.javaForkOptions.copyTo((JavaForkOptions)delegate);
        return new ImmutableJavaForkOptions((JavaForkOptionsInternal)delegate);
    }

    private static class ImmutableJavaForkOptions
    implements JavaForkOptionsInternal {
        private final JavaForkOptionsInternal delegate;

        public ImmutableJavaForkOptions(JavaForkOptionsInternal delegate) {
            this.delegate = delegate;
        }

        public String getExecutable() {
            return this.delegate.getExecutable();
        }

        public void setExecutable(String executable) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getSystemProperties() {
            return ImmutableMap.copyOf((Map)this.delegate.getSystemProperties());
        }

        public void setExecutable(Object executable) {
            throw new UnsupportedOperationException();
        }

        public void setSystemProperties(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        public ProcessForkOptions executable(Object executable) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions systemProperties(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        public File getWorkingDir() {
            return this.delegate.getWorkingDir();
        }

        public void setWorkingDir(File dir) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions systemProperty(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setWorkingDir(Object dir) {
            throw new UnsupportedOperationException();
        }

        public String getDefaultCharacterEncoding() {
            return this.delegate.getDefaultCharacterEncoding();
        }

        public ProcessForkOptions workingDir(Object dir) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getEnvironment() {
            return ImmutableMap.copyOf((Map)this.delegate.getEnvironment());
        }

        public void setEnvironment(Map<String, ?> environmentVariables) {
            throw new UnsupportedOperationException();
        }

        public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
            throw new UnsupportedOperationException();
        }

        public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
            throw new UnsupportedOperationException();
        }

        public String getMinHeapSize() {
            return this.delegate.getMinHeapSize();
        }

        public void setMinHeapSize(String heapSize) {
            throw new UnsupportedOperationException();
        }

        public ProcessForkOptions environment(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public ProcessForkOptions copyTo(ProcessForkOptions options) {
            throw new UnsupportedOperationException();
        }

        public String getMaxHeapSize() {
            return this.delegate.getMaxHeapSize();
        }

        public void setMaxHeapSize(String heapSize) {
            throw new UnsupportedOperationException();
        }

        public List<String> getJvmArgs() {
            return ImmutableList.copyOf((Collection)this.delegate.getJvmArgs());
        }

        public void setJvmArgs(List<String> arguments) {
            throw new UnsupportedOperationException();
        }

        public void setJvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions jvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions jvmArgs(Object ... arguments) {
            throw new UnsupportedOperationException();
        }

        public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
            throw new UnsupportedOperationException();
        }

        public FileCollection getBootstrapClasspath() {
            return this.delegate.getBootstrapClasspath();
        }

        public void setBootstrapClasspath(FileCollection classpath) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions bootstrapClasspath(Object ... classpath) {
            throw new UnsupportedOperationException();
        }

        public boolean getEnableAssertions() {
            return this.delegate.getEnableAssertions();
        }

        public void setEnableAssertions(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        public boolean getDebug() {
            return this.delegate.getDebug();
        }

        public void setDebug(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        public List<String> getAllJvmArgs() {
            return ImmutableList.copyOf((Collection)this.delegate.getAllJvmArgs());
        }

        public void setAllJvmArgs(List<String> arguments) {
            throw new UnsupportedOperationException();
        }

        public void setAllJvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions copyTo(JavaForkOptions options) {
            return this.delegate.copyTo(options);
        }

        public JavaForkOptionsInternal mergeWith(JavaForkOptions options) {
            return new ImmutableJavaForkOptions(this.delegate.mergeWith(options));
        }

        public boolean isCompatibleWith(JavaForkOptions options) {
            return this.delegate.isCompatibleWith(options);
        }
    }
}

