/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.tasks.BuildCacheKeyInputs;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.util.Path;

class NoOutputsArtifactState
implements TaskArtifactState {
    public static final TaskArtifactState WITHOUT_ACTIONS = new NoOutputsArtifactState("Task has not declared any outputs nor actions.");
    public static final TaskArtifactState WITH_ACTIONS = new NoOutputsArtifactState("Task has not declared any outputs despite executing actions.");
    private static final BuildCacheKeyInputs NO_CACHE_KEY_INPUTS = new BuildCacheKeyInputs(null, null, null, null, null, null);
    private static final TaskOutputCachingBuildCacheKey NO_CACHE_KEY = new TaskOutputCachingBuildCacheKey(){

        @Override
        public boolean isValid() {
            return false;
        }

        public String toString() {
            return "INVALID";
        }

        @Override
        public Path getTaskPath() {
            throw new UnsupportedOperationException();
        }

        public String getHashCode() {
            return null;
        }

        @Override
        public BuildCacheKeyInputs getInputs() {
            return NO_CACHE_KEY_INPUTS;
        }

        @Override
        public byte[] getHashCodeBytes() {
            return null;
        }

        public String getDisplayName() {
            return this.toString();
        }
    };
    private final Change change;

    private NoOutputsArtifactState(final String message) {
        this.change = new Change(){

            public String getMessage() {
                return message;
            }
        };
    }

    @Override
    public Optional<ExecutionStateChanges> getExecutionStateChanges() {
        return Optional.of(new ExecutionStateChanges(){

            public void visitAllChanges(ChangeVisitor visitor) {
                visitor.visitChange(NoOutputsArtifactState.this.change);
            }

            public boolean isRebuildRequired() {
                return true;
            }

            public Iterable<Change> getInputFilesChanges() {
                throw new UnsupportedOperationException();
            }

            public AfterPreviousExecutionState getPreviousExecution() {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Override
    public IncrementalTaskInputs getInputChanges() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<? extends FileCollectionFingerprint> getCurrentInputFileFingerprints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAllowedToUseCachedResults() {
        return false;
    }

    @Override
    public TaskOutputCachingBuildCacheKey calculateCacheKey(TaskProperties taskProperties) {
        return NO_CACHE_KEY;
    }

    @Override
    public void ensureSnapshotBeforeTask() {
    }

    @Override
    public void afterOutputsRemovedBeforeTask() {
    }

    @Override
    public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterTaskExecution(TaskExecutionContext taskExecutionContext) {
        return ImmutableSortedMap.of();
    }

    @Override
    public void persistNewOutputs(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputFingerprints, boolean successful, OriginMetadata originMetadata) {
    }

    @Override
    public Map<String, CurrentFileCollectionFingerprint> getOutputFingerprints() {
        return Collections.emptyMap();
    }

    @Override
    public OverlappingOutputs getOverlappingOutputs() {
        return null;
    }
}

