/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.internal.NoFactoryRegisteredForTypeException;
import org.gradle.api.internal.PolymorphicNamedEntityInstantiator;
import org.gradle.internal.Cast;

public class DefaultPolymorphicNamedEntityInstantiator<T>
implements PolymorphicNamedEntityInstantiator<T> {
    private final Map<Class<? extends T>, NamedDomainObjectFactory<? extends T>> factories = Maps.newHashMap();
    private final Class<? extends T> baseType;
    private final String displayName;

    public DefaultPolymorphicNamedEntityInstantiator(Class<? extends T> type, String displayName) {
        this.displayName = displayName;
        this.baseType = type;
    }

    public <S extends T> S create(String name, Class<S> type) {
        NamedDomainObjectFactory<? extends T> factory = this.factories.get(type);
        if (factory == null) {
            throw new InvalidUserDataException(String.format("Cannot create a %s because this type is not known to %s. Known types are: %s", type.getSimpleName(), this.displayName, this.getSupportedTypeNames()), (Throwable)new NoFactoryRegisteredForTypeException());
        }
        return (S)factory.create(name);
    }

    public String getSupportedTypeNames() {
        ArrayList names = Lists.newArrayList();
        for (Class<T> clazz : this.factories.keySet()) {
            names.add(clazz.getSimpleName());
        }
        Collections.sort(names);
        return names.isEmpty() ? "(None)" : Joiner.on((String)", ").join((Iterable)names);
    }

    public <U extends T> void registerFactory(Class<U> type, NamedDomainObjectFactory<? extends U> factory) {
        if (!this.baseType.isAssignableFrom(type)) {
            String message = String.format("Cannot register a factory for type %s because it is not a subtype of container element type %s.", type.getSimpleName(), this.baseType.getSimpleName());
            throw new IllegalArgumentException(message);
        }
        if (this.factories.containsKey(type)) {
            throw new GradleException(String.format("Cannot register a factory for type %s because a factory for this type is already registered.", type.getSimpleName()));
        }
        this.factories.put(type, factory);
    }

    @Override
    public Set<? extends Class<? extends T>> getCreatableTypes() {
        return ImmutableSet.copyOf(this.factories.keySet());
    }

    public void copyFactoriesFrom(DefaultPolymorphicNamedEntityInstantiator<T> source) {
        for (Class<? extends T> clazz : source.factories.keySet()) {
            this.copyFactory(source, clazz);
        }
    }

    <U extends T> void copyFactory(DefaultPolymorphicNamedEntityInstantiator<T> source, Class<U> type) {
        NamedDomainObjectFactory factory = (NamedDomainObjectFactory)Cast.uncheckedCast(source.factories.get(type));
        this.registerFactory(type, factory);
    }
}

