/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.cpp.internal.NativeDependencyCache;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.internal.DefaultNativeBinary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppBinary
extends DefaultNativeBinary
implements CppBinary {
    private final Provider<String> baseName;
    private final FileCollection sourceFiles;
    private final FileCollection includePath;
    private final Configuration linkLibraries;
    private final FileCollection runtimeLibraries;
    private final CppPlatform targetPlatform;
    private final NativeToolChainInternal toolChain;
    private final PlatformToolProvider platformToolProvider;
    private final Configuration includePathConfiguration;
    private final Property<CppCompile> compileTaskProperty;
    private final NativeVariantIdentity identity;

    public DefaultCppBinary(Names names, ObjectFactory objects, Provider<String> baseName, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration componentImplementation, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        super(names, objects, componentImplementation);
        this.baseName = baseName;
        this.sourceFiles = sourceFiles;
        this.targetPlatform = targetPlatform;
        this.toolChain = toolChain;
        this.platformToolProvider = platformToolProvider;
        this.compileTaskProperty = objects.property(CppCompile.class);
        this.identity = identity;
        Configuration includePathConfig = (Configuration)configurations.create(names.withPrefix("cppCompile"));
        includePathConfig.setCanBeConsumed(false);
        includePathConfig.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "cplusplus-api")));
        includePathConfig.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        includePathConfig.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        includePathConfig.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        includePathConfig.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        includePathConfig.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        Configuration nativeLink = (Configuration)configurations.create(names.withPrefix("nativeLink"));
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "native-link")));
        nativeLink.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        nativeLink.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        nativeLink.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        nativeLink.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        nativeLink.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        Configuration nativeRuntime = (Configuration)configurations.create(names.withPrefix("nativeRuntime"));
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "native-runtime")));
        nativeRuntime.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        nativeRuntime.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        nativeRuntime.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        nativeRuntime.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        nativeRuntime.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        this.includePathConfiguration = includePathConfig;
        this.includePath = componentHeaderDirs.plus((FileCollection)new FileCollectionAdapter((MinimalFileSet)new IncludePath(includePathConfig)));
        this.linkLibraries = nativeLink;
        this.runtimeLibraries = nativeRuntime;
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TemporaryFileProvider getTemporaryFileProvider() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected NativeDependencyCache getNativeDependencyCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Provider<String> getBaseName() {
        return this.baseName;
    }

    @Override
    public boolean isDebuggable() {
        return this.identity.isDebuggable();
    }

    @Override
    public boolean isOptimized() {
        return this.identity.isOptimized();
    }

    @Override
    public FileCollection getCppSource() {
        return this.sourceFiles;
    }

    @Override
    public FileCollection getCompileIncludePath() {
        return this.includePath;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibraries;
    }

    public Configuration getLinkConfiguration() {
        return this.linkLibraries;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibraries;
    }

    public Configuration getIncludePathConfiguration() {
        return this.includePathConfiguration;
    }

    @Override
    public TargetMachine getTargetMachine() {
        return this.targetPlatform.getTargetMachine();
    }

    @Override
    public CppPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public NativePlatform getNativePlatform() {
        return ((DefaultCppPlatform)this.targetPlatform).getNativePlatform();
    }

    public NativeToolChainInternal getToolChain() {
        return this.toolChain;
    }

    public Property<CppCompile> getCompileTask() {
        return this.compileTaskProperty;
    }

    public PlatformToolProvider getPlatformToolProvider() {
        return this.platformToolProvider;
    }

    public NativeVariantIdentity getIdentity() {
        return this.identity;
    }

    private class IncludePath
    implements MinimalFileSet,
    Buildable {
        private final Configuration includePathConfig;
        private Set<File> result;

        IncludePath(Configuration includePathConfig) {
            this.includePathConfig = includePathConfig;
        }

        public String getDisplayName() {
            return "Include path for " + DefaultCppBinary.this.toString();
        }

        public Set<File> getFiles() {
            if (this.result == null) {
                ArtifactCollection artifacts = this.includePathConfig.getIncoming().getArtifacts();
                LinkedHashSet<File> files = new LinkedHashSet<File>();
                if (!artifacts.getArtifacts().isEmpty()) {
                    NativeDependencyCache cache = DefaultCppBinary.this.getNativeDependencyCache();
                    for (ResolvedArtifactResult artifact : artifacts) {
                        if (artifact.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier && artifact.getFile().isFile()) {
                            ModuleComponentIdentifier id = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
                            File headerDir = cache.getUnpackedHeaders(artifact.getFile(), id.getModule() + "-" + id.getVersion());
                            files.add(headerDir);
                            continue;
                        }
                        files.add(artifact.getFile());
                    }
                }
                this.result = files;
            }
            return this.result;
        }

        public TaskDependency getBuildDependencies() {
            return this.includePathConfig.getBuildDependencies();
        }
    }
}

