/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.DefaultScalaSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.jvm.tasks.Jar;

public class ScalaBasePlugin
implements Plugin<Project> {
    @VisibleForTesting
    public static final String ZINC_CONFIGURATION_NAME = "zinc";
    public static final String SCALA_RUNTIME_EXTENSION_NAME = "scalaRuntime";
    private final ObjectFactory objectFactory;

    @Inject
    public ScalaBasePlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        Usage incrementalAnalysisUsage = (Usage)this.objectFactory.named(Usage.class, "incremental-analysis");
        this.configureConfigurations(project, incrementalAnalysisUsage);
        ScalaRuntime scalaRuntime = (ScalaRuntime)project.getExtensions().create(SCALA_RUNTIME_EXTENSION_NAME, ScalaRuntime.class, new Object[]{project});
        ScalaBasePlugin.configureCompileDefaults(project, scalaRuntime);
        ScalaBasePlugin.configureSourceSetDefaults(project, incrementalAnalysisUsage, this.objectFactory);
        ScalaBasePlugin.configureScaladoc(project, scalaRuntime);
    }

    private void configureConfigurations(final Project project, final Usage incrementalAnalysisUsage) {
        ((Configuration)project.getConfigurations().create(ZINC_CONFIGURATION_NAME)).setVisible(false).setDescription("The Zinc incremental compiler to be used for this Scala project.").defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)project.getDependencies().create((Object)"com.typesafe.zinc:zinc:0.3.15"));
            }
        });
        Configuration incrementalAnalysisElements = (Configuration)project.getConfigurations().create("incrementalScalaAnalysisElements");
        incrementalAnalysisElements.setVisible(false);
        incrementalAnalysisElements.setDescription("Incremental compilation analysis files");
        incrementalAnalysisElements.setCanBeResolved(false);
        incrementalAnalysisElements.setCanBeConsumed(true);
        incrementalAnalysisElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)incrementalAnalysisUsage);
        AttributeMatchingStrategy matchingStrategy = project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE);
        matchingStrategy.getDisambiguationRules().add(UsageDisambiguationRules.class, (Action)new Action<ActionConfiguration>(){

            public void execute(ActionConfiguration actionConfiguration) {
                actionConfiguration.params(new Object[]{incrementalAnalysisUsage});
                actionConfiguration.params(new Object[]{ScalaBasePlugin.this.objectFactory.named(Usage.class, "java-api")});
                actionConfiguration.params(new Object[]{ScalaBasePlugin.this.objectFactory.named(Usage.class, "java-runtime-jars")});
            }
        });
    }

    private static void configureSourceSetDefaults(final Project project, final Usage incrementalAnalysisUsage, final ObjectFactory objectFactory) {
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(SourceSet sourceSet) {
                String displayName = (String)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getDisplayName", null);
                Convention sourceSetConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
                DefaultScalaSourceSet scalaSourceSet = new DefaultScalaSourceSet(displayName, objectFactory);
                sourceSetConvention.getPlugins().put("scala", scalaSourceSet);
                final SourceDirectorySet scalaDirectorySet = scalaSourceSet.getScala();
                scalaDirectorySet.srcDir((Object)project.file((Object)("src/" + sourceSet.getName() + "/scala")));
                sourceSet.getAllJava().source(scalaDirectorySet);
                sourceSet.getAllSource().source(scalaDirectorySet);
                sourceSet.getResources().getFilter().exclude((Spec)new Spec<FileTreeElement>(){

                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return scalaDirectorySet.contains(element.getFile());
                    }
                });
                Configuration classpath = project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName());
                Configuration incrementalAnalysis = (Configuration)project.getConfigurations().create("incrementalScalaAnalysisFor" + sourceSet.getName());
                incrementalAnalysis.setVisible(false);
                incrementalAnalysis.setDescription("Incremental compilation analysis files for " + displayName);
                incrementalAnalysis.setCanBeResolved(true);
                incrementalAnalysis.setCanBeConsumed(false);
                incrementalAnalysis.extendsFrom(new Configuration[]{classpath});
                incrementalAnalysis.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)incrementalAnalysisUsage);
                ScalaBasePlugin.configureScalaCompile(project, sourceSet, incrementalAnalysis, incrementalAnalysisUsage);
            }
        });
    }

    private static void configureScalaCompile(final Project project, final SourceSet sourceSet, final Configuration incrementalAnalysis, Usage incrementalAnalysisUsage) {
        Convention scalaConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
        final ScalaSourceSet scalaSourceSet = (ScalaSourceSet)scalaConvention.findPlugin(ScalaSourceSet.class);
        final TaskProvider scalaCompile = project.getTasks().register(sourceSet.getCompileTaskName("scala"), ScalaCompile.class, (Action)new Action<ScalaCompile>(){

            public void execute(ScalaCompile scalaCompile) {
                scalaCompile.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
                SourceSetUtil.configureForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)scalaSourceSet.getScala(), (AbstractCompile)scalaCompile, (CompileOptions)scalaCompile.getOptions(), (Project)project);
                scalaCompile.setDescription("Compiles the " + scalaSourceSet.getScala() + ".");
                scalaCompile.setSource((FileTree)scalaSourceSet.getScala());
                scalaCompile.getAnalysisMappingFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".mapping"));
                IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                incrementalOptions.getAnalysisFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".analysis"));
                Jar jarTask = (Jar)project.getTasks().findByName(sourceSet.getJarTaskName());
                if (jarTask != null) {
                    incrementalOptions.getPublishedCode().set(jarTask.getArchiveFile());
                }
                scalaCompile.getAnalysisFiles().from(new Object[]{incrementalAnalysis.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(){

                    public void execute(ArtifactView.ViewConfiguration viewConfiguration) {
                        viewConfiguration.lenient(true);
                        viewConfiguration.componentFilter((Spec)new Spec<ComponentIdentifier>(){

                            public boolean isSatisfiedBy(ComponentIdentifier element) {
                                return element instanceof ProjectComponentIdentifier;
                            }
                        });
                    }
                }).getFiles()});
            }
        });
        SourceSetUtil.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)scalaSourceSet.getScala(), (Project)project, (Provider)scalaCompile, (Provider)scalaCompile.map((Transformer)new Transformer<CompileOptions, ScalaCompile>(){

            public CompileOptions transform(ScalaCompile scalaCompile) {
                return scalaCompile.getOptions();
            }
        }));
        project.getTasks().named(sourceSet.getClassesTaskName(), (Action)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{scalaCompile});
            }
        });
    }

    private static void configureCompileDefaults(final Project project, final ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaCompile.class).configureEach((Action)new Action<ScalaCompile>(){

            public void execute(final ScalaCompile compile) {
                compile.getConventionMapping().map("scalaClasspath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return scalaRuntime.inferScalaClasspath((Iterable<File>)compile.getClasspath());
                    }
                });
                compile.getConventionMapping().map("zincClasspath", (Callable)new Callable<Configuration>(){

                    @Override
                    public Configuration call() throws Exception {
                        return project.getConfigurations().getAt(ScalaBasePlugin.ZINC_CONFIGURATION_NAME);
                    }
                });
            }
        });
    }

    private static void configureScaladoc(final Project project, final ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaDoc.class).configureEach((Action)new Action<ScalaDoc>(){

            public void execute(final ScalaDoc scalaDoc) {
                scalaDoc.getConventionMapping().map("destinationDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        File docsDir = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getDocsDir();
                        return project.file((Object)(docsDir.getPath() + "/scaladoc"));
                    }
                });
                scalaDoc.getConventionMapping().map("title", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
                scalaDoc.getConventionMapping().map("scalaClasspath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return scalaRuntime.inferScalaClasspath((Iterable<File>)scalaDoc.getClasspath());
                    }
                });
            }
        });
    }

    static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage> {
        private final ImmutableSet<Usage> expectedUsages;
        private final Usage javaRuntimeJars;

        @Inject
        UsageDisambiguationRules(Usage incrementalAnalysis, Usage javaApi, Usage javaRuntimeJars) {
            this.javaRuntimeJars = javaRuntimeJars;
            this.expectedUsages = ImmutableSet.of((Object)incrementalAnalysis, (Object)javaApi, (Object)javaRuntimeJars);
        }

        public void execute(MultipleCandidatesDetails<Usage> details) {
            if (details.getConsumerValue() == null && details.getCandidateValues().equals(this.expectedUsages)) {
                details.closestMatch((Object)this.javaRuntimeJars);
            }
        }
    }
}

