/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.ConditionalTemplateOperation;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageSpecificProjectGenerator;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.internal.Factory;

public abstract class LanguageLibraryProjectInitDescriptor
implements LanguageSpecificProjectGenerator {
    protected final String language;
    protected final FileResolver fileResolver;
    protected final TemplateOperationFactory templateOperationFactory;
    protected final TemplateLibraryVersionProvider libraryVersionProvider;
    protected final BuildScriptBuilderFactory scriptBuilderFactory;

    public LanguageLibraryProjectInitDescriptor(String language, BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider) {
        this.language = language;
        this.scriptBuilderFactory = scriptBuilderFactory;
        this.fileResolver = fileResolver;
        this.templateOperationFactory = templateOperationFactory;
        this.libraryVersionProvider = libraryVersionProvider;
    }

    @Override
    public boolean supportsPackage() {
        return true;
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return BuildInitDsl.GROOVY;
    }

    @Override
    public void generate(InitSettings settings) {
        BuildScriptBuilder buildScriptBuilder = this.scriptBuilderFactory.script(settings.getDsl(), "build");
        this.generate(settings, buildScriptBuilder);
        buildScriptBuilder.create().generate();
    }

    protected abstract void generate(InitSettings var1, BuildScriptBuilder var2);

    protected TemplateOperation whenNoSourcesAvailable(TemplateOperation ... operations) {
        return new ConditionalTemplateOperation(new Factory<Boolean>(){

            public Boolean create() {
                return LanguageLibraryProjectInitDescriptor.this.fileResolver.resolveFilesAsTree(new Object[]{"src/main/" + LanguageLibraryProjectInitDescriptor.this.language}).isEmpty() || LanguageLibraryProjectInitDescriptor.this.fileResolver.resolveFilesAsTree(new Object[]{"src/test/" + LanguageLibraryProjectInitDescriptor.this.language}).isEmpty();
            }
        }, operations);
    }

    protected String withPackage(InitSettings settings, String className) {
        if (settings.getPackageName().isEmpty()) {
            return className;
        }
        return settings.getPackageName() + "." + className;
    }

    protected TemplateOperation fromClazzTemplate(String clazzTemplate, String sourceSetName) {
        return this.fromClazzTemplate(clazzTemplate, sourceSetName, this.language);
    }

    protected TemplateOperation fromClazzTemplate(String clazzTemplate, InitSettings settings, String sourceSetName) {
        return this.fromClazzTemplate(clazzTemplate, settings, sourceSetName, this.language);
    }

    protected TemplateOperation fromClazzTemplate(String clazzTemplate, String sourceSetName, String language) {
        return this.fromClazzTemplate(clazzTemplate, null, sourceSetName, language);
    }

    protected TemplateOperation fromClazzTemplate(String clazzTemplate, InitSettings settings, String sourceSetName, String language) {
        String targetFileName = clazzTemplate.substring(clazzTemplate.lastIndexOf("/") + 1).replace(".template", "");
        String packageDecl = "";
        if (settings != null && !settings.getPackageName().isEmpty()) {
            packageDecl = "package " + settings.getPackageName();
            targetFileName = settings.getPackageName().replace(".", "/") + "/" + targetFileName;
        }
        return this.templateOperationFactory.newTemplateOperation().withTemplate(clazzTemplate).withTarget("src/" + sourceSetName + "/" + language + "/" + targetFileName).withBinding("packageDecl", packageDecl).create();
    }
}

