/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.obr.filter.RequirementFilterParser;
import org.apache.ivy.osgi.obr.xml.Capability;
import org.apache.ivy.osgi.obr.xml.CapabilityAdapter;
import org.apache.ivy.osgi.obr.xml.Requirement;
import org.apache.ivy.osgi.obr.xml.RequirementAdapter;
import org.apache.ivy.osgi.obr.xml.RequirementFilter;
import org.apache.ivy.osgi.obr.xml.UnsupportedFilterException;
import org.apache.ivy.osgi.repo.BundleRepoDescriptor;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OBRXMLParser {
    public static BundleRepoDescriptor parse(URI baseUri, InputStream in) throws ParseException, IOException, SAXException {
        RepositoryHandler handler = new RepositoryHandler(baseUri);
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return handler.repo;
    }

    static class RequireHandler
    extends DelegetingHandler {
        static final String REQUIRE = "require";
        static final String NAME = "name";
        static final String OPTIONAL = "optional";
        static final String MULTIPLE = "multiple";
        static final String EXTEND = "extend";
        static final String FILTER = "filter";
        private Requirement requirement;
        private RequirementFilter filter;

        public RequireHandler() {
            super(REQUIRE);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String name = this.getRequiredAttribute(atts, NAME);
            String filterText = atts.getValue(FILTER);
            this.filter = null;
            if (filterText != null) {
                try {
                    this.filter = RequirementFilterParser.parse(filterText);
                }
                catch (ParseException e) {
                    throw new SAXParseException("Requirement with illformed filter: " + filterText, this.getLocator());
                }
            }
            Boolean optional = this.getOptionalBooleanAttribute(atts, OPTIONAL, null);
            Boolean multiple = this.getOptionalBooleanAttribute(atts, MULTIPLE, null);
            Boolean extend = this.getOptionalBooleanAttribute(atts, EXTEND, null);
            this.requirement = new Requirement(name, this.filter);
            if (optional != null) {
                this.requirement.setOptional(optional);
            }
            if (multiple != null) {
                this.requirement.setMultiple(multiple);
            }
            if (extend != null) {
                this.requirement.setExtend(extend);
            }
        }
    }

    static class CapabilityPropertyHandler
    extends DelegetingHandler {
        static final String CAPABILITY_PROPERTY = "p";
        static final String NAME = "n";
        static final String VALUE = "v";
        static final String TYPE = "t";
        String name;
        String value;
        String type;

        public CapabilityPropertyHandler() {
            super(CAPABILITY_PROPERTY);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.name = this.getRequiredAttribute(atts, NAME);
            this.value = this.getRequiredAttribute(atts, VALUE);
            this.type = atts.getValue(TYPE);
        }
    }

    static class CapabilityHandler
    extends DelegetingHandler {
        static final String CAPABILITY = "capability";
        static final String NAME = "name";
        Capability capability;

        public CapabilityHandler() {
            super(CAPABILITY);
            this.addChild(new CapabilityPropertyHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    String name = ((CapabilityPropertyHandler)child).name;
                    String value = ((CapabilityPropertyHandler)child).value;
                    String type = ((CapabilityPropertyHandler)child).type;
                    CapabilityHandler.this.capability.addProperty(name, value, type);
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String name = this.getRequiredAttribute(atts, NAME);
            this.capability = new Capability(name);
        }
    }

    static class ResourceSizeHandler
    extends DelegetingHandler {
        static final String SIZE = "size";

        public ResourceSizeHandler() {
            super(SIZE);
            this.setBufferingChar(true);
        }
    }

    static class ResourceLicenseHandler
    extends DelegetingHandler {
        static final String LICENSE = "license";

        public ResourceLicenseHandler() {
            super(LICENSE);
            this.setBufferingChar(true);
        }
    }

    static class ResourceDocumentationHandler
    extends DelegetingHandler {
        static final String DOCUMENTATION = "documentation";

        public ResourceDocumentationHandler() {
            super(DOCUMENTATION);
            this.setBufferingChar(true);
        }
    }

    static class ResourceDescriptionHandler
    extends DelegetingHandler {
        static final String DESCRIPTION = "description";

        public ResourceDescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }
    }

    static class ResourceHandler
    extends DelegetingHandler {
        private static final String DEFAULT_VERSION = "1.0.0";
        static final String RESOURCE = "resource";
        static final String ID = "id";
        static final String PRESENTATION_NAME = "presentationname";
        static final String SYMBOLIC_NAME = "symbolicname";
        static final String URI = "uri";
        static final String VERSION = "version";
        BundleInfo bundleInfo;

        public ResourceHandler() {
            super(RESOURCE);
            this.setSkipOnError(true);
            this.addChild(new ResourceDescriptionHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    ResourceHandler.this.bundleInfo.setDescription(child.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceDocumentationHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    ResourceHandler.this.bundleInfo.setDocumentation(child.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceLicenseHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    ResourceHandler.this.bundleInfo.setLicense(child.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceSizeHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    String size = child.getBufferedChars().trim();
                    try {
                        ResourceHandler.this.bundleInfo.setSize(Integer.valueOf(size));
                    }
                    catch (NumberFormatException e) {
                        ResourceHandler.this.log(1, "Invalid size for the bundle " + ResourceHandler.this.bundleInfo.getSymbolicName() + ": " + size + ". This size is then ignored.");
                    }
                }
            });
            this.addChild(new CapabilityHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) throws SAXParseException {
                    try {
                        CapabilityAdapter.adapt(ResourceHandler.this.bundleInfo, ((CapabilityHandler)child).capability);
                    }
                    catch (ParseException e) {
                        throw new SAXParseException("Invalid capability: " + e.getMessage(), child.getLocator());
                    }
                }
            });
            this.addChild(new RequireHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) throws SAXParseException {
                    try {
                        RequirementAdapter.adapt(ResourceHandler.this.bundleInfo, ((RequireHandler)child).requirement);
                    }
                    catch (UnsupportedFilterException e) {
                        throw new SAXParseException("Unsupported requirement filter: " + ((RequireHandler)child).filter + " (" + e.getMessage() + ")", ResourceHandler.this.getLocator());
                    }
                    catch (ParseException e) {
                        throw new SAXParseException("Error in the requirement filter on the bundle: " + e.getMessage(), ResourceHandler.this.getLocator());
                    }
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            Version version;
            String symbolicname = atts.getValue(SYMBOLIC_NAME);
            if (symbolicname == null) {
                this.log(0, "Resource with no symobilc name, skipping it.");
                this.skip();
                return;
            }
            String v = this.getOptionalAttribute(atts, VERSION, DEFAULT_VERSION);
            try {
                version = new Version(v);
            }
            catch (ParseException e) {
                this.log(0, "Incorrect resource version: " + v + ". The resource " + symbolicname + " is then ignored.");
                this.skip();
                return;
            }
            this.bundleInfo = new BundleInfo(symbolicname, version);
            this.bundleInfo.setPresentationName(atts.getValue(PRESENTATION_NAME));
            String uri = atts.getValue(URI);
            if (uri != null) {
                try {
                    this.bundleInfo.setUri(new URI(uri));
                }
                catch (URISyntaxException e) {
                    this.log(0, "Incorrect uri " + uri + ". The resource " + symbolicname + " is then ignored.");
                    this.skip();
                    return;
                }
            }
            this.bundleInfo.setId(atts.getValue(ID));
        }

        protected String getCurrentElementIdentifier() {
            return this.bundleInfo.getSymbolicName() + "/" + this.bundleInfo.getVersion();
        }
    }

    static class RepositoryHandler
    extends DelegetingHandler {
        static final String REPOSITORY = "repository";
        static final String LASTMODIFIED = "lastmodified";
        static final String NAME = "name";
        BundleRepoDescriptor repo;
        private final URI baseUri;

        public RepositoryHandler(URI baseUri) {
            super(REPOSITORY);
            this.baseUri = baseUri;
            this.addChild(new ResourceHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    RepositoryHandler.this.repo.addBundle(((ResourceHandler)child).bundleInfo);
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            this.repo = new BundleRepoDescriptor(this.baseUri, ExecutionEnvironmentProfileProvider.getInstance());
            this.repo.setName(atts.getValue(NAME));
            try {
                Long lastModified = this.getOptionalLongAttribute(atts, LASTMODIFIED, null);
                this.repo.setLastModified(lastModified);
            }
            catch (SAXParseException e) {
                this.log(1, e.getMessage() + ". It will be ignored.");
            }
        }
    }
}

