/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.store;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.gradle.cache.internal.BinaryStore;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.io.RandomAccessFileInputStream;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.kryo.StringDeduplicatingKryoBackedDecoder;
import org.gradle.internal.serialize.kryo.StringDeduplicatingKryoBackedEncoder;

class DefaultBinaryStore
implements BinaryStore,
Closeable {
    private File file;
    private StringDeduplicatingKryoBackedEncoder encoder;
    private long offset = -1L;

    public DefaultBinaryStore(File file) {
        this.file = file;
    }

    public void write(BinaryStore.WriteAction write) {
        if (this.encoder == null) {
            try {
                this.encoder = new StringDeduplicatingKryoBackedEncoder((OutputStream)new FileOutputStream(this.file));
            }
            catch (FileNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        if (this.offset == -1L) {
            this.offset = this.encoder.getWritePosition();
            if (this.offset == Integer.MAX_VALUE) {
                throw new IllegalStateException("Unable to write to binary store. The bytes offset has reached a point where using it is unsafe. Please report this error.");
            }
        }
        try {
            write.write((Encoder)this.encoder);
        }
        catch (Exception e) {
            throw new RuntimeException("Problems writing to " + this.diagnose(), e);
        }
    }

    private String diagnose() {
        return this.toString() + " (exist: " + this.file.exists() + ")";
    }

    public String toString() {
        return "Binary store in " + this.file;
    }

    public BinaryStore.BinaryData done() {
        try {
            if (this.encoder != null) {
                this.encoder.done();
                this.encoder.flush();
            }
            SimpleBinaryData simpleBinaryData = new SimpleBinaryData(this.file, this.offset, this.diagnose());
            return simpleBinaryData;
        }
        finally {
            this.offset = -1L;
        }
    }

    @Override
    public void close() {
        try {
            if (this.encoder != null) {
                this.encoder.close();
            }
        }
        finally {
            if (this.file != null) {
                this.file.delete();
            }
            this.encoder = null;
            this.file = null;
        }
    }

    File getFile() {
        return this.file;
    }

    long getSize() {
        return this.file.length();
    }

    private static class SimpleBinaryData
    implements BinaryStore.BinaryData {
        private final long offset;
        private final File inputFile;
        private final String sourceDescription;
        private Decoder decoder;
        private CompositeStoppable resources;

        public SimpleBinaryData(File inputFile, long offset, String sourceDescription) {
            this.inputFile = inputFile;
            this.offset = offset;
            this.sourceDescription = sourceDescription;
        }

        public <T> T read(BinaryStore.ReadAction<T> readAction) {
            try {
                if (this.decoder == null) {
                    RandomAccessFile randomAccess = new RandomAccessFile(this.inputFile, "r");
                    randomAccess.seek(this.offset);
                    this.decoder = new StringDeduplicatingKryoBackedDecoder((InputStream)new RandomAccessFileInputStream(randomAccess));
                    this.resources = new CompositeStoppable().add(new Object[]{randomAccess, this.decoder});
                }
                return (T)readAction.read(this.decoder);
            }
            catch (Exception e) {
                throw new RuntimeException("Problems reading data from " + this.sourceDescription, e);
            }
        }

        public void close() {
            try {
                if (this.resources != null) {
                    this.resources.stop();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Problems cleaning resources of " + this.sourceDescription, e);
            }
            finally {
                this.decoder = null;
                this.resources = null;
            }
        }

        public String toString() {
            return this.sourceDescription;
        }
    }
}

