/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;

public class DomainObjectProjectStateHandler {
    private final ProjectStateRegistry projectStateRegistry;
    private final DomainObjectContext domainObjectContext;
    private final ProjectFinder projectFinder;

    public DomainObjectProjectStateHandler(ProjectStateRegistry projectStateRegistry, DomainObjectContext domainObjectContext, ProjectFinder projectFinder) {
        this.projectStateRegistry = projectStateRegistry;
        this.domainObjectContext = domainObjectContext;
        this.projectFinder = projectFinder;
    }

    @Nullable
    public ProjectInternal maybeGetOwningProject() {
        if (this.domainObjectContext.getProjectPath() != null) {
            return this.projectFinder.findProject(this.domainObjectContext.getProjectPath().getPath());
        }
        return null;
    }

    public boolean hasMutableProjectState() {
        ProjectInternal project = this.maybeGetOwningProject();
        if (project != null) {
            ProjectState projectState = this.projectStateRegistry.stateFor((Project)project);
            return projectState.hasMutableState();
        }
        return true;
    }

    public void withLenientState(Runnable runnable) {
        this.projectStateRegistry.withLenientState(runnable);
    }

    public ProjectStateRegistry.SafeExclusiveLock newExclusiveOperationLock() {
        return this.projectStateRegistry.newExclusiveOperationLock();
    }
}

