/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FieldReplacer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "replacementMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "(Ljava/util/Map;)V", "getReplacementMap", "()Ljava/util/Map;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "backend"})
final class FieldReplacer
extends IrElementTransformerVoid {
    @NotNull
    private final Map<IrFieldSymbol, IrFieldSymbol> replacementMap;

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFieldSymbol irFieldSymbol = this.replacementMap.get(expression2.getSymbol());
        if (irFieldSymbol != null) {
            IrFieldSymbol irFieldSymbol2;
            IrFieldSymbol newSymbol = irFieldSymbol2 = irFieldSymbol;
            irExpression = new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), newSymbol, expression2.getType(), null, expression2.getOrigin(), expression2.getSuperQualifierSymbol());
        } else {
            irExpression = super.visitGetField(expression2);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFieldSymbol irFieldSymbol = this.replacementMap.get(expression2.getSymbol());
        if (irFieldSymbol != null) {
            IrFieldSymbol irFieldSymbol2;
            IrFieldSymbol newSymbol = irFieldSymbol2 = irFieldSymbol;
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            IrFieldSymbol irFieldSymbol3 = this.replacementMap.get(expression2.getSymbol());
            if (irFieldSymbol3 == null) {
                Intrinsics.throwNpe();
            }
            irExpression = new IrSetFieldImpl(n, n2, irFieldSymbol3, null, this.visitExpression(expression2.getValue()), expression2.getType(), expression2.getOrigin(), expression2.getSuperQualifierSymbol());
        } else {
            irExpression = super.visitSetField(expression2);
        }
        return irExpression;
    }

    @NotNull
    public final Map<IrFieldSymbol, IrFieldSymbol> getReplacementMap() {
        return this.replacementMap;
    }

    public FieldReplacer(@NotNull Map<IrFieldSymbol, ? extends IrFieldSymbol> replacementMap) {
        Intrinsics.checkParameterIsNotNull(replacementMap, (String)"replacementMap");
        this.replacementMap = replacementMap;
    }
}

