/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.plugins;

import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.artifact.MavenArtifactNotationParserFactory;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publication.WritableMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.versionmapping.DefaultVersionMappingStrategy;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenLocal;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class MavenPublishPlugin
implements Plugin<Project> {
    public static final String PUBLISH_LOCAL_LIFECYCLE_TASK_NAME = "publishToMavenLocal";
    private final InstantiatorFactory instantiatorFactory;
    private final ObjectFactory objectFactory;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FileCollectionFactory fileCollectionFactory;
    private final FeaturePreviews featurePreviews;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final ProviderFactory providerFactory;
    private CollectionCallbackActionDecorator collectionCallbackActionDecorator;

    @Inject
    public MavenPublishPlugin(InstantiatorFactory instantiatorFactory, ObjectFactory objectFactory, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, FeaturePreviews featurePreviews, ImmutableAttributesFactory immutableAttributesFactory, ProviderFactory providerFactory, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.instantiatorFactory = instantiatorFactory;
        this.objectFactory = objectFactory;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.featurePreviews = featurePreviews;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.providerFactory = providerFactory;
        this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
    }

    public void apply(final Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        TaskContainer tasks = project.getTasks();
        tasks.register(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task publish) {
                publish.setDescription("Publishes all Maven publications produced by this project to the local Maven cache.");
                publish.setGroup("publishing");
            }
        });
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(MavenPublication.class, (NamedDomainObjectFactory)new MavenPublicationFactory(MavenPublishPlugin.this.dependencyMetaDataProvider, MavenPublishPlugin.this.instantiatorFactory.decorateLenient(), MavenPublishPlugin.this.fileResolver, MavenPublishPlugin.this.collectionCallbackActionDecorator, project.getConfigurations(), project.getPluginManager(), project.getExtensions(), (AttributesSchemaInternal)project.getDependencies().getAttributesSchema()));
                MavenPublishPlugin.this.realizePublishingTasksLater(project, extension);
            }
        });
    }

    private void realizePublishingTasksLater(final Project project, PublishingExtension extension) {
        final NamedDomainObjectSet mavenPublications = extension.getPublications().withType(MavenPublicationInternal.class);
        final TaskContainer tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        final TaskProvider publishLifecycleTask = tasks.named("publish");
        final TaskProvider publishLocalLifecycleTask = tasks.named(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
        final NamedDomainObjectList repositories = extension.getRepositories().withType(MavenArtifactRepository.class);
        repositories.all(repository -> tasks.register(this.publishAllToSingleRepoTaskName((MavenArtifactRepository)repository), publish -> {
            publish.setDescription("Publishes all Maven publications produced by this project to the " + repository.getName() + " repository.");
            publish.setGroup("publishing");
        }));
        mavenPublications.all((Action)new Action<MavenPublicationInternal>(){

            public void execute(MavenPublicationInternal publication) {
                MavenPublishPlugin.this.createGenerateMetadataTask(tasks, publication, (Set)mavenPublications, buildDirectory);
                MavenPublishPlugin.this.createGeneratePomTask(tasks, publication, buildDirectory, project);
                MavenPublishPlugin.this.createLocalInstallTask(tasks, (TaskProvider<Task>)publishLocalLifecycleTask, publication);
                MavenPublishPlugin.this.createPublishTasksForEachMavenRepo(tasks, (TaskProvider<Task>)publishLifecycleTask, publication, (NamedDomainObjectList<MavenArtifactRepository>)repositories);
            }
        });
    }

    private String publishAllToSingleRepoTaskName(MavenArtifactRepository repository) {
        return "publishAllPublicationsTo" + StringUtils.capitalize((String)repository.getName()) + "Repository";
    }

    private void createPublishTasksForEachMavenRepo(final TaskContainer tasks, final TaskProvider<Task> publishLifecycleTask, final MavenPublicationInternal publication, NamedDomainObjectList<MavenArtifactRepository> repositories) {
        final String publicationName = publication.getName();
        repositories.all((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository repository) {
                String repositoryName = repository.getName();
                String publishTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationTo" + StringUtils.capitalize((String)repositoryName) + "Repository";
                tasks.register(publishTaskName, PublishToMavenRepository.class, publishTask -> {
                    publishTask.setPublication(publication);
                    publishTask.setRepository(repository);
                    publishTask.setGroup("publishing");
                    publishTask.setDescription("Publishes Maven publication '" + publicationName + "' to Maven repository '" + repositoryName + "'.");
                });
                publishLifecycleTask.configure(task -> task.dependsOn(new Object[]{publishTaskName}));
                tasks.named(MavenPublishPlugin.this.publishAllToSingleRepoTaskName(repository), publish -> publish.dependsOn(new Object[]{publishTaskName}));
            }
        });
    }

    private void createLocalInstallTask(TaskContainer tasks, TaskProvider<Task> publishLocalLifecycleTask, final MavenPublicationInternal publication) {
        final String publicationName = publication.getName();
        final String installTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationToMavenLocal";
        tasks.register(installTaskName, PublishToMavenLocal.class, (Action)new Action<PublishToMavenLocal>(){

            public void execute(PublishToMavenLocal publishLocalTask) {
                publishLocalTask.setPublication(publication);
                publishLocalTask.setGroup("publishing");
                publishLocalTask.setDescription("Publishes Maven publication '" + publicationName + "' to the local Maven repository.");
            }
        });
        publishLocalLifecycleTask.configure((Action)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{installTaskName});
            }
        });
    }

    private void createGeneratePomTask(TaskContainer tasks, final MavenPublicationInternal publication, final DirectoryProperty buildDir, final Project project) {
        final String publicationName = publication.getName();
        String descriptorTaskName = "generatePomFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateMavenPom.class, (Action)new Action<GenerateMavenPom>(){

            public void execute(GenerateMavenPom generatePomTask) {
                generatePomTask.setDescription("Generates the Maven POM file for publication '" + publicationName + "'.");
                generatePomTask.setGroup("publishing");
                generatePomTask.setPom(publication.getPom());
                if (generatePomTask.getDestination() == null) {
                    generatePomTask.setDestination(buildDir.file("publications/" + publication.getName() + "/pom-default.xml"));
                }
                project.getPluginManager().withPlugin("org.gradle.java", plugin -> generatePomTask.withCompileScopeAttributes(MavenPublishPlugin.this.immutableAttributesFactory.of(Usage.USAGE_ATTRIBUTE, (Object)((Usage)MavenPublishPlugin.this.objectFactory.named(Usage.class, "java-api-jars")))).withRuntimeScopeAttributes(MavenPublishPlugin.this.immutableAttributesFactory.of(Usage.USAGE_ATTRIBUTE, (Object)((Usage)MavenPublishPlugin.this.objectFactory.named(Usage.class, "java-runtime-jars")))));
            }
        });
        publication.setPomGenerator((Task)generatorTask.get());
    }

    private void createGenerateMetadataTask(TaskContainer tasks, final MavenPublicationInternal publication, final Set<? extends MavenPublicationInternal> publications, final DirectoryProperty buildDir) {
        final String publicationName = publication.getName();
        String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateModuleMetadata.class, (Action)new Action<GenerateModuleMetadata>(){

            public void execute(GenerateModuleMetadata generateTask) {
                generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
                generateTask.setGroup("publishing");
                generateTask.getPublication().set((Object)publication);
                generateTask.getPublications().set((Iterable)publications);
                generateTask.getOutputFile().convention(buildDir.file("publications/" + publication.getName() + "/module.json"));
            }
        });
        publication.setModuleDescriptorGenerator((Task)generatorTask.get());
    }

    private class MavenPublicationFactory
    implements NamedDomainObjectFactory<MavenPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;
        private CollectionCallbackActionDecorator collectionCallbackActionDecorator;
        private final ConfigurationContainer configurations;
        private final PluginManager plugins;
        private final ExtensionContainer extensionContainer;
        private final AttributesSchemaInternal attributesSchema;

        private MavenPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver, CollectionCallbackActionDecorator collectionCallbackActionDecorator, ConfigurationContainer configurations, PluginManager plugins, ExtensionContainer extensionContainer, AttributesSchemaInternal attributesSchema) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
            this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
            this.configurations = configurations;
            this.plugins = plugins;
            this.extensionContainer = extensionContainer;
            this.attributesSchema = attributesSchema;
        }

        public MavenPublication create(String name) {
            MutableMavenProjectIdentity projectIdentity = this.createProjectIdentity();
            NotationParser<Object, MavenArtifact> artifactNotationParser = new MavenArtifactNotationParserFactory(this.instantiator, this.fileResolver).create();
            VersionMappingStrategyInternal versionMappingStrategy = (VersionMappingStrategyInternal)this.instantiator.newInstance(DefaultVersionMappingStrategy.class, new Object[]{MavenPublishPlugin.this.objectFactory, this.configurations, this.attributesSchema, MavenPublishPlugin.this.immutableAttributesFactory});
            this.configureDefaultConfigurationsUsedWhenMappingToResolvedVersions(versionMappingStrategy);
            return (MavenPublication)this.instantiator.newInstance(DefaultMavenPublication.class, new Object[]{name, projectIdentity, artifactNotationParser, this.instantiator, MavenPublishPlugin.this.objectFactory, MavenPublishPlugin.this.projectDependencyResolver, MavenPublishPlugin.this.fileCollectionFactory, MavenPublishPlugin.this.featurePreviews, MavenPublishPlugin.this.immutableAttributesFactory, this.collectionCallbackActionDecorator, versionMappingStrategy});
        }

        private void configureDefaultConfigurationsUsedWhenMappingToResolvedVersions(VersionMappingStrategyInternal versionMappingStrategy) {
            this.plugins.withPlugin("org.gradle.java", plugin -> {
                SourceSet mainSourceSet = (SourceSet)((SourceSetContainer)this.extensionContainer.getByType(SourceSetContainer.class)).getByName("main");
                versionMappingStrategy.defaultResolutionConfiguration("java-api", mainSourceSet.getCompileClasspathConfigurationName());
                versionMappingStrategy.defaultResolutionConfiguration("java-runtime", mainSourceSet.getRuntimeClasspathConfigurationName());
            });
            this.plugins.withPlugin("org.gradle.java-platform", plugin -> {
                versionMappingStrategy.defaultResolutionConfiguration("java-api", "classpath");
                versionMappingStrategy.defaultResolutionConfiguration("java-runtime", "classpath");
            });
        }

        private MutableMavenProjectIdentity createProjectIdentity() {
            final Module module = this.dependencyMetaDataProvider.getModule();
            WritableMavenProjectIdentity projectIdentity = new WritableMavenProjectIdentity(MavenPublishPlugin.this.objectFactory);
            projectIdentity.getGroupId().set(MavenPublishPlugin.this.providerFactory.provider((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return module.getGroup();
                }
            }));
            projectIdentity.getArtifactId().set(MavenPublishPlugin.this.providerFactory.provider((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return module.getName();
                }
            }));
            projectIdentity.getVersion().set(MavenPublishPlugin.this.providerFactory.provider((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return module.getVersion();
                }
            }));
            return projectIdentity;
        }
    }
}

