/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0007\u001a(\u0010\n\u001a\u00020\u0001*\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0007\u001a\u001c\u0010\u0010\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0007\u001a\u0014\u0010\u0017\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0007\u001a\u0014\u0010\u001c\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\"\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010#\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010$\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010&\u001a\u00020\u0001*\u00020\u0007\u00a8\u0006'"}, d2={"classFqNameEquals", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "isAny", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isArray", "isBoolean", "isBuiltInClassType", "descriptorPredicate", "Lkotlin/Function1;", "hasQuestionMark", "isByte", "isChar", "isClassType", "isComparable", "isDouble", "isFloat", "isInt", "isLong", "isMarkedNullable", "isNotNullClassType", "isNothing", "isNullableAny", "isNullableBoolean", "isNullableChar", "isNullableClassType", "isNullableLong", "isNullablePrimitiveType", "isNullableString", "isNullableUnit", "isNumber", "isPrimitiveType", "isShort", "isString", "isUnit", "isUnitOrNullableUnit", "ir.tree"})
public final class IrTypePredicatesKt {
    private static final boolean isBuiltInClassType(@NotNull IrType $receiver, Function1<? super ClassDescriptor, Boolean> descriptorPredicate, boolean hasQuestionMark) {
        if (!($receiver instanceof IrSimpleType)) {
            return false;
        }
        if (((IrSimpleType)$receiver).getHasQuestionMark() != hasQuestionMark) {
            return false;
        }
        IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$receiver).getClassifier();
        if (!(irClassifierSymbol instanceof IrClassSymbol)) {
            irClassifierSymbol = null;
        }
        IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
        if (irClassSymbol == null) {
            return false;
        }
        IrClassSymbol classSymbol = irClassSymbol;
        return (Boolean)descriptorPredicate.invoke(classSymbol.getDescriptor());
    }

    private static final boolean isNotNullClassType(@NotNull IrType $receiver, FqNameUnsafe fqName2) {
        return IrTypePredicatesKt.isClassType($receiver, fqName2, false);
    }

    private static final boolean isNullableClassType(@NotNull IrType $receiver, FqNameUnsafe fqName2) {
        return IrTypePredicatesKt.isClassType($receiver, fqName2, true);
    }

    private static final boolean isClassType(@NotNull IrType $receiver, FqNameUnsafe fqName2, boolean hasQuestionMark) {
        if (!($receiver instanceof IrSimpleType)) {
            return false;
        }
        if (((IrSimpleType)$receiver).getHasQuestionMark() != hasQuestionMark) {
            return false;
        }
        IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$receiver).getClassifier();
        if (!(irClassifierSymbol instanceof IrClassSymbol)) {
            irClassifierSymbol = null;
        }
        IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
        if (irClassSymbol == null) {
            return false;
        }
        IrClassSymbol classSymbol = irClassSymbol;
        return IrTypePredicatesKt.classFqNameEquals((ClassDescriptor)classSymbol.getDescriptor(), fqName2);
    }

    private static final boolean classFqNameEquals(ClassDescriptor descriptor2, FqNameUnsafe fqName2) {
        return Intrinsics.areEqual((Object)descriptor2.getName(), (Object)fqName2.shortName()) && Intrinsics.areEqual((Object)fqName2, (Object)DescriptorUtils.getFqName(descriptor2));
    }

    public static final boolean isAny(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IrTypePredicatesKt.isBuiltInClassType($receiver, (Function1<? super ClassDescriptor, Boolean>)((Function1)isAny.1.INSTANCE), false);
    }

    public static final boolean isNullableAny(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IrTypePredicatesKt.isBuiltInClassType($receiver, (Function1<? super ClassDescriptor, Boolean>)((Function1)isNullableAny.1.INSTANCE), true);
    }

    public static final boolean isString(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.string");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isNullableString(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.string");
        return IrTypePredicatesKt.isNullableClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isArray(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.array;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.array");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isNothing(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.nothing;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.nothing");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isPrimitiveType(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IrTypePredicatesKt.isBuiltInClassType($receiver, (Function1<? super ClassDescriptor, Boolean>)((Function1)isPrimitiveType.1.INSTANCE), false);
    }

    public static final boolean isNullablePrimitiveType(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IrTypePredicatesKt.isBuiltInClassType($receiver, (Function1<? super ClassDescriptor, Boolean>)((Function1)isNullablePrimitiveType.1.INSTANCE), true);
    }

    public static final boolean isMarkedNullable(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        IrType irType = $receiver;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        return irSimpleType != null ? irSimpleType.getHasQuestionMark() : false;
    }

    public static final boolean isUnit(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.unit;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.unit");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isNullableUnit(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.unit;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.unit");
        return IrTypePredicatesKt.isNullableClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isUnitOrNullableUnit(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IrTypePredicatesKt.isUnit($receiver) || IrTypePredicatesKt.isNullableUnit($receiver);
    }

    public static final boolean isBoolean(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._boolean;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._boolean");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isChar(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._char;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._char");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isByte(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._byte;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._byte");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isShort(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._short;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._short");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isInt(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._int;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._int");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isLong(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._long;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._long");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isFloat(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._float;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._float");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isDouble(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._double;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._double");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isNumber(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.number;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.number");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isComparable(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.comparable.toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.comparable.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isNullableBoolean(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._boolean;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._boolean");
        return IrTypePredicatesKt.isNullableClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isNullableLong(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._long;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._long");
        return IrTypePredicatesKt.isNullableClassType($receiver, fqNameUnsafe);
    }

    public static final boolean isNullableChar(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._char;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._char");
        return IrTypePredicatesKt.isNullableClassType($receiver, fqNameUnsafe);
    }
}

