/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.DefaultFileChange;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.FilePathWithType;
import org.gradle.internal.hash.Hasher;

public class NormalizedPathFingerprintCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new NormalizedPathFingerprintCompareStrategy();
    private static final Comparator<Map.Entry<FileSystemLocationFingerprint, ?>> ENTRY_COMPARATOR = new Comparator<Map.Entry<FileSystemLocationFingerprint, ?>>(){

        @Override
        public int compare(Map.Entry<FileSystemLocationFingerprint, ?> o1, Map.Entry<FileSystemLocationFingerprint, ?> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    private NormalizedPathFingerprintCompareStrategy() {
    }

    @Override
    protected boolean doVisitChangesSince(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> currentFingerprints, Map<String, FileSystemLocationFingerprint> previousFingerprints, String propertyTitle, boolean includeAdded) {
        FileSystemLocationFingerprint previousFingerprint;
        ListMultimap unaccountedForPreviousFiles = MultimapBuilder.hashKeys((int)previousFingerprints.size()).linkedListValues().build();
        ListMultimap addedFilesByNormalizedPath = MultimapBuilder.linkedHashKeys().linkedListValues().build();
        for (Map.Entry<String, FileSystemLocationFingerprint> entry : previousFingerprints.entrySet()) {
            String absolutePath = entry.getKey();
            previousFingerprint = entry.getValue();
            unaccountedForPreviousFiles.put((Object)previousFingerprint, (Object)new FilePathWithType(absolutePath, previousFingerprint.getType()));
        }
        for (Map.Entry<String, FileSystemLocationFingerprint> entry : currentFingerprints.entrySet()) {
            String currentAbsolutePath = entry.getKey();
            FileSystemLocationFingerprint currentFingerprint = entry.getValue();
            List previousFilesForFingerprint = unaccountedForPreviousFiles.get((Object)currentFingerprint);
            if (previousFilesForFingerprint.isEmpty()) {
                addedFilesByNormalizedPath.put((Object)currentFingerprint.getNormalizedPath(), (Object)new FilePathWithType(currentAbsolutePath, currentFingerprint.getType()));
                continue;
            }
            previousFilesForFingerprint.remove(0);
        }
        ArrayList unaccountedForPreviousEntries = Lists.newArrayList((Iterable)unaccountedForPreviousFiles.entries());
        Collections.sort(unaccountedForPreviousEntries, ENTRY_COMPARATOR);
        for (Map.Entry unaccountedForPreviousFingerprintEntry : unaccountedForPreviousEntries) {
            FilePathWithType removedFile;
            DefaultFileChange removed;
            FilePathWithType addedFile;
            DefaultFileChange modified;
            previousFingerprint = (FileSystemLocationFingerprint)unaccountedForPreviousFingerprintEntry.getKey();
            String normalizedPath = previousFingerprint.getNormalizedPath();
            List addedFilesForNormalizedPath = addedFilesByNormalizedPath.get((Object)normalizedPath);
            if (!(!addedFilesForNormalizedPath.isEmpty() ? !visitor.visitChange(modified = DefaultFileChange.modified((addedFile = (FilePathWithType)addedFilesForNormalizedPath.remove(0)).getAbsolutePath(), propertyTitle, previousFingerprint.getType(), addedFile.getFileType(), normalizedPath)) : !visitor.visitChange(removed = DefaultFileChange.removed((removedFile = (FilePathWithType)unaccountedForPreviousFingerprintEntry.getValue()).getAbsolutePath(), propertyTitle, removedFile.getFileType(), normalizedPath)))) continue;
            return false;
        }
        if (includeAdded) {
            for (Map.Entry entry : addedFilesByNormalizedPath.entries()) {
                FilePathWithType addedFile = (FilePathWithType)entry.getValue();
                DefaultFileChange added = DefaultFileChange.added(addedFile.getAbsolutePath(), propertyTitle, addedFile.getFileType(), (String)entry.getKey());
                if (visitor.visitChange(added)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
        NormalizedPathFingerprintCompareStrategy.appendSortedToHasher(hasher, fingerprints);
    }

    public static void appendSortedToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
        ArrayList sortedFingerprints = Lists.newArrayList(fingerprints);
        Collections.sort(sortedFingerprints);
        for (FileSystemLocationFingerprint normalizedSnapshot : sortedFingerprints) {
            normalizedSnapshot.appendToHasher(hasher);
        }
    }
}

