/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumMap;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.LocalJavaInstallation;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.JavaExecAction;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class JavaInstallationProbe {
    public static final String UNKNOWN = "unknown";
    private final LoadingCache<File, EnumMap<SysProp, String>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<File, EnumMap<SysProp, String>>(){

        public EnumMap<SysProp, String> load(File javaHome) throws Exception {
            if (Jvm.current().getJavaHome().equals(javaHome)) {
                return JavaInstallationProbe.this.getCurrentJvmMetadata();
            }
            return JavaInstallationProbe.this.getMetadataInternal(javaHome);
        }
    });
    private final ExecActionFactory factory;

    public JavaInstallationProbe(ExecActionFactory factory) {
        this.factory = factory;
    }

    public void current(LocalJavaInstallation currentJava) {
        ProbeResult.success(InstallType.IS_JDK, JavaInstallationProbe.current()).configure(currentJava);
    }

    public ProbeResult checkJdk(File jdkPath) {
        if (!jdkPath.exists()) {
            return ProbeResult.failure(InstallType.NO_SUCH_DIRECTORY, "No such directory: " + jdkPath);
        }
        EnumMap metadata = (EnumMap)this.cache.getUnchecked((Object)jdkPath);
        String version = (String)metadata.get((Object)SysProp.VERSION);
        if (UNKNOWN.equals(version)) {
            return ProbeResult.failure(InstallType.INVALID_JDK, (String)metadata.get((Object)SysProp.Z_ERROR));
        }
        try {
            JavaVersion.toVersion((Object)version);
        }
        catch (IllegalArgumentException ex) {
            return ProbeResult.failure(InstallType.INVALID_JDK, "Cannot parse version number: " + version);
        }
        if (JavaInstallationProbe.javaExe(jdkPath, "javac").exists()) {
            return ProbeResult.success(InstallType.IS_JDK, metadata);
        }
        return ProbeResult.success(InstallType.IS_JRE, metadata);
    }

    private EnumMap<SysProp, String> getCurrentJvmMetadata() {
        EnumMap<SysProp, String> result = new EnumMap<SysProp, String>(SysProp.class);
        for (SysProp type : SysProp.values()) {
            if (type == SysProp.Z_ERROR) continue;
            result.put(type, System.getProperty(type.sysProp, UNKNOWN));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumMap<SysProp, String> getMetadataInternal(File jdkPath) {
        JavaExecAction exec = this.factory.newJavaExecAction();
        exec.executable((Object)JavaInstallationProbe.javaExe(jdkPath, "java"));
        File workingDir = Files.createTempDir();
        exec.setWorkingDir(workingDir);
        exec.classpath(new Object[]{workingDir});
        try {
            JavaInstallationProbe.writeProbe(workingDir);
            exec.setMain("JavaProbe");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exec.setStandardOutput((OutputStream)baos);
            ByteArrayOutputStream errorOutput = new ByteArrayOutputStream();
            exec.setErrorOutput((OutputStream)errorOutput);
            exec.setIgnoreExitValue(true);
            ExecResult result = exec.execute();
            int exitValue = result.getExitValue();
            if (exitValue == 0) {
                EnumMap<SysProp, String> enumMap = JavaInstallationProbe.parseExecOutput(baos.toString());
                return enumMap;
            }
            EnumMap<SysProp, String> enumMap = JavaInstallationProbe.error("Command returned unexpected result code: " + exitValue + "\nError output:\n" + errorOutput);
            return enumMap;
        }
        catch (ExecException ex) {
            EnumMap<SysProp, String> enumMap = JavaInstallationProbe.error(ex.getMessage());
            return enumMap;
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)workingDir);
            }
            catch (IOException e) {
                throw new GradleException("Unable to delete temp directory", (Throwable)e);
            }
        }
    }

    private static String computeJdkName(InstallType result, EnumMap<SysProp, String> metadata) {
        String basename = result == InstallType.IS_JDK ? "JDK" : "JRE";
        String vendor = metadata.get((Object)SysProp.VENDOR);
        if (vendor == null) {
            return basename;
        }
        if ((vendor = vendor.toLowerCase()).contains("apple")) {
            return "Apple " + basename;
        }
        if (vendor.contains("oracle") || vendor.contains("sun")) {
            String vm = metadata.get((Object)SysProp.VM);
            if (vm != null && vm.contains("OpenJDK")) {
                return result == InstallType.IS_JDK ? "OpenJDK" : "OpenJDK JRE";
            }
            return "Oracle " + basename;
        }
        if (vendor.contains("ibm")) {
            return "IBM " + basename;
        }
        if (vendor.contains("azul systems")) {
            return "Zulu " + basename;
        }
        if (vendor.contains("hewlett-packard")) {
            return "HP-UX " + basename;
        }
        return basename;
    }

    private static void writeProbe(File workingDir) {
        File probeFile = new File(workingDir, "JavaProbe.class");
        try {
            IoActions.withResource((Closeable)new FileOutputStream(probeFile), (Action)new ErroringAction<FileOutputStream>(){

                protected void doExecute(FileOutputStream thing) throws Exception {
                    thing.write(JavaProbe.dump());
                }
            });
        }
        catch (FileNotFoundException e) {
            throw new GradleException("Unable to write Java probe file", (Throwable)e);
        }
    }

    private static File javaExe(File jdkPath, String command) {
        return new File(new File(jdkPath, "bin"), OperatingSystem.current().getExecutableName(command));
    }

    private static EnumMap<SysProp, String> parseExecOutput(String probeResult) {
        String[] split = probeResult.split(System.getProperty("line.separator"));
        if (split.length != SysProp.values().length - 1) {
            return JavaInstallationProbe.error("Unexpected command output: \n" + probeResult);
        }
        EnumMap<SysProp, String> result = new EnumMap<SysProp, String>(SysProp.class);
        for (SysProp type : SysProp.values()) {
            if (type == SysProp.Z_ERROR) continue;
            result.put(type, split[type.ordinal()]);
        }
        return result;
    }

    private static EnumMap<SysProp, String> error(String message) {
        EnumMap<SysProp, String> result = new EnumMap<SysProp, String>(SysProp.class);
        for (SysProp type : SysProp.values()) {
            result.put(type, UNKNOWN);
        }
        result.put(SysProp.Z_ERROR, message);
        return result;
    }

    private static EnumMap<SysProp, String> current() {
        EnumMap<SysProp, String> result = new EnumMap<SysProp, String>(SysProp.class);
        for (SysProp type : SysProp.values()) {
            result.put(type, System.getProperty(type.sysProp, UNKNOWN));
        }
        return result;
    }

    private static class JavaProbe
    implements Opcodes {
        public static final String CLASSNAME = "JavaProbe";

        private JavaProbe() {
        }

        public static byte[] dump() throws Exception {
            ClassWriter cw = new ClassWriter(0);
            JavaProbe.createClassHeader(cw);
            JavaProbe.createConstructor(cw);
            JavaProbe.createMainMethod(cw);
            cw.visitEnd();
            return cw.toByteArray();
        }

        private static void createClassHeader(ClassWriter cw) {
            cw.visit(196653, 33, CLASSNAME, null, "java/lang/Object", null);
        }

        private static void createMainMethod(ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(9, "main", "([Ljava/lang/String;)V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            for (SysProp type : SysProp.values()) {
                if (type == SysProp.Z_ERROR) continue;
                JavaProbe.dumpProperty(mv, type.sysProp);
            }
            mv.visitInsn(177);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable("args", "[Ljava/lang/String;", null, l0, l3, 0);
            mv.visitMaxs(3, 1);
            mv.visitEnd();
        }

        private static void dumpProperty(MethodVisitor mv, String property) {
            mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            mv.visitLdcInsn((Object)property);
            mv.visitLdcInsn((Object)JavaInstallationProbe.UNKNOWN);
            mv.visitMethodInsn(184, "java/lang/System", "getProperty", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", false);
            mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
        }

        private static void createConstructor(ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            mv.visitInsn(177);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "LJavaProbe;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }

    public static enum InstallType {
        IS_JDK,
        IS_JRE,
        NO_SUCH_DIRECTORY,
        INVALID_JDK;

    }

    public static class ProbeResult {
        private final EnumMap<SysProp, String> metadata;
        private final InstallType installType;
        private final String error;

        public static ProbeResult success(InstallType installType, EnumMap<SysProp, String> metadata) {
            return new ProbeResult(installType, metadata, null);
        }

        public static ProbeResult failure(InstallType installType, String error) {
            return new ProbeResult(installType, null, error);
        }

        private ProbeResult(InstallType installType, EnumMap<SysProp, String> metadata, String error) {
            this.installType = installType;
            this.metadata = metadata;
            this.error = error;
        }

        public InstallType getInstallType() {
            return this.installType;
        }

        public String getError() {
            return this.error;
        }

        public void configure(LocalJavaInstallation install) {
            if (this.error != null) {
                throw new IllegalStateException("Unable to configure Java installation, probing failed with the following message: " + this.error);
            }
            JavaVersion javaVersion = JavaVersion.toVersion((Object)this.metadata.get((Object)SysProp.VERSION));
            install.setJavaVersion(javaVersion);
            String jdkName = JavaInstallationProbe.computeJdkName(this.installType, this.metadata);
            install.setDisplayName(jdkName + " " + javaVersion.getMajorVersion());
        }
    }

    private static enum SysProp {
        VERSION("java.version"),
        VENDOR("java.vendor"),
        ARCH("os.arch"),
        VM("java.vm.name"),
        VM_VERSION("java.vm.version"),
        RUNTIME("java.runtime.name"),
        Z_ERROR("Internal");

        private final String sysProp;

        private SysProp(String sysProp) {
            this.sysProp = sysProp;
        }
    }
}

