/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.internal.resolve.LibraryResolutionErrorMessageBuilder;
import org.gradle.api.internal.resolve.LibraryResolutionResult;
import org.gradle.api.internal.resolve.LocalLibraryMetaDataAdapter;
import org.gradle.api.internal.resolve.LocalLibraryResolver;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.internal.resolve.VariantBinarySelector;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.MetadataSourcedComponentArtifacts;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.Binary;
import org.gradle.platform.base.VariantComponent;

public class LocalLibraryDependencyResolver
implements DependencyToComponentIdResolver,
ComponentMetaDataResolver,
ArtifactResolver,
OriginArtifactSelector,
ComponentResolvers {
    private final VariantBinarySelector variantSelector;
    private final LibraryResolutionErrorMessageBuilder errorMessageBuilder;
    private final LocalLibraryMetaDataAdapter libraryMetaDataAdapter;
    private final LocalLibraryResolver libraryResolver;
    private final Class<? extends Binary> binaryType;
    private final Predicate<VariantComponent> binaryPredicate;
    private final ProjectModelResolver projectModelResolver;

    public LocalLibraryDependencyResolver(final Class<? extends Binary> binaryType, ProjectModelResolver projectModelResolver, LocalLibraryResolver libraryResolver, VariantBinarySelector variantSelector, LocalLibraryMetaDataAdapter libraryMetaDataAdapter, LibraryResolutionErrorMessageBuilder errorMessageBuilder) {
        this.libraryMetaDataAdapter = libraryMetaDataAdapter;
        this.variantSelector = variantSelector;
        this.errorMessageBuilder = errorMessageBuilder;
        this.projectModelResolver = projectModelResolver;
        this.libraryResolver = libraryResolver;
        this.binaryType = binaryType;
        this.binaryPredicate = new Predicate<VariantComponent>(){

            public boolean apply(VariantComponent input) {
                return Iterables.any(input.getVariants(), (Predicate)new Predicate<Binary>(){

                    public boolean apply(Binary input) {
                        return binaryType.isAssignableFrom(input.getClass());
                    }
                });
            }
        };
    }

    public ArtifactResolver getArtifactResolver() {
        return this;
    }

    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this;
    }

    public ComponentMetaDataResolver getComponentResolver() {
        return this;
    }

    public OriginArtifactSelector getArtifactSelector() {
        return this;
    }

    public void resolve(DependencyMetadata dependency, VersionSelector acceptor, VersionSelector rejector, BuildableComponentIdResolveResult result) {
        if (dependency.getSelector() instanceof LibraryComponentSelector) {
            LibraryComponentSelector selector = (LibraryComponentSelector)dependency.getSelector();
            this.resolveLibraryAndChooseBinary(result, selector);
        }
    }

    private void resolveLibraryAndChooseBinary(BuildableComponentIdResolveResult result, LibraryComponentSelector selector) {
        String selectorProjectPath = selector.getProjectPath();
        final String libraryName = selector.getLibraryName();
        String variant = selector.getVariant();
        LibraryResolutionResult resolutionResult = this.doResolve(selectorProjectPath, libraryName);
        VariantComponent selectedLibrary = resolutionResult.getSelectedLibrary();
        if (selectedLibrary == null) {
            String message = resolutionResult.toResolutionErrorMessage(selector);
            ModuleVersionResolveException failure = new ModuleVersionResolveException((ComponentSelector)selector, (Throwable)((Object)new LibraryResolveException(message)));
            result.failed(failure);
            return;
        }
        final Collection<? extends Binary> matchingVariants = this.chooseMatchingVariants(selectedLibrary, variant);
        if (matchingVariants.isEmpty()) {
            final Iterable<? extends Binary> values = selectedLibrary.getVariants();
            result.failed(new ModuleVersionResolveException((ComponentSelector)selector, (Factory)new Factory<String>(){

                @Nullable
                public String create() {
                    return LocalLibraryDependencyResolver.this.errorMessageBuilder.noCompatibleVariantErrorMessage(libraryName, values);
                }
            }));
        } else if (matchingVariants.size() > 1) {
            result.failed(new ModuleVersionResolveException((ComponentSelector)selector, (Factory)new Factory<String>(){

                @Nullable
                public String create() {
                    return LocalLibraryDependencyResolver.this.errorMessageBuilder.multipleCompatibleVariantsErrorMessage(libraryName, matchingVariants);
                }
            }));
        } else {
            Binary selectedBinary = matchingVariants.iterator().next();
            LocalComponentMetadata metaData = variant == null ? this.libraryMetaDataAdapter.createLocalComponentMetaData(selectedBinary, selectorProjectPath, false) : this.libraryMetaDataAdapter.createLocalComponentMetaData(selectedBinary, selectorProjectPath, true);
            result.resolved((ComponentResolveMetadata)metaData);
        }
    }

    @Nullable
    private LibraryResolutionResult doResolve(String selectorProjectPath, String libraryName) {
        try {
            ModelRegistry projectModel = this.projectModelResolver.resolveProjectModel(selectorProjectPath);
            Collection<VariantComponent> candidates = this.libraryResolver.resolveCandidates(projectModel, libraryName);
            if (candidates.isEmpty()) {
                return LibraryResolutionResult.emptyResolutionResult(this.binaryType);
            }
            return LibraryResolutionResult.of(this.binaryType, candidates, libraryName, this.binaryPredicate);
        }
        catch (UnknownProjectException e) {
            return LibraryResolutionResult.projectNotFound(this.binaryType);
        }
    }

    private Collection<? extends Binary> chooseMatchingVariants(VariantComponent selectedLibrary, String variant) {
        return this.variantSelector.selectVariants(selectedLibrary, variant);
    }

    public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
        if (this.isLibrary(identifier)) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    public boolean isFetchingMetadataCheap(ComponentIdentifier identifier) {
        return true;
    }

    private boolean isLibrary(ComponentIdentifier identifier) {
        return identifier instanceof LibraryBinaryIdentifier;
    }

    @Nullable
    public ArtifactSet resolveArtifacts(ComponentResolveMetadata component, ConfigurationMetadata configuration, ArtifactTypeRegistry artifactTypeRegistry, ModuleExclusion exclusions, ImmutableAttributes overriddenAttributes) {
        ComponentIdentifier componentId = component.getId();
        if (this.isLibrary(componentId)) {
            return new MetadataSourcedComponentArtifacts().getArtifactsFor(component, configuration, (ArtifactResolver)this, new ConcurrentHashMap(), artifactTypeRegistry, exclusions, overriddenAttributes);
        }
        return null;
    }

    public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        if (this.isLibrary(component.getId())) {
            result.resolved(Collections.emptySet());
        }
    }

    public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        if (this.isLibrary(artifact.getComponentId())) {
            if (artifact instanceof PublishArtifactLocalArtifactMetadata) {
                result.resolved((Object)((PublishArtifactLocalArtifactMetadata)artifact).getFile());
            } else {
                result.failed((Throwable)new ArtifactResolveException("Unsupported artifact metadata type: " + artifact));
            }
        }
    }
}

