/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.DefaultInstantiatorFactory;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.WorkerSharedGlobalScopeServices;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.FlatClassLoaderStructure;
import org.gradle.workers.internal.FlatClassLoaderWorker;
import org.gradle.workers.internal.IsolatedClassloaderWorker;
import org.gradle.workers.internal.SerializedActionExecutionSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerDaemonMessageSerializer;
import org.gradle.workers.internal.WorkerProtocol;

public class WorkerDaemonServer
implements WorkerProtocol {
    private final ServiceRegistry serviceRegistry;
    private Worker isolatedClassloaderWorker;

    @Inject
    public WorkerDaemonServer(ServiceRegistry parent, RequestArgumentSerializers argumentSerializers) {
        this.serviceRegistry = WorkerDaemonServer.createWorkerDaemonServices(parent);
        argumentSerializers.add(WorkerDaemonMessageSerializer.create());
    }

    static ServiceRegistry createWorkerDaemonServices(ServiceRegistry parent) {
        ServiceRegistry workerSharedGlobalServices = ServiceRegistryBuilder.builder().parent(parent).provider((Object)new WorkerSharedGlobalScopeServices()).build();
        return new WorkerDaemonServices(workerSharedGlobalServices);
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        try {
            SerializedActionExecutionSpec classloaderActionExecutionSpec = (SerializedActionExecutionSpec)spec;
            Worker worker = this.getIsolatedClassloaderWorker(classloaderActionExecutionSpec.getClassLoaderStructure());
            return worker.execute(classloaderActionExecutionSpec);
        }
        catch (Throwable t) {
            return new DefaultWorkResult(true, t);
        }
    }

    private Worker getIsolatedClassloaderWorker(ClassLoaderStructure classLoaderStructure) {
        if (this.isolatedClassloaderWorker == null) {
            this.isolatedClassloaderWorker = classLoaderStructure instanceof FlatClassLoaderStructure ? new FlatClassLoaderWorker(this.getClass().getClassLoader(), this.serviceRegistry) : new IsolatedClassloaderWorker(classLoaderStructure, this.getClass().getClassLoader(), this.serviceRegistry, true);
        }
        return this.isolatedClassloaderWorker;
    }

    public String toString() {
        return "WorkerDaemonServer{}";
    }

    private static class WorkerDaemonServices
    extends DefaultServiceRegistry {
        public WorkerDaemonServices(ServiceRegistry ... parents) {
            super("WorkerDaemonServices", parents);
        }

        InstantiatorFactory createInstantiatorFactory(CrossBuildInMemoryCacheFactory cacheFactory) {
            return new DefaultInstantiatorFactory(cacheFactory, Collections.emptyList());
        }

        WorkerDaemonServices createWorkerDaemonServices() {
            return this;
        }
    }
}

