/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.gradle.api.file.internal.FilePathUtil;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.IoActions;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarHasher
implements RegularFileHasher,
ConfigurableNormalizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarHasher.class);
    private final ResourceHasher classpathResourceHasher;
    private final ResourceFilter classpathResourceFilter;

    public JarHasher(ResourceHasher classpathResourceHasher, ResourceFilter classpathResourceFilter) {
        this.classpathResourceHasher = classpathResourceHasher;
        this.classpathResourceFilter = classpathResourceFilter;
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return this.hashJarContents(fileSnapshot);
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getClass().getName());
        this.classpathResourceHasher.appendConfigurationToHasher(hasher);
        this.classpathResourceFilter.appendConfigurationToHasher(hasher);
    }

    @Nullable
    private HashCode hashJarContents(RegularFileSnapshot jarFileSnapshot) {
        try {
            List<FileSystemLocationFingerprint> fingerprints = this.fingerprintZipEntries(jarFileSnapshot.getAbsolutePath());
            if (fingerprints.isEmpty()) {
                return null;
            }
            Hasher hasher = Hashing.newHasher();
            NormalizedPathFingerprintCompareStrategy.appendSortedToHasher((Hasher)hasher, fingerprints);
            return hasher.hash();
        }
        catch (Exception e) {
            return this.hashMalformedZip(jarFileSnapshot, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileSystemLocationFingerprint> fingerprintZipEntries(String jarFile) throws IOException {
        ArrayList arrayList;
        ArrayList fingerprints = Lists.newArrayList();
        InputStream fileInputStream = null;
        try {
            ZipEntry zipEntry;
            fileInputStream = Files.newInputStream(Paths.get(jarFile, new String[0]), new OpenOption[0]);
            ZipInputStream zipInput = new ZipInputStream(fileInputStream);
            RelativePathFactory relativePathFactory = new RelativePathFactory();
            while ((zipEntry = zipInput.getNextEntry()) != null) {
                HashCode hash;
                relativePathFactory.setZipEntry(zipEntry);
                if (zipEntry.isDirectory() || this.classpathResourceFilter.shouldBeIgnored(relativePathFactory) || (hash = this.classpathResourceHasher.hash(zipEntry, zipInput)) == null) continue;
                fingerprints.add(new DefaultFileSystemLocationFingerprint(zipEntry.getName(), FileType.RegularFile, hash));
            }
            arrayList = fingerprints;
        }
        catch (Throwable throwable) {
            IoActions.closeQuietly(fileInputStream);
            throw throwable;
        }
        IoActions.closeQuietly((Closeable)fileInputStream);
        return arrayList;
    }

    private HashCode hashMalformedZip(RegularFileSnapshot jarFileSnapshot, Exception e) {
        LOGGER.debug("Malformed jar '{}' found on classpath. Falling back to full content hash instead of classpath hashing.", (Object)jarFileSnapshot.getName(), (Object)e);
        return jarFileSnapshot.getHash();
    }

    private static class RelativePathFactory
    implements Factory<String[]> {
        private ZipEntry zipEntry;

        private RelativePathFactory() {
        }

        public String[] create() {
            return FilePathUtil.getPathSegments((String)this.zipEntry.getName());
        }

        public void setZipEntry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }
    }
}

