/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.InputArtifactDependencies;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.internal.artifacts.ArtifactTransformRegistration;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformActionScheme;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformParameterScheme;
import org.gradle.api.internal.artifacts.transform.DefaultTransformer;
import org.gradle.api.internal.artifacts.transform.DomainObjectProjectStateHandler;
import org.gradle.api.internal.artifacts.transform.LegacyTransformer;
import org.gradle.api.internal.artifacts.transform.TransformationRegistrationFactory;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformerInvoker;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.properties.DefaultParameterValidationContext;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.model.internal.type.ModelType;

public class DefaultTransformationRegistrationFactory
implements TransformationRegistrationFactory {
    private final IsolatableFactory isolatableFactory;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final TransformerInvoker transformerInvoker;
    private final ValueSnapshotter valueSnapshotter;
    private final PropertyWalker parametersPropertyWalker;
    private final DomainObjectProjectStateHandler domainObjectProjectStateHandler;
    private final TypeMetadataStore actionMetadataStore;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileCollectionFingerprinterRegistry fileCollectionFingerprinterRegistry;
    private final InstantiationScheme actionInstantiationScheme;
    private final InstantiationScheme legacyActionInstantiationScheme;

    public DefaultTransformationRegistrationFactory(IsolatableFactory isolatableFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, TransformerInvoker transformerInvoker, ValueSnapshotter valueSnapshotter, FileCollectionFactory fileCollectionFactory, FileCollectionFingerprinterRegistry fileCollectionFingerprinterRegistry, DomainObjectProjectStateHandler domainObjectProjectStateHandler, ArtifactTransformParameterScheme parameterScheme, ArtifactTransformActionScheme actionScheme) {
        this.isolatableFactory = isolatableFactory;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.transformerInvoker = transformerInvoker;
        this.valueSnapshotter = valueSnapshotter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileCollectionFingerprinterRegistry = fileCollectionFingerprinterRegistry;
        this.actionInstantiationScheme = actionScheme.getInstantiationScheme();
        this.actionMetadataStore = actionScheme.getInspectionScheme().getMetadataStore();
        this.legacyActionInstantiationScheme = actionScheme.getLegacyInstantiationScheme();
        this.parametersPropertyWalker = parameterScheme.getInspectionScheme().getPropertyWalker();
        this.domainObjectProjectStateHandler = domainObjectProjectStateHandler;
    }

    @Override
    public ArtifactTransformRegistration create(ImmutableAttributes from, ImmutableAttributes to, Class<? extends TransformAction> implementation, @Nullable TransformParameters parameterObject) {
        ArrayList validationMessages = new ArrayList();
        TypeMetadata actionMetadata = this.actionMetadataStore.getTypeMetadata(implementation);
        DefaultParameterValidationContext parameterValidationContext = new DefaultParameterValidationContext(validationMessages);
        actionMetadata.collectValidationFailures(null, (ParameterValidationContext)parameterValidationContext);
        boolean cacheable = implementation.isAnnotationPresent(CacheableTransform.class);
        Class inputArtifactNormalizer = null;
        Class dependenciesNormalizer = null;
        for (PropertyMetadata propertyMetadata : actionMetadata.getPropertiesMetadata()) {
            NormalizerCollectingVisitor visitor;
            Class propertyType = propertyMetadata.getPropertyType();
            if (propertyType.equals(InputArtifact.class)) {
                visitor = new NormalizerCollectingVisitor();
                actionMetadata.getAnnotationHandlerFor(propertyMetadata).visitPropertyValue(propertyMetadata.getPropertyName(), null, propertyMetadata, (PropertyVisitor)visitor, null);
                inputArtifactNormalizer = visitor.normalizer;
                DefaultTransformer.validateInputFileNormalizer(propertyMetadata.getPropertyName(), inputArtifactNormalizer, cacheable, (ParameterValidationContext)parameterValidationContext);
                continue;
            }
            if (!propertyType.equals(InputArtifactDependencies.class)) continue;
            visitor = new NormalizerCollectingVisitor();
            actionMetadata.getAnnotationHandlerFor(propertyMetadata).visitPropertyValue(propertyMetadata.getPropertyName(), null, propertyMetadata, (PropertyVisitor)visitor, null);
            dependenciesNormalizer = visitor.normalizer;
            DefaultTransformer.validateInputFileNormalizer(propertyMetadata.getPropertyName(), dependenciesNormalizer, cacheable, (ParameterValidationContext)parameterValidationContext);
        }
        if (!validationMessages.isEmpty()) {
            throw new DefaultMultiCauseException(String.format(validationMessages.size() == 1 ? "A problem was found with the configuration of %s." : "Some problems were found with the configuration of %s.", ModelType.of(implementation).getDisplayName()), (Iterable)validationMessages.stream().sorted().map(InvalidUserDataException::new).collect(Collectors.toList()));
        }
        DefaultTransformer transformer = new DefaultTransformer(implementation, parameterObject, from, FileParameterUtils.normalizerOrDefault(inputArtifactNormalizer), FileParameterUtils.normalizerOrDefault(dependenciesNormalizer), cacheable, this.classLoaderHierarchyHasher, this.isolatableFactory, this.valueSnapshotter, this.fileCollectionFactory, this.parametersPropertyWalker, this.actionInstantiationScheme);
        return new DefaultArtifactTransformRegistration(from, to, new TransformationStep(transformer, this.transformerInvoker, this.domainObjectProjectStateHandler, this.fileCollectionFingerprinterRegistry));
    }

    @Override
    public ArtifactTransformRegistration create(ImmutableAttributes from, ImmutableAttributes to, Class<? extends ArtifactTransform> implementation, Object[] params) {
        LegacyTransformer transformer = new LegacyTransformer(implementation, params, this.legacyActionInstantiationScheme, from, this.classLoaderHierarchyHasher, this.isolatableFactory);
        return new DefaultArtifactTransformRegistration(from, to, new TransformationStep(transformer, this.transformerInvoker, this.domainObjectProjectStateHandler, this.fileCollectionFingerprinterRegistry));
    }

    private static class NormalizerCollectingVisitor
    extends PropertyVisitor.Adapter {
        private Class<? extends FileNormalizer> normalizer;

        private NormalizerCollectingVisitor() {
        }

        public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
            this.normalizer = fileNormalizer;
        }
    }

    private static class DefaultArtifactTransformRegistration
    implements ArtifactTransformRegistration {
        private final ImmutableAttributes from;
        private final ImmutableAttributes to;
        private final TransformationStep transformationStep;

        public DefaultArtifactTransformRegistration(ImmutableAttributes from, ImmutableAttributes to, TransformationStep transformationStep) {
            this.from = from;
            this.to = to;
            this.transformationStep = transformationStep;
        }

        @Override
        public AttributeContainerInternal getFrom() {
            return this.from;
        }

        @Override
        public AttributeContainerInternal getTo() {
            return this.to;
        }

        @Override
        public TransformationStep getTransformationStep() {
            return this.transformationStep;
        }
    }
}

