/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.util.Maps;

public abstract class JsScope {
    @NotNull
    private final String description;
    private Map<String, JsName> names;
    private final JsScope parent;
    private static final Pattern FRESH_NAME_SUFFIX = Pattern.compile("[\\$_]\\d+$");

    public JsScope(JsScope parent2, @NotNull String description2) {
        if (description2 == null) {
            JsScope.$$$reportNull$$$0(0);
        }
        this.names = Collections.emptyMap();
        this.description = description2;
        this.parent = parent2;
    }

    protected JsScope(@NotNull String description2) {
        if (description2 == null) {
            JsScope.$$$reportNull$$$0(1);
        }
        this.names = Collections.emptyMap();
        this.description = description2;
        this.parent = null;
    }

    @NotNull
    public JsScope innerObjectScope(@NotNull String scopeName) {
        if (scopeName == null) {
            JsScope.$$$reportNull$$$0(2);
        }
        JsObjectScope jsObjectScope = new JsObjectScope(this, scopeName);
        if (jsObjectScope == null) {
            JsScope.$$$reportNull$$$0(3);
        }
        return jsObjectScope;
    }

    @NotNull
    public JsName declareName(@NotNull String identifier) {
        JsName name;
        if (identifier == null) {
            JsScope.$$$reportNull$$$0(4);
        }
        JsName jsName = (name = this.findOwnName(identifier)) != null ? name : this.doCreateName(identifier);
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(5);
        }
        return jsName;
    }

    @NotNull
    public JsName declareFreshName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            JsScope.$$$reportNull$$$0(6);
        }
        assert (!suggestedName.isEmpty());
        String ident = this.getFreshIdent(suggestedName);
        JsName jsName = this.doCreateName(ident);
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(7);
        }
        return jsName;
    }

    @NotNull
    public static JsName declareTemporaryName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            JsScope.$$$reportNull$$$0(8);
        }
        assert (!suggestedName.isEmpty());
        JsName jsName = new JsName(suggestedName, true);
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(9);
        }
        return jsName;
    }

    @NotNull
    public static JsName declareTemporary() {
        JsName jsName = JsScope.declareTemporaryName("tmp$");
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(10);
        }
        return jsName;
    }

    @Nullable
    public final JsName findName(@NotNull String ident) {
        JsName name;
        if (ident == null) {
            JsScope.$$$reportNull$$$0(11);
        }
        if ((name = this.findOwnName(ident)) == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name;
    }

    public boolean hasOwnName(@NotNull String name) {
        if (name == null) {
            JsScope.$$$reportNull$$$0(12);
        }
        return this.names.containsKey(name);
    }

    private boolean hasName(@NotNull String name) {
        if (name == null) {
            JsScope.$$$reportNull$$$0(13);
        }
        return this.hasOwnName(name) || this.parent != null && this.parent.hasName(name);
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public JsProgram getProgram() {
        assert (this.parent != null) : "Subclasses must override getProgram() if they do not set a parent";
        return this.parent.getProgram();
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    public void copyOwnNames(JsScope other) {
        this.names = new HashMap<String, JsName>(this.names);
        this.names.putAll(other.names);
    }

    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            JsScope.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    protected JsName doCreateName(@NotNull String ident) {
        if (ident == null) {
            JsScope.$$$reportNull$$$0(15);
        }
        JsName name = new JsName(ident, false);
        this.names = Maps.put(this.names, ident, name);
        JsName jsName = name;
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(16);
        }
        return jsName;
    }

    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            JsScope.$$$reportNull$$$0(17);
        }
        return this.names.get(ident);
    }

    @NotNull
    protected String getFreshIdent(@NotNull String suggestedIdent) {
        if (suggestedIdent == null) {
            JsScope.$$$reportNull$$$0(18);
        }
        char sep = '_';
        String baseName = suggestedIdent;
        int counter = 0;
        Matcher matcher = FRESH_NAME_SUFFIX.matcher(suggestedIdent);
        if (matcher.find()) {
            String group = matcher.group();
            baseName = matcher.replaceAll("");
            sep = group.charAt(0);
            counter = Integer.valueOf(group.substring(1));
        }
        String freshName = suggestedIdent;
        while (this.hasName(freshName)) {
            freshName = baseName + sep + counter++;
        }
        String string = freshName;
        if (string == null) {
            JsScope.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/backend/ast/JsScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ident";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedIdent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/backend/ast/JsScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "innerObjectScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "declareName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "declareFreshName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "declareTemporaryName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "declareTemporary";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFreshIdent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "innerObjectScope";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "declareName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "declareFreshName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "declareTemporaryName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasOwnName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doCreateName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findOwnName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFreshIdent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

