/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableCollection;
import java.io.File;
import java.util.HashSet;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.gradle.api.internal.changedetection.TaskExecutionModeResolver;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.properties.DefaultTaskProperties;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class ResolveTaskExecutionModeExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveTaskExecutionModeExecuter.class);
    private final PropertyWalker propertyWalker;
    private final TaskExecuter executer;
    private final TaskExecutionModeResolver executionModeResolver;
    private final FileCollectionFactory fileCollectionFactory;

    public ResolveTaskExecutionModeExecuter(TaskExecutionModeResolver executionModeResolver, FileCollectionFactory fileCollectionFactory, PropertyWalker propertyWalker, TaskExecuter executer) {
        this.fileCollectionFactory = fileCollectionFactory;
        this.propertyWalker = propertyWalker;
        this.executer = executer;
        this.executionModeResolver = executionModeResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskExecuterResult execute(final TaskInternal task, TaskStateInternal state, final TaskExecutionContext context) {
        Timer clock = Time.startTimer();
        TaskProperties properties = DefaultTaskProperties.resolve(this.propertyWalker, this.fileCollectionFactory, task);
        context.setTaskProperties(properties);
        TaskExecutionMode taskExecutionMode = this.executionModeResolver.getExecutionMode(task, properties);
        TaskOutputsInternal outputs = task.getOutputs();
        context.setTaskExecutionMode(taskExecutionMode);
        outputs.setPreviousOutputFiles((FileCollection)new LazilyInitializedFileCollection(){

            public FileCollection createDelegate() {
                AfterPreviousExecutionState previousExecution = context.getAfterPreviousExecution();
                if (previousExecution == null) {
                    return ResolveTaskExecutionModeExecuter.this.fileCollectionFactory.empty();
                }
                ImmutableCollection outputFingerprints = previousExecution.getOutputFileProperties().values();
                HashSet<File> outputs = new HashSet<File>();
                for (FileCollectionFingerprint fileCollectionFingerprint : outputFingerprints) {
                    for (String absolutePath : fileCollectionFingerprint.getFingerprints().keySet()) {
                        outputs.add(new File(absolutePath));
                    }
                }
                return ResolveTaskExecutionModeExecuter.this.fileCollectionFactory.fixed(outputs);
            }

            public String getDisplayName() {
                return "previous output files of " + task.toString();
            }
        });
        LOGGER.debug("Putting task artifact state for {} into context took {}.", (Object)task, (Object)clock.getElapsed());
        try {
            TaskExecuterResult taskExecuterResult = this.executer.execute(task, state, context);
            return taskExecuterResult;
        }
        finally {
            outputs.setPreviousOutputFiles(null);
            context.setTaskExecutionMode(null);
            context.setTaskProperties(null);
            LOGGER.debug("Removed task artifact state for {} from context.");
        }
    }
}

