/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.vcs.SourceControl;
import org.gradle.vcs.VcsMappings;
import org.gradle.vcs.VersionControlRepository;
import org.gradle.vcs.git.GitVersionControlSpec;
import org.gradle.vcs.internal.DefaultVersionControlRepository;
import org.gradle.vcs.internal.VersionControlSpecFactory;

public class DefaultSourceControl
implements SourceControl {
    private final FileResolver fileResolver;
    private final VcsMappings vcsMappings;
    private final VersionControlSpecFactory specFactory;
    private final Map<URI, DefaultVersionControlRepository> repos = new HashMap<URI, DefaultVersionControlRepository>();

    @Inject
    public DefaultSourceControl(FileResolver fileResolver, VcsMappings vcsMappings, VersionControlSpecFactory specFactory) {
        this.fileResolver = fileResolver;
        this.vcsMappings = vcsMappings;
        this.specFactory = specFactory;
    }

    public void vcsMappings(Action<? super VcsMappings> configuration) {
        configuration.execute((Object)this.vcsMappings);
    }

    public VcsMappings getVcsMappings() {
        return this.vcsMappings;
    }

    public VersionControlRepository gitRepository(URI url) {
        DefaultVersionControlRepository repo = this.repos.get(url);
        if (repo == null) {
            repo = this.specFactory.create(GitVersionControlSpec.class, url);
            this.repos.put(url, repo);
            this.vcsMappings.all(repo.asMappingAction());
        }
        return repo;
    }

    public VersionControlRepository gitRepository(String uri) {
        return this.gitRepository(this.fileResolver.resolveUri((Object)uri));
    }

    public void gitRepository(URI url, Action<? super VersionControlRepository> configureAction) {
        configureAction.execute((Object)this.gitRepository(url));
    }

    public void gitRepository(String uri, Action<? super VersionControlRepository> configureAction) {
        this.gitRepository(this.fileResolver.resolveUri((Object)uri), configureAction);
    }
}

