/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.Language;

public abstract class GroovyProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private final TemplateLibraryVersionProvider libraryVersionProvider;
    private final DocumentationRegistry documentationRegistry;

    public GroovyProjectInitDescriptor(TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        this.libraryVersionProvider = libraryVersionProvider;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public Language getLanguage() {
        return Language.GROOVY;
    }

    @Override
    public void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder, TemplateFactory templateFactory) {
        super.generate(settings, buildScriptBuilder, templateFactory);
        buildScriptBuilder.fileComment("This generated file contains a sample Groovy project to get you started.").fileComment("For more details take a look at the Groovy Quickstart chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("tutorial_groovy_projects")).plugin("Apply the groovy plugin to add support for Groovy", "groovy").implementationDependency("Use the latest Groovy version for building this library", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy")).testImplementationDependency("Use the awesome Spock testing and specification framework", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"));
        this.configureBuildScript(settings, buildScriptBuilder);
        TemplateOperation sourceTemplate = this.sourceTemplateOperation(templateFactory);
        TemplateOperation testSourceTemplate = this.testTemplateOperation(templateFactory);
        templateFactory.whenNoSourcesAvailable(sourceTemplate, testSourceTemplate).generate();
    }

    @Override
    public Optional<String> getFurtherReading() {
        return Optional.of(this.documentationRegistry.getDocumentationFor("tutorial_groovy_projects"));
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.SPOCK;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.SPOCK);
    }

    protected abstract TemplateOperation sourceTemplateOperation(TemplateFactory var1);

    protected abstract TemplateOperation testTemplateOperation(TemplateFactory var1);

    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }
}

