/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.CapabilityResolutionDetails;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.UpgradeCapabilityResolver;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.CapabilityInternal;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultCapabilitiesResolution
implements CapabilitiesResolutionInternal {
    private final UpgradeCapabilityResolver upgradeCapabilityResolver = new UpgradeCapabilityResolver();
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final NotationParser<Object, ComponentIdentifier> componentNotationParser;
    private final List<CapabilityAction> actions = Lists.newArrayListWithExpectedSize((int)2);

    public DefaultCapabilitiesResolution(NotationParser<Object, Capability> capabilityNotationParser, NotationParser<Object, ComponentIdentifier> componentNotationParser) {
        this.capabilityNotationParser = capabilityNotationParser;
        this.componentNotationParser = componentNotationParser;
    }

    public void all(Action<? super CapabilityResolutionDetails> action) {
        this.actions.add(new CapabilityAction(Specs.SATISFIES_ALL, action));
    }

    public void withCapability(Capability capability, Action<? super CapabilityResolutionDetails> action) {
        this.actions.add(new CapabilityAction(new CapabilitySpec(capability), action));
    }

    public void withCapability(String group, String name, Action<? super CapabilityResolutionDetails> action) {
        this.withCapability((Capability)this.capabilityNotationParser.parseNotation((Object)(group + ":" + name)), action);
    }

    public void withCapability(Object notation, Action<? super CapabilityResolutionDetails> action) {
        this.withCapability((Capability)this.capabilityNotationParser.parseNotation(notation), action);
    }

    @Override
    public void apply(CapabilitiesConflictHandler.ResolutionDetails details) {
        details.getCapabilityVersions().stream().collect(Collectors.groupingBy(c -> new ImmutableCapability(c.getGroup(), c.getName(), null))).entrySet().forEach(e -> {
            Capability key = (Capability)e.getKey();
            List versions = (List)e.getValue();
            List candidateIds = versions.stream().flatMap(c -> details.getCandidates((Capability)c).stream()).map(CapabilitiesConflictHandler.CandidateDetails::getId).collect(Collectors.toList());
            DefaultCapabilityResolutionDetails resolutionDetails = new DefaultCapabilityResolutionDetails(this.componentNotationParser, key, candidateIds);
            this.handleCapabilityAction(details, key, versions, resolutionDetails);
        });
    }

    private void handleCapabilityAction(CapabilitiesConflictHandler.ResolutionDetails details, Capability key, List<? extends Capability> versions, DefaultCapabilityResolutionDetails resolutionDetails) {
        for (CapabilityAction action : this.actions) {
            if (!action.predicate.isSatisfiedBy((Object)key)) continue;
            action.execute(resolutionDetails);
            if (!resolutionDetails.didSomething) continue;
            this.performCapabilitySelection(details, versions, resolutionDetails);
        }
    }

    private void performCapabilitySelection(CapabilitiesConflictHandler.ResolutionDetails details, List<? extends Capability> versions, DefaultCapabilityResolutionDetails resolutionDetails) {
        if (resolutionDetails.useHighest) {
            this.upgradeCapabilityResolver.resolve(details);
        } else if (resolutionDetails.selected != null) {
            versions.forEach(version -> details.getCandidates((Capability)version).forEach(cand -> this.selectExplicitCandidate(resolutionDetails, (CapabilityInternal)version, (CapabilitiesConflictHandler.CandidateDetails)cand)));
        }
    }

    private void selectExplicitCandidate(DefaultCapabilityResolutionDetails resolutionDetails, CapabilityInternal version, CapabilitiesConflictHandler.CandidateDetails cand) {
        if (cand.getId().equals(resolutionDetails.selected)) {
            cand.select();
            String reason = resolutionDetails.reason;
            if (reason != null) {
                cand.byReason((Describable)Describables.of((Object)"On capability", (Object)version.getCapabilityId(), (Object)reason));
            }
        }
    }

    private static class CapabilitySpec
    implements Spec<Capability> {
        private final Capability capability;

        public CapabilitySpec(Capability capability) {
            this.capability = capability;
        }

        public boolean isSatisfiedBy(Capability element) {
            return element.getGroup().equals(this.capability.getGroup()) && element.getName().equals(this.capability.getName());
        }
    }

    private static class CapabilityAction {
        private final Spec<? super Capability> predicate;
        private final Action<? super CapabilityResolutionDetails> action;

        private CapabilityAction(Spec<? super Capability> predicate, Action<? super CapabilityResolutionDetails> action) {
            this.predicate = predicate;
            this.action = action;
        }

        public void execute(DefaultCapabilityResolutionDetails resolutionDetails) {
            try {
                this.action.execute((Object)resolutionDetails);
            }
            catch (Exception ex) {
                if (ex instanceof InvalidUserCodeException) {
                    throw ex;
                }
                throw new InvalidUserCodeException("Capability resolution rule failed with an error", (Throwable)ex);
            }
        }
    }

    private static class DefaultCapabilityResolutionDetails
    implements CapabilityResolutionDetails {
        private final NotationParser<Object, ComponentIdentifier> notationParser;
        private final Capability capability;
        private final List<ComponentIdentifier> candidates;
        boolean didSomething;
        boolean useHighest;
        private String reason;
        private ComponentIdentifier selected;

        private DefaultCapabilityResolutionDetails(NotationParser<Object, ComponentIdentifier> notationParser, Capability capability, List<ComponentIdentifier> candidates) {
            this.notationParser = notationParser;
            this.capability = capability;
            this.candidates = candidates;
        }

        public Capability getCapability() {
            return this.capability;
        }

        public List<ComponentIdentifier> getCandidates() {
            return this.candidates;
        }

        public CapabilityResolutionDetails select(ComponentIdentifier candidate) {
            this.didSomething = true;
            this.selected = candidate;
            return this;
        }

        public CapabilityResolutionDetails select(Object notation) {
            ComponentIdentifier componentIdentifier = (ComponentIdentifier)this.notationParser.parseNotation(notation);
            for (ComponentIdentifier candidate : this.candidates) {
                if (componentIdentifier.equals(candidate)) {
                    this.select(candidate);
                    return this;
                }
                if (!(candidate instanceof ModuleComponentIdentifier) || !(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier candMCI = (ModuleComponentIdentifier)candidate;
                ModuleComponentIdentifier compMCI = (ModuleComponentIdentifier)componentIdentifier;
                if (!candMCI.getModuleIdentifier().equals(compMCI.getModuleIdentifier())) continue;
                this.select(candidate);
                return this;
            }
            throw new InvalidUserCodeException(componentIdentifier + " is not a valid candidate for conflict resolution on capability " + this.capability + ": candidates are " + this.candidates);
        }

        public CapabilityResolutionDetails selectHighestVersion() {
            this.didSomething = true;
            this.useHighest = true;
            return this;
        }

        public CapabilityResolutionDetails because(String reason) {
            this.reason = reason;
            return this;
        }
    }
}

