/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.tooling.events.test.internal.DefaultDebugOptions;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.SubscribableBuildAction;
import org.gradle.tooling.internal.provider.test.ProviderInternalJvmTestRequest;
import org.gradle.tooling.internal.provider.test.ProviderInternalTestExecutionRequest;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.util.CollectionUtils;

public class TestExecutionRequestAction
extends SubscribableBuildAction {
    private final StartParameterInternal startParameter;
    private final Set<InternalTestDescriptor> testDescriptors;
    private final Set<String> classNames;
    private final Set<InternalJvmTestRequest> internalJvmTestRequests;
    private final InternalDebugOptions debugOptions;

    private TestExecutionRequestAction(BuildClientSubscriptions clientSubscriptions, StartParameterInternal startParameter, Set<InternalTestDescriptor> testDescriptors, Set<String> providerClassNames, Set<InternalJvmTestRequest> internalJvmTestRequests, InternalDebugOptions debugOptions) {
        super(clientSubscriptions);
        this.startParameter = startParameter;
        this.testDescriptors = testDescriptors;
        this.classNames = providerClassNames;
        this.internalJvmTestRequests = internalJvmTestRequests;
        this.debugOptions = debugOptions;
    }

    public static TestExecutionRequestAction create(BuildClientSubscriptions clientSubscriptions, StartParameterInternal startParameter, ProviderInternalTestExecutionRequest testExecutionRequest) {
        Collection<String> testClassNames = testExecutionRequest.getTestClassNames();
        Collection<InternalJvmTestRequest> internalJvmTestRequests = testExecutionRequest.getInternalJvmTestRequests(Collections.emptyList());
        ImmutableSet providerInternalJvmTestRequests = ImmutableSet.copyOf(TestExecutionRequestAction.toProviderInternalJvmTestRequest(internalJvmTestRequests, testClassNames));
        return new TestExecutionRequestAction(clientSubscriptions, startParameter, (Set<InternalTestDescriptor>)ImmutableSet.copyOf(testExecutionRequest.getTestExecutionDescriptors()), (Set<String>)ImmutableSet.copyOf(testClassNames), (Set<InternalJvmTestRequest>)providerInternalJvmTestRequests, TestExecutionRequestAction.getDebugOptions(testExecutionRequest));
    }

    private static InternalDebugOptions getDebugOptions(ProviderInternalTestExecutionRequest testExecutionRequest) {
        try {
            return testExecutionRequest.getDebugOptions();
        }
        catch (UnsupportedMethodException e) {
            return new DefaultDebugOptions();
        }
    }

    private static List<InternalJvmTestRequest> toProviderInternalJvmTestRequest(Collection<InternalJvmTestRequest> internalJvmTestRequests, Collection<String> testClassNames) {
        if (internalJvmTestRequests.isEmpty()) {
            return CollectionUtils.collect(testClassNames, new Transformer<InternalJvmTestRequest, String>(){

                @Override
                public InternalJvmTestRequest transform(String testClass) {
                    return new ProviderInternalJvmTestRequest(testClass, null);
                }
            });
        }
        return CollectionUtils.collect(internalJvmTestRequests, new Transformer<InternalJvmTestRequest, InternalJvmTestRequest>(){

            @Override
            public InternalJvmTestRequest transform(InternalJvmTestRequest internalTestMethod) {
                return new ProviderInternalJvmTestRequest(internalTestMethod.getClassName(), internalTestMethod.getMethodName());
            }
        });
    }

    public StartParameterInternal getStartParameter() {
        return this.startParameter;
    }

    public Collection<String> getTestClassNames() {
        return this.classNames;
    }

    public Collection<InternalJvmTestRequest> getInternalJvmTestRequests() {
        return this.internalJvmTestRequests;
    }

    public Collection<InternalTestDescriptor> getTestExecutionDescriptors() {
        return this.testDescriptors;
    }

    public InternalDebugOptions getDebugOptions() {
        return this.debugOptions;
    }
}

