/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.IsolatableSerializerRegistry;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.SimpleActionExecutionSpec;
import org.gradle.workers.internal.TransportableActionExecutionSpec;
import org.gradle.workers.internal.WorkSerializationException;

public class DefaultActionExecutionSpecFactory
implements ActionExecutionSpecFactory {
    private final IsolatableFactory isolatableFactory;
    private final IsolatableSerializerRegistry serializerRegistry;

    public DefaultActionExecutionSpecFactory(IsolatableFactory isolatableFactory, IsolatableSerializerRegistry serializerRegistry) {
        this.isolatableFactory = isolatableFactory;
        this.serializerRegistry = serializerRegistry;
    }

    @Override
    public <T extends WorkParameters> TransportableActionExecutionSpec<T> newTransportableSpec(ActionExecutionSpec<T> spec) {
        if (spec instanceof IsolatedParametersActionExecutionSpec) {
            IsolatedParametersActionExecutionSpec isolatedSpec = (IsolatedParametersActionExecutionSpec)spec;
            return new TransportableActionExecutionSpec(isolatedSpec.getDisplayName(), isolatedSpec.getImplementationClass().getName(), this.serialize(isolatedSpec.getIsolatedParams()), isolatedSpec.getClassLoaderStructure(), isolatedSpec.getBaseDir(), isolatedSpec.isInternalServicesRequired());
        }
        if (spec instanceof TransportableActionExecutionSpec) {
            return (TransportableActionExecutionSpec)spec;
        }
        throw new IllegalArgumentException("Can't create a TransportableActionExecutionSpec from spec with type: " + spec.getClass().getSimpleName());
    }

    @Override
    public <T extends WorkParameters> IsolatedParametersActionExecutionSpec<T> newIsolatedSpec(String displayName, Class<? extends WorkAction<T>> implementationClass, T params, ClassLoaderStructure classLoaderStructure, File baseDir, boolean usesInternalServices) {
        return new IsolatedParametersActionExecutionSpec(implementationClass, displayName, this.isolatableFactory.isolate(params), classLoaderStructure, baseDir, usesInternalServices);
    }

    @Override
    public <T extends WorkParameters> SimpleActionExecutionSpec<T> newSimpleSpec(ActionExecutionSpec<T> spec) {
        if (spec instanceof TransportableActionExecutionSpec) {
            TransportableActionExecutionSpec transportableSpec = (TransportableActionExecutionSpec)spec;
            WorkParameters params = (WorkParameters)Cast.uncheckedCast((Object)this.deserialize(transportableSpec.getSerializedParameters()).isolate());
            return new SimpleActionExecutionSpec<WorkParameters>((Class)Cast.uncheckedCast(this.fromClassName(transportableSpec.getImplementationClassName())), transportableSpec.getDisplayName(), params, transportableSpec.getClassLoaderStructure(), transportableSpec.getBaseDir(), transportableSpec.isInternalServicesRequired());
        }
        if (spec instanceof IsolatedParametersActionExecutionSpec) {
            IsolatedParametersActionExecutionSpec isolatedSpec = (IsolatedParametersActionExecutionSpec)spec;
            WorkParameters params = (WorkParameters)Cast.uncheckedCast((Object)isolatedSpec.getIsolatedParams().isolate());
            return new SimpleActionExecutionSpec<WorkParameters>(isolatedSpec.getImplementationClass(), isolatedSpec.getDisplayName(), params, isolatedSpec.getClassLoaderStructure(), isolatedSpec.getBaseDir(), isolatedSpec.isInternalServicesRequired());
        }
        throw new IllegalArgumentException("Can't create a SimpleActionExecutionSpec from spec with type: " + spec.getClass().getSimpleName());
    }

    Class<?> fromClassName(String className) {
        try {
            return ClassLoaderUtils.classFromContextLoader((String)className);
        }
        catch (Exception e) {
            throw new WorkSerializationException("Could not deserialize unit of work.", e);
        }
    }

    private byte[] serialize(Isolatable<?> isolatable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)outputStream);
        try {
            this.serializerRegistry.writeIsolatable((Encoder)encoder, isolatable);
            encoder.flush();
        }
        catch (Exception e) {
            throw new WorkSerializationException("Could not serialize unit of work.", e);
        }
        return outputStream.toByteArray();
    }

    private Isolatable<?> deserialize(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)inputStream);
        try {
            return this.serializerRegistry.readIsolatable((Decoder)decoder);
        }
        catch (Exception e) {
            throw new WorkSerializationException("Could not deserialize unit of work.", e);
        }
    }
}

