/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.gradle.kotlin.dsl.execution.PartialEvaluator$WhenMappings;
import org.gradle.kotlin.dsl.execution.Program;
import org.gradle.kotlin.dsl.execution.ProgramKind;
import org.gradle.kotlin.dsl.execution.ProgramSource;
import org.gradle.kotlin.dsl.execution.ProgramSourceFragment;
import org.gradle.kotlin.dsl.execution.ProgramTarget;
import org.gradle.kotlin.dsl.execution.ProgramText;
import org.gradle.kotlin.dsl.execution.ResidualProgram;
import org.gradle.kotlin.dsl.execution.ScriptSection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gradle/kotlin/dsl/execution/PartialEvaluator;", "", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "(Lorg/gradle/kotlin/dsl/execution/ProgramKind;Lorg/gradle/kotlin/dsl/execution/ProgramTarget;)V", "defaultStageTransition", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram$Instruction;", "fragmentHolderSourceFor", "Lorg/gradle/kotlin/dsl/execution/ProgramSource;", "program", "Lorg/gradle/kotlin/dsl/execution/Program$FragmentHolder;", "reduce", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram;", "Lorg/gradle/kotlin/dsl/execution/Program;", "reduceBuildscriptProgram", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram$Static;", "Lorg/gradle/kotlin/dsl/execution/Program$Buildscript;", "reduceEmptyProgram", "reduceScriptProgram", "Lorg/gradle/kotlin/dsl/execution/Program$Script;", "reduceStage1Program", "stage1", "Lorg/gradle/kotlin/dsl/execution/Program$Stage1;", "reduceStagedProgram", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram$Dynamic;", "Lorg/gradle/kotlin/dsl/execution/Program$Staged;", "stage1WithPluginManagement", "Lorg/gradle/kotlin/dsl/execution/Program$PluginManagement;", "stage1WithPlugins", "gradle-kotlin-dsl"})
public final class PartialEvaluator {
    private final ProgramKind programKind;
    private final ProgramTarget programTarget;

    @NotNull
    public final ResidualProgram reduce(@NotNull Program program2) {
        ResidualProgram residualProgram;
        Intrinsics.checkParameterIsNotNull((Object)program2, (String)"program");
        Program program3 = program2;
        if (program3 instanceof Program.Empty) {
            residualProgram = this.reduceEmptyProgram();
        } else if (program3 instanceof Program.PluginManagement) {
            residualProgram = this.stage1WithPluginManagement((Program.PluginManagement)program2);
        } else if (program3 instanceof Program.Buildscript) {
            residualProgram = this.reduceBuildscriptProgram((Program.Buildscript)program2);
        } else if (program3 instanceof Program.Plugins) {
            residualProgram = this.stage1WithPlugins((Program.Stage1)program2);
        } else if (program3 instanceof Program.Stage1Sequence) {
            residualProgram = this.stage1WithPlugins((Program.Stage1)program2);
        } else if (program3 instanceof Program.Script) {
            residualProgram = this.reduceScriptProgram((Program.Script)program2);
        } else if (program3 instanceof Program.Staged) {
            residualProgram = this.reduceStagedProgram((Program.Staged)program2);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported `" + program2 + '\'');
        }
        return residualProgram;
    }

    private final ResidualProgram.Static reduceEmptyProgram() {
        ResidualProgram.Static static_;
        block0 : switch (PartialEvaluator$WhenMappings.$EnumSwitchMapping$1[this.programTarget.ordinal()]) {
            case 1: {
                switch (PartialEvaluator$WhenMappings.$EnumSwitchMapping$0[this.programKind.ordinal()]) {
                    case 1: {
                        static_ = new ResidualProgram.Static(ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE);
                        break block0;
                    }
                    case 2: {
                        static_ = new ResidualProgram.Static(ResidualProgram.Instruction.CloseTargetScope.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                static_ = new ResidualProgram.Static(this.defaultStageTransition());
            }
        }
        return static_;
    }

    private final ResidualProgram.Static reduceBuildscriptProgram(Program.Buildscript program2) {
        return new ResidualProgram.Static(ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.Eval(this.fragmentHolderSourceFor(program2)), this.defaultStageTransition());
    }

    private final ProgramSource fragmentHolderSourceFor(Program.FragmentHolder program2) {
        ProgramSourceFragment fragment = program2.getFragment();
        ScriptSection section = fragment.getSection();
        return fragment.getSource().map((Function1<? super ProgramText, ProgramText>)((Function1)new Function1<ProgramText, ProgramText>(section){
            final /* synthetic */ ScriptSection $section;

            @NotNull
            public final ProgramText invoke(@NotNull ProgramText sourceText) {
                Intrinsics.checkParameterIsNotNull((Object)sourceText, (String)"sourceText");
                int n = 0;
                return sourceText.subText(new IntRange(n, this.$section.getBlock().getLast())).preserve(this.$section.getWholeRange());
            }
            {
                this.$section = scriptSection;
                super(1);
            }
        }));
    }

    private final ResidualProgram reduceScriptProgram(Program.Script program2) {
        ResidualProgram residualProgram;
        block0 : switch (PartialEvaluator$WhenMappings.$EnumSwitchMapping$3[this.programTarget.ordinal()]) {
            case 1: {
                switch (PartialEvaluator$WhenMappings.$EnumSwitchMapping$2[this.programKind.ordinal()]) {
                    case 1: {
                        residualProgram = new ResidualProgram.Dynamic(new ResidualProgram.Static(ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE), program2.getSource());
                        break block0;
                    }
                    case 2: {
                        residualProgram = new ResidualProgram.Static(ResidualProgram.Instruction.CloseTargetScope.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE, new ResidualProgram.Instruction.Eval(program2.getSource()));
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                residualProgram = new ResidualProgram.Static(this.defaultStageTransition(), new ResidualProgram.Instruction.Eval(program2.getSource()));
            }
        }
        return residualProgram;
    }

    private final ResidualProgram.Instruction defaultStageTransition() {
        ResidualProgram.Instruction instruction;
        switch (PartialEvaluator$WhenMappings.$EnumSwitchMapping$4[this.programKind.ordinal()]) {
            case 1: {
                instruction = ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE;
                break;
            }
            default: {
                instruction = ResidualProgram.Instruction.CloseTargetScope.INSTANCE;
            }
        }
        return instruction;
    }

    private final ResidualProgram.Dynamic reduceStagedProgram(Program.Staged program2) {
        return new ResidualProgram.Dynamic(this.reduceStage1Program(program2.getStage1()), program2.getStage2().getSource());
    }

    private final ResidualProgram.Static reduceStage1Program(Program.Stage1 stage1) {
        ResidualProgram.Static static_;
        Program.Stage1 stage12 = stage1;
        if (stage12 instanceof Program.Buildscript) {
            switch (PartialEvaluator$WhenMappings.$EnumSwitchMapping$5[this.programTarget.ordinal()]) {
                case 1: {
                    static_ = new ResidualProgram.Static(ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.Eval(this.fragmentHolderSourceFor((Program.FragmentHolder)((Object)stage1))), ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE);
                    break;
                }
                default: {
                    static_ = this.reduceBuildscriptProgram((Program.Buildscript)stage1);
                    break;
                }
            }
        } else {
            static_ = this.stage1WithPlugins(stage1);
        }
        return static_;
    }

    private final ResidualProgram.Static stage1WithPlugins(Program.Stage1 stage1) {
        ResidualProgram.Static static_;
        switch (PartialEvaluator$WhenMappings.$EnumSwitchMapping$6[this.programTarget.ordinal()]) {
            case 1: {
                static_ = new ResidualProgram.Static(ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.ApplyPluginRequestsOf(stage1), ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE);
                break;
            }
            default: {
                static_ = new ResidualProgram.Static(ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.ApplyPluginRequestsOf(stage1));
            }
        }
        return static_;
    }

    private final ResidualProgram.Static stage1WithPluginManagement(Program.PluginManagement program2) {
        return new ResidualProgram.Static(ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.Eval(this.fragmentHolderSourceFor(program2)), ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE);
    }

    public PartialEvaluator(@NotNull ProgramKind programKind, @NotNull ProgramTarget programTarget) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)programKind), (String)"programKind");
        Intrinsics.checkParameterIsNotNull((Object)((Object)programTarget), (String)"programTarget");
        this.programKind = programKind;
        this.programTarget = programTarget;
    }
}

