/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitTestClassProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassExecutor;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformSpec;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestExecutionListener;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnitPlatformTestClassProcessor
extends AbstractJUnitTestClassProcessor<JUnitPlatformSpec> {
    private CollectAllTestClassesExecutor testClassExecutor;

    public JUnitPlatformTestClassProcessor(JUnitPlatformSpec spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        super((AbstractJUnitSpec)spec, idGenerator, actorFactory, clock);
    }

    protected TestResultProcessor createResultProcessorChain(TestResultProcessor resultProcessor) {
        return resultProcessor;
    }

    protected Action<String> createTestExecutor(Actor resultProcessorActor) {
        TestResultProcessor threadSafeResultProcessor = (TestResultProcessor)resultProcessorActor.getProxy(TestResultProcessor.class);
        this.testClassExecutor = new CollectAllTestClassesExecutor(threadSafeResultProcessor);
        return this.testClassExecutor;
    }

    public void stop() {
        this.testClassExecutor.processAllTestClasses();
        super.stop();
    }

    private boolean isInnerClass(Class<?> klass) {
        return klass.getEnclosingClass() != null && !Modifier.isStatic(klass.getModifiers());
    }

    private Class<?> loadClass(String className) {
        try {
            ClassLoader applicationClassloader = Thread.currentThread().getContextClassLoader();
            return Class.forName(className, false, applicationClassloader);
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private LauncherDiscoveryRequest createLauncherDiscoveryRequest(List<Class<?>> testClasses) {
        List classSelectors = testClasses.stream().map(DiscoverySelectors::selectClass).collect(Collectors.toList());
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().selectors(classSelectors);
        this.addTestNameFilters(requestBuilder);
        this.addEnginesFilter(requestBuilder);
        this.addTagsFilter(requestBuilder);
        return requestBuilder.build();
    }

    private void addEnginesFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        if (!((JUnitPlatformSpec)this.spec).getIncludeEngines().isEmpty()) {
            requestBuilder.filters(new Filter[]{EngineFilter.includeEngines((List)((JUnitPlatformSpec)this.spec).getIncludeEngines())});
        }
        if (!((JUnitPlatformSpec)this.spec).getExcludeEngines().isEmpty()) {
            requestBuilder.filters(new Filter[]{EngineFilter.excludeEngines((List)((JUnitPlatformSpec)this.spec).getExcludeEngines())});
        }
    }

    private void addTagsFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        if (!((JUnitPlatformSpec)this.spec).getIncludeTags().isEmpty()) {
            requestBuilder.filters(new Filter[]{TagFilter.includeTags((List)((JUnitPlatformSpec)this.spec).getIncludeTags())});
        }
        if (!((JUnitPlatformSpec)this.spec).getExcludeTags().isEmpty()) {
            requestBuilder.filters(new Filter[]{TagFilter.excludeTags((List)((JUnitPlatformSpec)this.spec).getExcludeTags())});
        }
    }

    private void addTestNameFilters(LauncherDiscoveryRequestBuilder requestBuilder) {
        if (!((JUnitPlatformSpec)this.spec).getIncludedTests().isEmpty() || !((JUnitPlatformSpec)this.spec).getIncludedTestsCommandLine().isEmpty()) {
            TestSelectionMatcher matcher = new TestSelectionMatcher((Collection)((JUnitPlatformSpec)this.spec).getIncludedTests(), (Collection)((JUnitPlatformSpec)this.spec).getExcludedTests(), (Collection)((JUnitPlatformSpec)this.spec).getIncludedTestsCommandLine());
            requestBuilder.filters(new Filter[]{new ClassMethodNameFilter(matcher)});
        }
    }

    private static class ClassMethodNameFilter
    implements PostDiscoveryFilter {
        private final TestSelectionMatcher matcher;

        private ClassMethodNameFilter(TestSelectionMatcher matcher) {
            this.matcher = matcher;
        }

        public FilterResult apply(TestDescriptor descriptor) {
            if (this.classMatch(descriptor)) {
                return FilterResult.included((String)"Class match");
            }
            return FilterResult.includedIf((boolean)this.shouldRun(descriptor), () -> "Method or class match", () -> "Method or class mismatch");
        }

        private boolean shouldRun(TestDescriptor descriptor) {
            Optional source = descriptor.getSource();
            if (!source.isPresent()) {
                return true;
            }
            if (source.get() instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)source.get();
                return this.matcher.matchesTest(methodSource.getClassName(), methodSource.getMethodName());
            }
            if (source.get() instanceof ClassSource) {
                for (TestDescriptor child : descriptor.getChildren()) {
                    if (!this.shouldRun(child)) continue;
                    return true;
                }
                if (descriptor.getChildren().isEmpty()) {
                    String className = ((ClassSource)source.get()).getClassName();
                    return this.matcher.matchesTest(className, null) || this.matcher.matchesTest(className, descriptor.getLegacyReportingName());
                }
            }
            return false;
        }

        private boolean classMatch(TestDescriptor descriptor) {
            while (descriptor.getParent().isPresent()) {
                if (this.className(descriptor).filter(className -> this.matcher.matchesTest(className, null)).isPresent()) {
                    return true;
                }
                descriptor = (TestDescriptor)descriptor.getParent().get();
            }
            return false;
        }

        private Optional<String> className(TestDescriptor descriptor) {
            return descriptor.getSource().filter(ClassSource.class::isInstance).map(ClassSource.class::cast).map(ClassSource::getClassName);
        }
    }

    private class CollectAllTestClassesExecutor
    implements Action<String> {
        private final List<Class<?>> testClasses = new ArrayList();
        private final TestResultProcessor resultProcessor;

        CollectAllTestClassesExecutor(TestResultProcessor resultProcessor) {
            this.resultProcessor = resultProcessor;
        }

        public void execute(@Nonnull String testClassName) {
            Class klass = JUnitPlatformTestClassProcessor.this.loadClass(testClassName);
            if (JUnitPlatformTestClassProcessor.this.isInnerClass(klass) || JUnitTestClassExecutor.isNestedClassInsideEnclosedRunner((Class)klass)) {
                return;
            }
            this.testClasses.add(klass);
        }

        private void processAllTestClasses() {
            Launcher launcher = LauncherFactory.create();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{new JUnitPlatformTestExecutionListener(this.resultProcessor, JUnitPlatformTestClassProcessor.this.clock, JUnitPlatformTestClassProcessor.this.idGenerator)});
            launcher.execute(JUnitPlatformTestClassProcessor.this.createLauncherDiscoveryRequest(this.testClasses), new TestExecutionListener[0]);
        }
    }
}

