/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Set;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.GracefullyStoppedException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockCommunicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockCommunicator.class);
    private static final String SOCKET_OPERATION_NOT_PERMITTED_ERROR_MESSAGE = "Operation not permitted";
    private static final String SOCKET_NETWORK_UNREACHABLE_ERROR_MESSAGE = "Network is unreachable";
    private static final String SOCKET_CANNOT_ASSIGN_ADDRESS_ERROR_MESSAGE = "Cannot assign requested address";
    private final DatagramSocket socket;
    private final InetAddressFactory addressFactory;
    private volatile boolean stopped;

    public FileLockCommunicator(InetAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
        try {
            this.socket = new DatagramSocket(0, addressFactory.getWildcardBindingAddress());
        }
        catch (SocketException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pingOwner(int ownerPort, long lockId, String displayName) {
        boolean pingSentSuccessfully = false;
        try {
            byte[] bytesToSend = FileLockPacketPayload.encode(lockId, FileLockPacketType.UNLOCK_REQUEST);
            for (InetAddress address : this.addressFactory.getCommunicationAddresses()) {
                try {
                    this.socket.send(new DatagramPacket(bytesToSend, bytesToSend.length, address, ownerPort));
                    pingSentSuccessfully = true;
                }
                catch (IOException e) {
                    String message = e.getMessage();
                    if (message == null || !message.startsWith(SOCKET_OPERATION_NOT_PERMITTED_ERROR_MESSAGE) && !message.startsWith(SOCKET_NETWORK_UNREACHABLE_ERROR_MESSAGE) && !message.startsWith(SOCKET_CANNOT_ASSIGN_ADDRESS_ERROR_MESSAGE)) throw e;
                    LOGGER.debug("Failed attempt to ping owner of lock for {} (lock id: {}, port: {}, address: {})", new Object[]{displayName, lockId, ownerPort, address});
                    continue;
                    return pingSentSuccessfully;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to ping owner of lock for %s (lock id: %s, port: %s)", displayName, lockId, ownerPort), e);
        }
    }

    public DatagramPacket receive() throws GracefullyStoppedException {
        try {
            byte[] bytes = new byte[10];
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            this.socket.receive(packet);
            return packet;
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public FileLockPacketPayload decode(DatagramPacket receivedPacket) {
        try {
            return FileLockPacketPayload.decode(receivedPacket.getData(), receivedPacket.getLength());
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void confirmUnlockRequest(SocketAddress address, long lockId) {
        try {
            byte[] bytes = FileLockPacketPayload.encode(lockId, FileLockPacketType.UNLOCK_REQUEST_CONFIRMATION);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            packet.setSocketAddress(address);
            this.socket.send(packet);
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void confirmLockRelease(Set<SocketAddress> addresses, long lockId) {
        byte[] bytes = FileLockPacketPayload.encode(lockId, FileLockPacketType.LOCK_RELEASE_CONFIRMATION);
        for (SocketAddress address : addresses) {
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            packet.setSocketAddress(address);
            LOGGER.debug("Confirming lock release to Gradle process at port {} for lock with id {}.", (Object)packet.getPort(), (Object)lockId);
            try {
                this.socket.send(packet);
            }
            catch (IOException e) {
                if (this.stopped) continue;
                LOGGER.debug("Failed to confirm lock release to Gradle process at port {} for lock with id {}.", (Object)packet.getPort(), (Object)lockId);
            }
        }
    }

    public void stop() {
        this.stopped = true;
        this.socket.close();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }
}

