/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyConstraintMetadata;
import org.gradle.api.artifacts.DependencyConstraintsMetadata;
import org.gradle.api.artifacts.DirectDependenciesMetadata;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVariantFilesMetadata;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.MutableCapabilitiesMetadata;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultMutableCapabilities;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.NoOpDerivationStrategy;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.model.CapabilitiesRules;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.DependencyMetadataRules;
import org.gradle.internal.component.model.VariantAttributesRules;
import org.gradle.internal.component.model.VariantFilesRules;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class VariantMetadataRules {
    private final ImmutableAttributesFactory attributesFactory;
    private DependencyMetadataRules dependencyMetadataRules;
    private VariantAttributesRules variantAttributesRules;
    private CapabilitiesRules capabilitiesRules;
    private VariantFilesRules variantFilesRules;
    private VariantDerivationStrategy variantDerivationStrategy = new NoOpDerivationStrategy();
    private final ModuleVersionIdentifier moduleVersionId;
    private Map<String, String> additionalVariants = Maps.newHashMap();

    public VariantMetadataRules(ImmutableAttributesFactory attributesFactory, ModuleVersionIdentifier moduleVersionId) {
        this.attributesFactory = attributesFactory;
        this.moduleVersionId = moduleVersionId;
    }

    public VariantDerivationStrategy getVariantDerivationStrategy() {
        return this.variantDerivationStrategy;
    }

    public void setVariantDerivationStrategy(VariantDerivationStrategy variantDerivationStrategy) {
        this.variantDerivationStrategy = variantDerivationStrategy;
    }

    public ImmutableAttributes applyVariantAttributeRules(VariantResolveMetadata variant, AttributeContainerInternal source) {
        if (this.variantAttributesRules != null) {
            return this.variantAttributesRules.execute(variant, source);
        }
        return source.asImmutable();
    }

    public CapabilitiesMetadata applyCapabilitiesRules(VariantResolveMetadata variant, CapabilitiesMetadata capabilities) {
        if (this.capabilitiesRules != null) {
            ArrayList descriptors = Lists.newArrayList((Iterable)capabilities.getCapabilities());
            if (descriptors.isEmpty()) {
                descriptors.add(new ImmutableCapability(this.moduleVersionId.getGroup(), this.moduleVersionId.getName(), this.moduleVersionId.getVersion()));
            }
            DefaultMutableCapabilities mutableCapabilities = new DefaultMutableCapabilities(descriptors);
            return this.capabilitiesRules.execute(variant, mutableCapabilities);
        }
        return capabilities;
    }

    public <T extends ModuleDependencyMetadata> List<T> applyDependencyMetadataRules(VariantResolveMetadata variant, List<T> configDependencies) {
        if (this.dependencyMetadataRules != null) {
            return this.dependencyMetadataRules.execute(variant, configDependencies);
        }
        return configDependencies;
    }

    public <T extends ComponentArtifactMetadata> ImmutableList<T> applyVariantFilesMetadataRulesToArtifacts(VariantResolveMetadata variant, ImmutableList<T> declaredArtifacts, ModuleComponentIdentifier componentIdentifier) {
        if (this.variantFilesRules != null) {
            return this.variantFilesRules.executeForArtifacts(variant, declaredArtifacts, componentIdentifier);
        }
        return declaredArtifacts;
    }

    public <T extends ComponentVariant.File> ImmutableList<T> applyVariantFilesMetadataRulesToFiles(VariantResolveMetadata variant, ImmutableList<T> declaredFiles, ModuleComponentIdentifier componentIdentifier) {
        if (this.variantFilesRules != null) {
            return this.variantFilesRules.executeForFiles(variant, declaredFiles, componentIdentifier);
        }
        return declaredFiles;
    }

    public void addDependencyAction(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, VariantAction<? super DirectDependenciesMetadata> action) {
        if (this.dependencyMetadataRules == null) {
            this.dependencyMetadataRules = new DependencyMetadataRules(instantiator, dependencyNotationParser, dependencyConstraintNotationParser, this.attributesFactory);
        }
        this.dependencyMetadataRules.addDependencyAction(action);
    }

    public void addDependencyConstraintAction(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, VariantAction<? super DependencyConstraintsMetadata> action) {
        if (this.dependencyMetadataRules == null) {
            this.dependencyMetadataRules = new DependencyMetadataRules(instantiator, dependencyNotationParser, dependencyConstraintNotationParser, this.attributesFactory);
        }
        this.dependencyMetadataRules.addDependencyConstraintAction(action);
    }

    public void addAttributesAction(ImmutableAttributesFactory attributesFactory, VariantAction<? super AttributeContainer> action) {
        if (this.variantAttributesRules == null) {
            this.variantAttributesRules = new VariantAttributesRules(attributesFactory);
        }
        this.variantAttributesRules.addAttributesAction(action);
    }

    public void addCapabilitiesAction(VariantAction<? super MutableCapabilitiesMetadata> action) {
        if (this.capabilitiesRules == null) {
            this.capabilitiesRules = new CapabilitiesRules();
        }
        this.capabilitiesRules.addCapabilitiesAction(action);
    }

    public void addVariantFilesAction(VariantAction<? super MutableVariantFilesMetadata> action) {
        if (this.variantFilesRules == null) {
            this.variantFilesRules = new VariantFilesRules();
        }
        this.variantFilesRules.addFilesAction(action);
    }

    public void addVariant(String name) {
        this.additionalVariants.put(name, null);
    }

    public void addVariant(String name, String basedOn) {
        this.additionalVariants.put(name, basedOn);
    }

    public Map<String, String> getAdditionalVariants() {
        return this.additionalVariants;
    }

    public static VariantMetadataRules noOp() {
        return ImmutableRules.INSTANCE;
    }

    private static class ImmutableRules
    extends VariantMetadataRules {
        private static final ImmutableRules INSTANCE = new ImmutableRules();

        private ImmutableRules() {
            super(null, null);
        }

        @Override
        public void setVariantDerivationStrategy(VariantDerivationStrategy variantDerivationStrategy) {
            throw new UnsupportedOperationException("You are probably trying to set the derivation strategy to something that wasn't supposed to be mutable");
        }

        @Override
        public void addDependencyAction(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, VariantAction<? super DirectDependenciesMetadata> action) {
            throw new UnsupportedOperationException("You are probably trying to add a dependency rule to something that wasn't supposed to be mutable");
        }

        @Override
        public void addDependencyConstraintAction(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, VariantAction<? super DependencyConstraintsMetadata> action) {
            throw new UnsupportedOperationException("You are probably trying to add a dependency constraint rule to something that wasn't supposed to be mutable");
        }

        @Override
        public void addAttributesAction(ImmutableAttributesFactory attributesFactory, VariantAction<? super AttributeContainer> action) {
            throw new UnsupportedOperationException("You are probably trying to add a variant attribute to something that wasn't supposed to be mutable");
        }

        @Override
        public void addCapabilitiesAction(VariantAction<? super MutableCapabilitiesMetadata> action) {
            throw new UnsupportedOperationException("You are probably trying to change capabilities of something that wasn't supposed to be mutable");
        }
    }

    public static class VariantAction<T> {
        private final Spec<? super VariantResolveMetadata> spec;
        private final Action<? super T> delegate;

        public VariantAction(Spec<? super VariantResolveMetadata> spec, Action<? super T> delegate) {
            this.spec = spec;
            this.delegate = delegate;
        }

        public void maybeExecute(VariantResolveMetadata variant, T subject) {
            if (this.spec.isSatisfiedBy((Object)variant)) {
                this.delegate.execute(subject);
            }
        }
    }
}

