/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import gnu.trove.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LoggerRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.ClasspathCache;
import org.jetbrains.kotlin.com.intellij.util.lang.JarMemoryLoader;
import org.jetbrains.kotlin.com.intellij.util.lang.Loader;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

class JarLoader
extends Loader {
    private static final List<Pair<Resource.Attribute, Attributes.Name>> PACKAGE_FIELDS = Arrays.asList(Pair.pair(Resource.Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), Pair.pair(Resource.Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), Pair.pair(Resource.Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), Pair.pair(Resource.Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), Pair.pair(Resource.Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), Pair.pair(Resource.Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR));
    private final String myFilePath;
    private final ClassPath myConfiguration;
    private final URL myUrl;
    private SoftReference<JarMemoryLoader> myMemoryLoader;
    private volatile SoftReference<ZipFile> myZipFileSoftReference;
    private volatile Map<Resource.Attribute, String> myAttributes;
    private volatile String myClassPathManifestAttribute;
    private final AtomicInteger myNumberOfRequests = new AtomicInteger();
    private volatile TIntHashSet myPackageHashesInside;
    private static final Object ourLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarLoader(URL url, int index2, ClassPath configuration) throws IOException {
        super(new URL("jar", "", -1, url + "!/"), index2);
        this.myFilePath = JarLoader.urlToFilePath(url);
        this.myConfiguration = configuration;
        this.myUrl = url;
        if (!configuration.myLazyClassloadingCaches) {
            ZipFile zipFile2 = this.getZipFile();
            try {
                JarMemoryLoader loader;
                if (configuration.myPreloadJarContents && (loader = JarMemoryLoader.load(zipFile2, this.getBaseURL(), this)) != null) {
                    this.myMemoryLoader = new SoftReference<JarMemoryLoader>(loader);
                }
            }
            finally {
                this.releaseZipFile(zipFile2);
            }
        }
    }

    Map<Resource.Attribute, String> getAttributes() {
        this.loadManifestAttributes();
        return this.myAttributes;
    }

    @Nullable
    String getClassPathManifestAttribute() {
        this.loadManifestAttributes();
        String manifestAttribute = this.myClassPathManifestAttribute;
        return manifestAttribute != "<null>" ? manifestAttribute : null;
    }

    private static String urlToFilePath(URL url) {
        try {
            return new File(url.toURI()).getPath();
        }
        catch (Throwable ignore) {
            return url.getPath();
        }
    }

    @Nullable
    private static Map<Resource.Attribute, String> getAttributes(@Nullable Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        EnumMap<Resource.Attribute, String> map2 = null;
        for (Pair<Resource.Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
            String value2 = attributes.getValue((Attributes.Name)p.second);
            if (value2 == null) continue;
            if (map2 == null) {
                map2 = new EnumMap<Resource.Attribute, String>(Resource.Attribute.class);
            }
            map2.put((Resource.Attribute)((Object)p.first), value2);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifestAttributes() {
        if (this.myClassPathManifestAttribute != null) {
            return;
        }
        JarLoader jarLoader = this;
        synchronized (jarLoader) {
            try {
                if (this.myClassPathManifestAttribute != null) {
                    return;
                }
                ZipFile zipFile2 = this.getZipFile();
                try {
                    Attributes manifestAttributes = this.myConfiguration.getManifestData(this.myUrl);
                    if (manifestAttributes == null) {
                        ZipEntry entry = zipFile2.getEntry("META-INF/MANIFEST.MF");
                        InputStream zipEntryStream = entry != null ? zipFile2.getInputStream(entry) : null;
                        manifestAttributes = this.loadManifestAttributes(zipFile2, zipEntryStream);
                        if (manifestAttributes == null) {
                            manifestAttributes = new Attributes(0);
                        }
                        this.myConfiguration.cacheManifestData(this.myUrl, manifestAttributes);
                    }
                    this.myAttributes = JarLoader.getAttributes(manifestAttributes);
                    Object attribute = manifestAttributes.get(Attributes.Name.CLASS_PATH);
                    this.myClassPathManifestAttribute = attribute instanceof String ? (String)attribute : "<null>";
                }
                finally {
                    this.releaseZipFile(zipFile2);
                }
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Attributes loadManifestAttributes(@NotNull ZipFile zipFile2, @Nullable InputStream stream) {
        Attributes attributes;
        if (zipFile2 == null) {
            JarLoader.$$$reportNull$$$0(0);
        }
        if (stream == null) {
            return null;
        }
        try {
            attributes = new Manifest(stream).getMainAttributes();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        stream.close();
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        ZipFile zipFile2 = this.getZipFile();
        ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
        Enumeration<? extends ZipEntry> entries2 = zipFile2.entries();
        while (entries2.hasMoreElements()) {
            ZipEntry entry = entries2.nextElement();
            String name = entry.getName();
            if (name.endsWith(".class")) {
                loaderDataBuilder.addClassPackageFromName(name);
            } else {
                loaderDataBuilder.addResourcePackageFromName(name);
            }
            loaderDataBuilder.addPossiblyDuplicateNameEntry(name);
        }
        ClasspathCache.LoaderData loaderData = loaderDataBuilder.build();
        ClasspathCache.LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            JarLoader.$$$reportNull$$$0(1);
        }
        return loaderData2;
        finally {
            this.releaseZipFile(zipFile2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIntHashSet buildPackageHashes() {
        TIntHashSet tIntHashSet;
        ZipFile zipFile2 = this.getZipFile();
        try {
            Enumeration<? extends ZipEntry> entries2 = zipFile2.entries();
            TIntHashSet result2 = new TIntHashSet();
            while (entries2.hasMoreElements()) {
                ZipEntry entry = entries2.nextElement();
                result2.add(ClasspathCache.getPackageNameHash(entry.getName()));
            }
            result2.add(0);
            tIntHashSet = result2;
        }
        catch (Throwable throwable) {
            try {
                this.releaseZipFile(zipFile2);
                throw throwable;
            }
            catch (Exception e) {
                this.error("url: " + this.myFilePath, e);
                return new TIntHashSet(0);
            }
        }
        this.releaseZipFile(zipFile2);
        return tIntHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    Resource getResource(String name) {
        Resource resource;
        JarMemoryLoader loader;
        if (this.myConfiguration.myLazyClassloadingCaches) {
            int numberOfHits = this.myNumberOfRequests.incrementAndGet();
            TIntHashSet packagesInside = this.myPackageHashesInside;
            if (numberOfHits > 1000 && packagesInside == null) {
                this.myPackageHashesInside = packagesInside = this.buildPackageHashes();
            }
            if (packagesInside != null && !packagesInside.contains(ClasspathCache.getPackageNameHash(name))) {
                return null;
            }
        }
        JarMemoryLoader jarMemoryLoader = loader = this.myMemoryLoader != null ? (JarMemoryLoader)this.myMemoryLoader.get() : null;
        if (loader != null && (resource = loader.getResource(name)) != null) {
            return resource;
        }
        try {
            ZipFile zipFile2 = this.getZipFile();
            try {
                ZipEntry entry = zipFile2.getEntry(name);
                if (entry == null) return null;
                Resource resource2 = this.instantiateResource(this.getBaseURL(), entry);
                return resource2;
            }
            finally {
                this.releaseZipFile(zipFile2);
            }
        }
        catch (Exception e) {
            this.error("url: " + this.myFilePath, e);
        }
        return null;
    }

    protected Resource instantiateResource(URL url, ZipEntry entry) throws IOException {
        return new MyResource(url, entry);
    }

    protected void error(String message2, Throwable t) {
        if (this.myConfiguration.myLogErrorOnMissingJar) {
            LoggerRt.getInstance(JarLoader.class).error(message2, t);
        } else {
            LoggerRt.getInstance(JarLoader.class).warn(message2, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected ZipFile getZipFile() throws IOException {
        if (!this.myConfiguration.myCanLockJars) {
            ZipFile zipFile2 = this.createZipFile(this.myFilePath);
            if (zipFile2 != null) return zipFile2;
            JarLoader.$$$reportNull$$$0(5);
            return zipFile2;
        }
        ZipFile zipFile3 = SoftReference.dereference(this.myZipFileSoftReference);
        if (zipFile3 != null) {
            ZipFile zipFile4 = zipFile3;
            if (zipFile4 != null) return zipFile4;
            JarLoader.$$$reportNull$$$0(2);
            return zipFile4;
        }
        Object object = ourLock;
        // MONITORENTER : object
        zipFile3 = SoftReference.dereference(this.myZipFileSoftReference);
        if (zipFile3 != null) {
            ZipFile zipFile5 = zipFile3;
            // MONITOREXIT : object
            if (zipFile5 != null) return zipFile5;
            JarLoader.$$$reportNull$$$0(3);
            return zipFile5;
        }
        zipFile3 = this.createZipFile(this.myFilePath);
        this.myZipFileSoftReference = new SoftReference<ZipFile>(zipFile3);
        ZipFile zipFile6 = zipFile3;
        // MONITOREXIT : object
        if (zipFile6 != null) return zipFile6;
        JarLoader.$$$reportNull$$$0(4);
        return zipFile6;
    }

    @NotNull
    protected ZipFile createZipFile(String path2) throws IOException {
        ZipFile zipFile2 = new ZipFile(path2);
        if (zipFile2 == null) {
            JarLoader.$$$reportNull$$$0(6);
        }
        return zipFile2;
    }

    protected void releaseZipFile(ZipFile zipFile2) throws IOException {
        if (!this.myConfiguration.myCanLockJars) {
            zipFile2.close();
        }
    }

    public String toString() {
        return "JarLoader [" + this.myFilePath + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/JarLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/JarLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createZipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadManifestAttributes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyResource
    extends Resource {
        protected final URL myUrl;
        protected final ZipEntry myEntry;

        MyResource(URL url, ZipEntry entry) throws IOException {
            this.myUrl = new URL(url, entry.getName());
            this.myEntry = entry;
        }

        @Override
        public URL getURL() {
            return this.myUrl;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBytes() throws IOException {
            ZipFile file2 = JarLoader.this.getZipFile();
            InputStream stream = null;
            try {
                stream = file2.getInputStream(this.myEntry);
                byte[] byArray = FileUtilRt.loadBytes(stream, (int)this.myEntry.getSize());
                return byArray;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                JarLoader.this.releaseZipFile(file2);
            }
        }

        @Override
        public String getValue(Resource.Attribute key) {
            JarLoader.this.loadManifestAttributes();
            return JarLoader.this.myAttributes != null ? (String)JarLoader.this.myAttributes.get((Object)key) : null;
        }
    }
}

