/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.collections.AbstractSingletonFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.file.Stat;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class DefaultSingletonFileTree
extends AbstractSingletonFileTree {
    private final File file;
    private final FileSystem fileSystem = FileSystems.getDefault();

    public DefaultSingletonFileTree(File file) {
        this(file, new PatternSet());
    }

    public DefaultSingletonFileTree(File file, PatternSet patternSet) {
        super(patternSet);
        this.file = file;
    }

    @Override
    public String getDisplayName() {
        return String.format("file '%s'", this.file);
    }

    @Override
    protected FileVisitDetails createFileVisitDetails() {
        return new DefaultFileVisitDetails(this.file, (Chmod)this.fileSystem, (Stat)this.fileSystem);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public MinimalFileTree filter(PatternFilterable patterns) {
        return new DefaultSingletonFileTree(this.file, this.filterPatternSet(patterns));
    }
}

