/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.GeneratedGradleJarCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.vfs.AdditiveCache;

public class DefaultGeneratedGradleJarCache
implements GeneratedGradleJarCache,
Closeable,
AdditiveCache {
    public static final String BASE_DIR_OVERRIDE_PROPERTY = "org.gradle.cache.internal.generatedGradleJarCacheBaseDir";
    private final PersistentCache cache;
    private final String gradleVersion;

    public DefaultGeneratedGradleJarCache(CacheRepository cacheRepository, String gradleVersion) {
        this.cache = this.cacheBuilderFor(cacheRepository).withDisplayName("Generated Gradle JARs cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
        this.gradleVersion = gradleVersion;
    }

    private CacheBuilder cacheBuilderFor(CacheRepository cacheRepository) {
        String baseDirOverride = System.getProperty(BASE_DIR_OVERRIDE_PROPERTY);
        return baseDirOverride != null ? cacheRepository.cache(new File(baseDirOverride)) : cacheRepository.cache("generated-gradle-jars");
    }

    public File get(String identifier, final Action<File> creator) {
        final File jarFile = this.jarFile(identifier);
        this.cache.useCache(new Runnable(){

            @Override
            public void run() {
                if (!jarFile.exists()) {
                    creator.execute((Object)jarFile);
                }
            }
        });
        return jarFile;
    }

    @Override
    public void close() {
        this.cache.close();
    }

    private File jarFile(String identifier) {
        return new File(this.cache.getBaseDir(), "gradle-" + identifier + "-" + this.gradleVersion + ".jar");
    }

    @Override
    public List<File> getAdditiveCacheRoots() {
        return Collections.singletonList(this.cache.getBaseDir());
    }
}

