/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.invocation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.MutationGuards;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.resource.TextUriResourceLoader;
import org.gradle.internal.scan.config.BuildScanConfigInit;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;

public abstract class DefaultGradle
extends AbstractPluginAware
implements GradleInternal {
    private SettingsInternal settings;
    private ProjectInternal rootProject;
    private ProjectInternal defaultProject;
    private final GradleInternal parent;
    private final StartParameter startParameter;
    private final ServiceRegistry services;
    private final ListenerBroadcast<BuildListener> buildListenerBroadcast;
    private final ListenerBroadcast<ProjectEvaluationListener> projectEvaluationListenerBroadcast;
    private final CrossProjectConfigurator crossProjectConfigurator;
    private Collection<IncludedBuild> includedBuilds;
    private MutableActionSet<Project> rootProjectActions = new MutableActionSet();
    private boolean projectsLoaded;
    private Path identityPath;
    private ClassLoaderScope classLoaderScope;
    private GradleInternal.BuildType buildType = GradleInternal.BuildType.NONE;
    private ClassLoaderScope baseProjectClassLoaderScope;

    public DefaultGradle(GradleInternal parent, StartParameter startParameter, ServiceRegistryFactory parentRegistry) {
        this.parent = parent;
        this.startParameter = startParameter;
        this.services = parentRegistry.createFor(this);
        this.crossProjectConfigurator = (CrossProjectConfigurator)this.services.get(CrossProjectConfigurator.class);
        this.buildListenerBroadcast = this.getListenerManager().createAnonymousBroadcaster(BuildListener.class);
        this.projectEvaluationListenerBroadcast = this.getListenerManager().createAnonymousBroadcaster(ProjectEvaluationListener.class);
        this.buildListenerBroadcast.add((Object)new InternalBuildAdapter(){

            public void projectsLoaded(Gradle gradle) {
                if (!DefaultGradle.this.rootProjectActions.isEmpty()) {
                    ((CrossProjectConfigurator)DefaultGradle.this.services.get(CrossProjectConfigurator.class)).rootProject(DefaultGradle.this.rootProject, (Action<Project>)DefaultGradle.this.rootProjectActions);
                }
                DefaultGradle.this.projectsLoaded = true;
            }
        });
        if (parent == null) {
            ((BuildScanConfigInit)this.services.get(BuildScanConfigInit.class)).init();
        }
    }

    public String toString() {
        return this.rootProject == null ? "build" : "build '" + this.rootProject.getName() + "'";
    }

    @Override
    public Path getIdentityPath() {
        if (this.identityPath == null) {
            this.identityPath = ((PublicBuildPath)this.services.get(PublicBuildPath.class)).getBuildPath();
        }
        return this.identityPath;
    }

    @Override
    public String contextualize(String description) {
        if (this.getParent() == null) {
            return description;
        }
        Path contextPath = this.getIdentityPath();
        String context = contextPath == null ? this.getStartParameter().getCurrentDir().getName() : contextPath.getPath();
        return description + " (" + context + ")";
    }

    @Override
    public GradleInternal getParent() {
        return this.parent;
    }

    @Override
    public GradleInternal getRoot() {
        GradleInternal root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    @Override
    public BuildState getOwner() {
        return (BuildState)this.getServices().get(BuildState.class);
    }

    public String getGradleVersion() {
        return GradleVersion.current().getVersion();
    }

    public File getGradleHomeDir() {
        GradleInstallation gradleInstallation = this.getCurrentGradleInstallation().getInstallation();
        return gradleInstallation == null ? null : gradleInstallation.getGradleHome();
    }

    public File getGradleUserHomeDir() {
        return this.startParameter.getGradleUserHomeDir();
    }

    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    @Override
    public ClassLoaderScope baseProjectClassLoaderScope() {
        if (this.baseProjectClassLoaderScope == null) {
            throw new IllegalStateException("baseProjectClassLoaderScope not yet set");
        }
        return this.baseProjectClassLoaderScope;
    }

    @Override
    public void setBaseProjectClassLoaderScope(ClassLoaderScope classLoaderScope) {
        if (classLoaderScope == null) {
            throw new IllegalArgumentException("classLoaderScope must not be null");
        }
        if (this.baseProjectClassLoaderScope != null) {
            throw new IllegalStateException("baseProjectClassLoaderScope is already set");
        }
        this.baseProjectClassLoaderScope = classLoaderScope;
    }

    @Override
    public SettingsInternal getSettings() {
        if (this.settings == null) {
            throw new IllegalStateException("The settings are not yet available for " + this + ".");
        }
        return this.settings;
    }

    @Override
    public void setSettings(SettingsInternal settings) {
        this.settings = settings;
    }

    @Override
    public ProjectInternal getRootProject() {
        if (this.rootProject == null) {
            throw new IllegalStateException("The root project is not yet available for " + this + ".");
        }
        return this.rootProject;
    }

    @Override
    public void setRootProject(ProjectInternal rootProject) {
        this.rootProject = rootProject;
    }

    public void rootProject(Action<? super Project> action) {
        this.rootProject("Gradle.rootProject", action);
    }

    private void rootProject(String registrationPoint, Action<? super Project> action) {
        if (this.projectsLoaded) {
            assert (this.rootProject != null);
            action.execute((Object)this.rootProject);
        } else {
            this.rootProjectActions.add(this.getListenerBuildOperationDecorator().decorate(registrationPoint, action));
        }
    }

    public void allprojects(final Action<? super Project> action) {
        this.rootProject("Gradle.allprojects", (Action<? super Project>)new Action<Project>(){

            public void execute(Project project) {
                project.allprojects(action);
            }
        });
    }

    @Override
    public ProjectInternal getDefaultProject() {
        return this.defaultProject;
    }

    @Override
    public void setDefaultProject(ProjectInternal defaultProject) {
        this.defaultProject = defaultProject;
    }

    @Override
    @Inject
    public TaskExecutionGraphInternal getTaskGraph() {
        throw new UnsupportedOperationException();
    }

    public ProjectEvaluationListener addProjectEvaluationListener(ProjectEvaluationListener listener) {
        this.addListener("Gradle.addProjectEvaluationListener", listener);
        return listener;
    }

    public void removeProjectEvaluationListener(ProjectEvaluationListener listener) {
        this.removeListener(listener);
    }

    private void assertProjectMutatingMethodAllowed(String methodName) {
        MutationGuards.of(this.crossProjectConfigurator).assertMutationAllowed(methodName, this, Gradle.class);
    }

    public void beforeProject(Closure closure) {
        this.assertProjectMutatingMethodAllowed("beforeProject(Closure)");
        this.projectEvaluationListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Gradle.beforeProject", closure)));
    }

    public void beforeProject(Action<? super Project> action) {
        this.assertProjectMutatingMethodAllowed("beforeProject(Action)");
        this.projectEvaluationListenerBroadcast.add("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Gradle.beforeProject", action));
    }

    public void afterProject(Closure closure) {
        this.assertProjectMutatingMethodAllowed("afterProject(Closure)");
        this.projectEvaluationListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Gradle.afterProject", closure)));
    }

    public void afterProject(Action<? super Project> action) {
        this.assertProjectMutatingMethodAllowed("afterProject(Action)");
        this.projectEvaluationListenerBroadcast.add("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Gradle.afterProject", action));
    }

    public void buildStarted(Closure closure) {
        DeprecationLogger.deprecateMethod(Gradle.class, (String)"buildStarted(Closure)").withUpgradeGuideSection(5, "apis_buildlistener_buildstarted_and_gradle_buildstarted_have_been_deprecated").nagUser();
        this.buildListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("buildStarted", closure));
    }

    public void buildStarted(Action<? super Gradle> action) {
        DeprecationLogger.deprecateMethod(Gradle.class, (String)"buildStarted(Action)").withUpgradeGuideSection(5, "apis_buildlistener_buildstarted_and_gradle_buildstarted_have_been_deprecated").nagUser();
        this.buildListenerBroadcast.add("buildStarted", action);
    }

    public void beforeSettings(Closure<?> closure) {
        this.buildListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeSettings", closure));
    }

    public void beforeSettings(Action<? super Settings> action) {
        this.buildListenerBroadcast.add("beforeSettings", action);
    }

    public void settingsEvaluated(Closure closure) {
        this.buildListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("settingsEvaluated", closure));
    }

    public void settingsEvaluated(Action<? super Settings> action) {
        this.buildListenerBroadcast.add("settingsEvaluated", action);
    }

    public void projectsLoaded(Closure closure) {
        this.assertProjectMutatingMethodAllowed("projectsLoaded(Closure)");
        this.buildListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("projectsLoaded", this.getListenerBuildOperationDecorator().decorate("Gradle.projectsLoaded", closure)));
    }

    public void projectsLoaded(Action<? super Gradle> action) {
        this.assertProjectMutatingMethodAllowed("projectsLoaded(Action)");
        this.buildListenerBroadcast.add("projectsLoaded", this.getListenerBuildOperationDecorator().decorate("Gradle.projectsLoaded", action));
    }

    public void projectsEvaluated(Closure closure) {
        this.assertProjectMutatingMethodAllowed("projectsEvaluated(Closure)");
        this.buildListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("projectsEvaluated", this.getListenerBuildOperationDecorator().decorate("Gradle.projectsEvaluated", closure)));
    }

    public void projectsEvaluated(Action<? super Gradle> action) {
        this.assertProjectMutatingMethodAllowed("projectsEvaluated(Action)");
        this.buildListenerBroadcast.add("projectsEvaluated", this.getListenerBuildOperationDecorator().decorate("Gradle.projectsEvaluated", action));
    }

    public void buildFinished(Closure closure) {
        this.buildListenerBroadcast.add((Dispatch)new ClosureBackedMethodInvocationDispatch("buildFinished", closure));
    }

    public void buildFinished(Action<? super BuildResult> action) {
        this.buildListenerBroadcast.add("buildFinished", action);
    }

    public void addListener(Object listener) {
        if (listener instanceof BuildListener) {
            this.nagBuildStartedDeprecationIfOverriden(((BuildListener)listener).getClass());
        }
        this.addListener("Gradle.addListener", listener);
    }

    private void addListener(String registrationPoint, Object listener) {
        this.getListenerManager().addListener(this.getListenerBuildOperationDecorator().decorateUnknownListener(registrationPoint, listener));
    }

    public void removeListener(Object listener) {
        this.getListenerManager().removeListener(this.getListenerBuildOperationDecorator().decorateUnknownListener(null, listener));
    }

    public void useLogger(Object logger) {
        this.getListenerManager().useLogger(logger);
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return (ProjectEvaluationListener)this.projectEvaluationListenerBroadcast.getSource();
    }

    public void addBuildListener(BuildListener buildListener) {
        this.nagBuildStartedDeprecationIfOverriden(buildListener.getClass());
        this.addListener("Gradle.addBuildListener", buildListener);
    }

    private void nagBuildStartedDeprecationIfOverriden(Class<? extends BuildListener> buildListenerClass) {
        block3: {
            try {
                if (!ImmutableSet.of(BuildAdapter.class, InternalBuildAdapter.class).contains(buildListenerClass.getMethod("buildStarted", Gradle.class).getDeclaringClass())) {
                    DeprecationLogger.deprecateMethod(BuildListener.class, (String)"buildStarted(Gradle)").withUpgradeGuideSection(5, "apis_buildlistener_buildstarted_and_gradle_buildstarted_have_been_deprecated").nagUser();
                }
            }
            catch (NoSuchMethodException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    @Override
    public BuildListener getBuildListenerBroadcaster() {
        return (BuildListener)this.buildListenerBroadcast.getSource();
    }

    public Gradle getGradle() {
        return this;
    }

    @Inject
    public abstract BuildServiceRegistry getSharedServices();

    public Collection<IncludedBuild> getIncludedBuilds() {
        if (this.includedBuilds == null) {
            throw new IllegalStateException("Included builds are not yet available for this build.");
        }
        return this.includedBuilds;
    }

    @Override
    public void setIncludedBuilds(Collection<? extends IncludedBuild> includedBuilds) {
        this.includedBuilds = ImmutableList.copyOf(includedBuilds);
    }

    public IncludedBuild includedBuild(String name) {
        for (IncludedBuild includedBuild : this.getIncludedBuilds()) {
            if (!includedBuild.getName().equals(name)) continue;
            return includedBuild;
        }
        throw new UnknownDomainObjectException("Included build '" + name + "' not found in " + this.toString() + ".");
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    @Inject
    public ServiceRegistryFactory getServiceRegistryFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getClassLoaderScope(), this.getResourceLoaderFactory(), this);
    }

    @Override
    public void setClassLoaderScope(ClassLoaderScope classLoaderScope) {
        if (this.classLoaderScope != null) {
            throw new IllegalStateException("Class loader scope already used");
        }
        this.classLoaderScope = classLoaderScope;
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        if (this.classLoaderScope == null) {
            this.classLoaderScope = ((ClassLoaderScopeRegistry)this.services.get(ClassLoaderScopeRegistry.class)).getCoreAndPluginsScope();
        }
        return this.classLoaderScope;
    }

    @Inject
    protected TextUriResourceLoader.Factory getResourceLoaderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptHandlerFactory getScriptHandlerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptPluginFactory getScriptPluginFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CurrentGradleInstallation getCurrentGradleInstallation() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ListenerManager getListenerManager() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ListenerBuildOperationDecorator getListenerBuildOperationDecorator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public PluginManagerInternal getPluginManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public PublicBuildPath getPublicBuildPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GradleInternal.BuildType getBuildType() {
        return this.buildType;
    }

    @Override
    public void setBuildType(GradleInternal.BuildType buildType) {
        this.buildType = buildType;
    }
}

