/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.deprecation.DeprecationLogger;

public class TransformBackedProvider<OUT, IN>
extends AbstractMinimalProvider<OUT> {
    private final Transformer<? extends OUT, ? super IN> transformer;
    private final ProviderInternal<? extends IN> provider;

    public TransformBackedProvider(Transformer<? extends OUT, ? super IN> transformer, ProviderInternal<? extends IN> provider) {
        this.transformer = transformer;
        this.provider = provider;
    }

    @Override
    @Nullable
    public Class<OUT> getType() {
        return null;
    }

    public Transformer<? extends OUT, ? super IN> getTransformer() {
        return this.transformer;
    }

    @Override
    public void visitProducerTasks(Action<? super Task> visitor) {
        this.provider.visitProducerTasks(visitor);
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        return this.provider.maybeVisitBuildDependencies(context);
    }

    @Override
    public boolean isValueProducedByTask() {
        return this.provider.isValueProducedByTask() || !this.getProducerTasks().isEmpty();
    }

    @Override
    protected ValueSupplier.Value<? extends OUT> calculateOwnValue() {
        this.beforeRead();
        ValueSupplier.Value<IN> value = this.provider.calculateValue();
        if (value.isMissing()) {
            return value.asType();
        }
        Object result = this.transformer.transform(value.get());
        if (result == null) {
            return ValueSupplier.Value.missing();
        }
        return ValueSupplier.Value.of(result);
    }

    private void beforeRead() {
        for (Task producer : this.getProducerTasks()) {
            if (producer.getState().getExecuted()) continue;
            DeprecationLogger.deprecateAction((String)String.format("Querying the mapped value of %s before %s has completed", this.provider, producer)).withUpgradeGuideSection(6, "querying_a_mapped_output_property_of_a_task_before_the_task_has_completed").nagUser();
            break;
        }
    }

    private List<Task> getProducerTasks() {
        ArrayList<Task> producers = new ArrayList<Task>();
        this.provider.visitProducerTasks(producers::add);
        return producers;
    }

    @Override
    public String toString() {
        return "map(" + this.provider + ")";
    }
}

