/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.collections.AbstractSingletonFileTree;
import org.gradle.api.internal.file.collections.GeneratedFiles;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class GeneratedSingletonFileTree
extends AbstractSingletonFileTree
implements GeneratedFiles {
    private final Factory<File> tmpDirSource;
    private final FileSystem fileSystem = FileSystems.getDefault();
    private final String fileName;
    private final FileGenerationListener fileGenerationListener;
    private final Action<OutputStream> contentWriter;

    public GeneratedSingletonFileTree(Factory<File> tmpDirSource, String fileName, FileGenerationListener fileGenerationListener, Action<OutputStream> contentWriter) {
        this(tmpDirSource, fileName, new PatternSet(), fileGenerationListener, contentWriter);
    }

    public GeneratedSingletonFileTree(Factory<File> tmpDirSource, String fileName, PatternSet patternSet, FileGenerationListener fileGenerationListener, Action<OutputStream> contentWriter) {
        super(patternSet);
        this.tmpDirSource = tmpDirSource;
        this.fileName = fileName;
        this.fileGenerationListener = fileGenerationListener;
        this.contentWriter = contentWriter;
    }

    private File getTmpDir() {
        return (File)this.tmpDirSource.create();
    }

    @Override
    public String getDisplayName() {
        return "file tree";
    }

    @Override
    protected FileVisitDetails createFileVisitDetails() {
        return new FileVisitDetailsImpl(this.fileName, this.contentWriter, (Chmod)this.fileSystem);
    }

    public File getFileWithoutCreating() {
        return this.createFileInstance(this.fileName);
    }

    @Override
    public File getFile() {
        return new FileVisitDetailsImpl(this.fileName, this.contentWriter, (Chmod)this.fileSystem).getFile();
    }

    private File createFileInstance(String fileName) {
        return new File(this.getTmpDir(), fileName);
    }

    @Override
    public MinimalFileTree filter(PatternFilterable patterns) {
        return new GeneratedSingletonFileTree(this.tmpDirSource, this.fileName, this.filterPatternSet(patterns), this.fileGenerationListener, this.contentWriter);
    }

    private class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final String fileName;
        private final Action<OutputStream> generator;
        private long lastModified;
        private long size;
        private File file;

        public FileVisitDetailsImpl(String fileName, Action<OutputStream> generator, Chmod chmod) {
            super(chmod);
            this.fileName = fileName;
            this.generator = generator;
        }

        @Override
        public String getDisplayName() {
            return this.fileName;
        }

        public void stopVisiting() {
        }

        public File getFile() {
            if (this.file == null) {
                this.file = GeneratedSingletonFileTree.this.createFileInstance(this.fileName);
                if (!this.file.exists()) {
                    this.copyTo(this.file);
                } else {
                    this.updateFileOnlyWhenGeneratedContentChanges();
                }
                this.lastModified = this.file.lastModified() / 1000L * 1000L;
                this.size = this.file.length();
            }
            return this.file;
        }

        private void updateFileOnlyWhenGeneratedContentChanges() {
            byte[] generatedContent = this.generateContent();
            if (!this.hasContent(generatedContent, this.file)) {
                try {
                    GeneratedSingletonFileTree.this.fileGenerationListener.beforeFileGenerated(this.file.getAbsolutePath());
                    Files.write((byte[])generatedContent, (File)this.file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        }

        private byte[] generateContent() {
            StreamByteBuffer buffer = new StreamByteBuffer();
            this.copyTo(buffer.getOutputStream());
            return buffer.readAsByteArray();
        }

        private boolean hasContent(byte[] generatedContent, File file) {
            byte[] existingContent;
            if ((long)generatedContent.length != file.length()) {
                return false;
            }
            try {
                existingContent = Files.toByteArray((File)this.file);
            }
            catch (IOException e) {
                return false;
            }
            return Arrays.equals(generatedContent, existingContent);
        }

        @Override
        public void copyTo(OutputStream output) {
            this.generator.execute((Object)output);
        }

        public boolean isDirectory() {
            return false;
        }

        public long getLastModified() {
            this.getFile();
            return this.lastModified;
        }

        public long getSize() {
            this.getFile();
            return this.size;
        }

        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        public RelativePath getRelativePath() {
            return new RelativePath(true, new String[]{this.fileName});
        }
    }

    public static interface FileGenerationListener {
        public void beforeFileGenerated(String var1);
    }
}

