/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.Swiftc;
import org.gradle.nativeplatform.toolchain.SwiftcPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.ExtendableToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeLanguage;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.UnsupportedPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.swift.DefaultSwiftcPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.swift.SwiftPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadata;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;
import org.gradle.nativeplatform.toolchain.internal.tools.DefaultCommandLineToolConfiguration;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolSearchPath;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.platform.base.internal.toolchain.ToolChainAvailability;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.process.internal.ExecActionFactory;

public class SwiftcToolChain
extends ExtendableToolChain<SwiftcPlatformToolChain>
implements Swiftc {
    public static final String DEFAULT_NAME = "swiftc";
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final CompilerMetaDataProvider<SwiftcMetadata> compilerMetaDataProvider;
    private final Instantiator instantiator;
    private final ToolSearchPath toolSearchPath;
    private final ExecActionFactory execActionFactory;
    private final WorkerLeaseService workerLeaseService;
    private final Map<NativePlatform, PlatformToolProvider> toolProviders = Maps.newHashMap();

    public SwiftcToolChain(String name, BuildOperationExecutor buildOperationExecutor, OperatingSystem operatingSystem, PathToFileResolver fileResolver, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, CompilerMetaDataProvider<SwiftcMetadata> compilerMetaDataProvider, Instantiator instantiator, WorkerLeaseService workerLeaseService) {
        this(name, buildOperationExecutor, operatingSystem, fileResolver, execActionFactory, compilerOutputFileNamingSchemeFactory, new ToolSearchPath(operatingSystem), compilerMetaDataProvider, instantiator, workerLeaseService);
    }

    SwiftcToolChain(String name, BuildOperationExecutor buildOperationExecutor, OperatingSystem operatingSystem, PathToFileResolver fileResolver, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, ToolSearchPath tools, CompilerMetaDataProvider<SwiftcMetadata> compilerMetaDataProvider, Instantiator instantiator, WorkerLeaseService workerLeaseService) {
        super(name, buildOperationExecutor, operatingSystem, fileResolver);
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.compilerMetaDataProvider = compilerMetaDataProvider;
        this.instantiator = instantiator;
        this.toolSearchPath = tools;
        this.execActionFactory = execActionFactory;
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    public List<File> getPath() {
        return this.toolSearchPath.getPath();
    }

    @Override
    public void path(Object ... pathEntries) {
        for (Object path : pathEntries) {
            this.toolSearchPath.path(this.resolve(path));
        }
    }

    private PlatformToolProvider createPlatformToolProvider(NativePlatformInternal targetPlatform) {
        DefaultSwiftcPlatformToolChain configurableToolChain = (DefaultSwiftcPlatformToolChain)this.instantiator.newInstance(DefaultSwiftcPlatformToolChain.class, new Object[]{targetPlatform});
        this.addDefaultTools(configurableToolChain);
        this.configureActions.execute((Object)configurableToolChain);
        if (!this.isCurrentArchitecture(targetPlatform)) {
            return new UnsupportedPlatformToolProvider(targetPlatform.getOperatingSystem(), String.format("Don't know how to build for %s.", targetPlatform.getDisplayName()));
        }
        CommandLineToolSearchResult compiler = this.toolSearchPath.locate(ToolType.SWIFT_COMPILER, DEFAULT_NAME);
        ToolChainAvailability result = new ToolChainAvailability();
        result.mustBeAvailable((ToolSearchResult)compiler);
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), (ToolSearchResult)result);
        }
        SearchResult<SwiftcMetadata> swiftcMetaData = this.compilerMetaDataProvider.getCompilerMetaData(this.toolSearchPath.getPath(), (Action<CompilerMetaDataProvider.CompilerExecSpec>)((Action)spec -> spec.executable(compiler.getTool())));
        result.mustBeAvailable(swiftcMetaData);
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), (ToolSearchResult)result);
        }
        return new SwiftPlatformToolProvider(this.buildOperationExecutor, targetPlatform.getOperatingSystem(), this.toolSearchPath, configurableToolChain, this.execActionFactory, this.compilerOutputFileNamingSchemeFactory, this.workerLeaseService, (SwiftcMetadata)swiftcMetaData.getComponent());
    }

    private boolean isCurrentArchitecture(NativePlatformInternal targetPlatform) {
        return targetPlatform.getArchitecture().equals(DefaultNativePlatform.getCurrentArchitecture());
    }

    @Override
    public PlatformToolProvider select(NativeLanguage sourceLanguage, NativePlatformInternal targetMachine) {
        switch (sourceLanguage) {
            case SWIFT: 
            case ANY: {
                return this.select(targetMachine);
            }
        }
        return new UnsupportedPlatformToolProvider(targetMachine.getOperatingSystem(), String.format("Don't know how to compile language %s.", new Object[]{sourceLanguage}));
    }

    @Override
    public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
        PlatformToolProvider toolProvider = this.toolProviders.get(targetPlatform);
        if (toolProvider == null) {
            toolProvider = this.createPlatformToolProvider(targetPlatform);
            this.toolProviders.put(targetPlatform, toolProvider);
        }
        return toolProvider;
    }

    private void addDefaultTools(DefaultSwiftcPlatformToolChain toolChain) {
        toolChain.add((DefaultCommandLineToolConfiguration)this.instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.SWIFT_COMPILER}));
        toolChain.add((DefaultCommandLineToolConfiguration)this.instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.LINKER}));
        toolChain.add((DefaultCommandLineToolConfiguration)this.instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.STATIC_LIB_ARCHIVER}));
        toolChain.add((DefaultCommandLineToolConfiguration)this.instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.SYMBOL_EXTRACTOR}));
        toolChain.add((DefaultCommandLineToolConfiguration)this.instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.STRIPPER}));
    }

    @Override
    protected String getTypeName() {
        return "Swift Compiler";
    }
}

