/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GFileUtils;

public class DefaultTemporaryFileProvider
implements TemporaryFileProvider,
Serializable {
    private final Factory<File> baseDirFactory;

    public DefaultTemporaryFileProvider(Factory<File> fileFactory) {
        this.baseDirFactory = fileFactory;
    }

    @Override
    public File newTemporaryFile(String ... path) {
        return FileUtils.canonicalize((File)new File((File)this.baseDirFactory.create(), CollectionUtils.join((String)"/", (Object[])path)));
    }

    @Override
    public File createTemporaryFile(String prefix, @Nullable String suffix, String ... path) {
        File dir = new File((File)this.baseDirFactory.create(), CollectionUtils.join((String)"/", (Object[])path));
        GFileUtils.mkdirs((File)dir);
        try {
            return File.createTempFile(prefix, suffix, dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public File createTemporaryDirectory(@Nullable String prefix, @Nullable String suffix, String ... path) {
        File dir = new File((File)this.baseDirFactory.create(), CollectionUtils.join((String)"/", (Object[])path));
        GFileUtils.mkdirs((File)dir);
        try {
            File tmpDir = File.createTempFile("gradle", "projectDir", dir);
            tmpDir.delete();
            tmpDir.mkdir();
            return tmpDir;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

