/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.controlFlow;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.BranchingInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.CallInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlow;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.Instruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ReturnInstruction;

public class ControlFlowSubRange
implements ControlFlow {
    private final ControlFlow myControlFlow;
    private final int myStart;
    private final int myEnd;
    private List<Instruction> myInstructions;

    public ControlFlowSubRange(ControlFlow controlFlow, int start, int end) {
        this.myControlFlow = controlFlow;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        if (this.myInstructions == null) {
            ArrayList<Instruction> list2 = new ArrayList<Instruction>(this.myEnd - this.myStart);
            List<Instruction> oldList = this.myControlFlow.getInstructions();
            for (int i = this.myStart; i < this.myEnd; ++i) {
                Instruction instruction = oldList.get(i).clone();
                if (instruction instanceof BranchingInstruction) {
                    BranchingInstruction branchingInstruction = (BranchingInstruction)instruction;
                    branchingInstruction.offset = this.patchOffset(branchingInstruction.offset);
                }
                if (instruction instanceof CallInstruction) {
                    CallInstruction callInstruction = (CallInstruction)instruction;
                    callInstruction.procBegin = this.patchOffset(callInstruction.procBegin);
                    callInstruction.procEnd = this.patchOffset(callInstruction.procEnd);
                }
                if (instruction instanceof ReturnInstruction) {
                    ReturnInstruction returnInstruction = (ReturnInstruction)instruction;
                    CallInstruction callInstruction = new CallInstruction(this.patchOffset(returnInstruction.getProcBegin()), this.patchOffset(returnInstruction.getProcEnd()));
                    returnInstruction.setCallInstruction(callInstruction);
                }
                list2.add(instruction);
            }
            this.myInstructions = list2;
        }
        List<Instruction> list3 = this.myInstructions;
        if (list3 == null) {
            ControlFlowSubRange.$$$reportNull$$$0(0);
        }
        return list3;
    }

    private int patchOffset(int offset2) {
        if (offset2 < this.myStart) {
            offset2 = this.myStart;
        } else if (offset2 > this.myEnd) {
            offset2 = this.myEnd;
        }
        return offset2 -= this.myStart;
    }

    @Override
    public int getSize() {
        return this.myEnd - this.myStart;
    }

    @Override
    public int getStartOffset(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowSubRange.$$$reportNull$$$0(1);
        }
        return this.patchOffset(this.myControlFlow.getStartOffset(element));
    }

    @Override
    public int getEndOffset(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowSubRange.$$$reportNull$$$0(2);
        }
        return this.patchOffset(this.myControlFlow.getEndOffset(element));
    }

    @Override
    public PsiElement getElement(int offset2) {
        return this.myControlFlow.getElement(this.myStart + offset2);
    }

    @Override
    public boolean isConstantConditionOccurred() {
        return this.myControlFlow.isConstantConditionOccurred();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CF range:[").append(this.myStart).append("-").append(this.myEnd).append("]\n");
        List<Instruction> instructions = this.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            buffer.append(i).append(": ").append(instruction.toString()).append("\n");
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowSubRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowSubRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffset";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

