/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;

public class DefaultConfigurableFileTree
extends CompositeFileTree
implements ConfigurableFileTree {
    private Object dir;
    private final PatternSet patternSet;
    private final PathToFileResolver resolver;
    private final DefaultTaskDependency buildDependency;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public DefaultConfigurableFileTree(PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.resolver = resolver;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patternSet = (PatternSet)patternSetFactory.create();
        this.buildDependency = taskDependencyFactory.configurableDependency();
    }

    public PatternSet getPatterns() {
        return this.patternSet;
    }

    public DefaultConfigurableFileTree setDir(Object dir) {
        this.from(dir);
        return this;
    }

    public File getDir() {
        if (this.dir == null) {
            throw new InvalidUserDataException("A base directory must be specified in the task or via a method argument!");
        }
        return this.resolver.resolve(this.dir);
    }

    public DefaultConfigurableFileTree from(Object dir) {
        this.dir = dir;
        return this;
    }

    @Override
    public String getDisplayName() {
        return "directory '" + this.dir + "'";
    }

    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public DefaultConfigurableFileTree setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    public DefaultConfigurableFileTree setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }

    public DefaultConfigurableFileTree include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    public DefaultConfigurableFileTree include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    public DefaultConfigurableFileTree include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public DefaultConfigurableFileTree include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public DefaultConfigurableFileTree exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public DefaultConfigurableFileTree exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public DefaultConfigurableFileTree exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    public DefaultConfigurableFileTree exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        File dir = this.getDir();
        context.add(this.directoryFileTreeFactory.create(dir, this.patternSet));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.buildDependency);
    }

    public ConfigurableFileTree builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    public Set<Object> getBuiltBy() {
        return this.buildDependency.getMutableValues();
    }

    public ConfigurableFileTree setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }
}

