/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.internal.file.copy;


import org.gradle.api.Action;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;

import javax.annotation.Nullable;
import java.util.Collection;
import java.util.List;

public interface CopySpecResolver {

    boolean isCaseSensitive();
    @Nullable
    Integer getFileMode();
    @Nullable
    Integer getDirMode();
    boolean getIncludeEmptyDirs();
    String getFilteringCharset();

    RelativePath getDestPath();

    FileTree getSource();

    FileTree getAllSource();

    Collection<? extends Action<? super FileCopyDetails>> getAllCopyActions();

    List<String> getAllIncludes();

    List<String> getAllExcludes();

    List<Spec<FileTreeElement>> getAllIncludeSpecs();

    List<Spec<FileTreeElement>> getAllExcludeSpecs();

    DuplicatesStrategy getDuplicatesStrategy();

    boolean isDefaultDuplicateStrategy();

    void walk(Action<? super CopySpecResolver> action);


}
