/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import java.net.URI;
import org.gradle.api.artifacts.repositories.PasswordCredentials;

public class SftpHost {
    private final String hostname;
    private final int port;
    private final String username;
    private final String password;

    public SftpHost(URI uri, PasswordCredentials credentials) {
        this.hostname = uri.getHost();
        this.port = uri.getPort();
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SftpHost sftpHost = (SftpHost)o;
        if (this.port != sftpHost.port) {
            return false;
        }
        if (!this.hostname.equals(sftpHost.hostname)) {
            return false;
        }
        if (this.password != null ? !this.password.equals(sftpHost.password) : sftpHost.password != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(sftpHost.username) : sftpHost.username != null);
    }

    public int hashCode() {
        int result = this.hostname.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s:%d (Username: %s)", this.hostname, this.port, this.username);
    }
}

