/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.ManagedFactories;
import org.gradle.api.internal.provider.AbstractCombiningProvider;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.state.Managed;

public class DefaultFilePropertyFactory
implements FilePropertyFactory,
FileFactory {
    private final FileResolver fileResolver;
    private final FileCollectionFactory fileCollectionFactory;

    public DefaultFilePropertyFactory(FileResolver resolver, FileCollectionFactory fileCollectionFactory) {
        this.fileResolver = resolver;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public DirectoryProperty newDirectoryProperty() {
        return new DefaultDirectoryVar(this.fileResolver, this.fileCollectionFactory);
    }

    @Override
    public RegularFileProperty newFileProperty() {
        return new DefaultRegularFileVar(this.fileResolver);
    }

    @Override
    public Directory dir(File dir) {
        dir = this.fileResolver.resolve(dir);
        return new FixedDirectory(dir, this.fileResolver.newResolver(dir), this.fileCollectionFactory);
    }

    @Override
    public RegularFile file(File file) {
        file = this.fileResolver.resolve(file);
        return new FixedFile(file);
    }

    static class ToFileProvider
    extends AbstractMappingProvider<File, FileSystemLocation> {
        ToFileProvider(ProviderInternal<? extends FileSystemLocation> provider) {
            super(File.class, provider);
        }

        protected File mapValue(FileSystemLocation provider) {
            return provider.getAsFile();
        }
    }

    public static class DefaultDirectoryVar
    extends AbstractFileVar<Directory, DirectoryProperty>
    implements DirectoryProperty,
    Managed {
        private final FileResolver resolver;
        private final FileCollectionFactory fileCollectionFactory;

        DefaultDirectoryVar(FileResolver resolver, FileCollectionFactory fileCollectionFactory) {
            super(Directory.class);
            this.resolver = resolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        DefaultDirectoryVar(FileResolver resolver, FileCollectionFactory fileCollectionFactory, Object value) {
            super(Directory.class);
            this.resolver = resolver;
            this.fileCollectionFactory = fileCollectionFactory;
            this.resolveAndSet(value);
        }

        public Class<?> publicType() {
            return DirectoryProperty.class;
        }

        public int getFactoryId() {
            return ManagedFactories.DirectoryPropertyManagedFactory.FACTORY_ID;
        }

        public FileTree getAsFileTree() {
            return this.fileCollectionFactory.resolving(new Object[]{this}).getAsFileTree();
        }

        void resolveAndSet(Object value) {
            File resolved = this.resolver.resolve(value);
            FileResolver dirResolver = this.resolver.newResolver(resolved);
            this.set(new FixedDirectory(resolved, dirResolver, this.fileCollectionFactory.withResolver(dirResolver)));
        }

        @Override
        protected Directory fromFile(File dir) {
            File resolved = this.resolver.resolve(dir);
            FileResolver dirResolver = this.resolver.newResolver(resolved);
            return new FixedDirectory(resolved, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }

        public Provider<Directory> dir(final String path) {
            return new AbstractMappingProvider<Directory, Directory>(Directory.class, (ProviderInternal)this){

                protected Directory mapValue(Directory dir) {
                    return dir.dir(path);
                }
            };
        }

        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<Directory, Directory, CharSequence>(Directory.class, (ProviderInternal)this, Providers.internal(path)){

                protected Directory map(Directory b, CharSequence v) {
                    return b.dir(v.toString());
                }
            };
        }

        public Provider<RegularFile> file(final String path) {
            return new AbstractMappingProvider<RegularFile, Directory>(RegularFile.class, (ProviderInternal)this){

                protected RegularFile mapValue(Directory dir) {
                    return dir.file(path);
                }
            };
        }

        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<RegularFile, Directory, CharSequence>(RegularFile.class, (ProviderInternal)this, Providers.internal(path)){

                protected RegularFile map(Directory b, CharSequence v) {
                    return b.file(v.toString());
                }
            };
        }

        public FileCollection files(Object ... paths) {
            return this.fileCollectionFactory.withResolver(this.resolver).resolving(paths);
        }
    }

    static class ResolvingDirectory
    extends AbstractMappingProvider<Directory, CharSequence> {
        private final FileResolver resolver;
        private final FileCollectionFactory fileCollectionFactory;

        ResolvingDirectory(FileResolver resolver, FileCollectionFactory fileCollectionFactory, ProviderInternal<? extends CharSequence> valueProvider) {
            super(Directory.class, valueProvider);
            this.resolver = resolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        protected Directory mapValue(CharSequence path) {
            File dir = this.resolver.resolve(path);
            FileResolver dirResolver = this.resolver.newResolver(dir);
            return new FixedDirectory(dir, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }
    }

    public static class DefaultRegularFileVar
    extends AbstractFileVar<RegularFile, RegularFileProperty>
    implements RegularFileProperty,
    Managed {
        private final PathToFileResolver fileResolver;

        DefaultRegularFileVar(PathToFileResolver fileResolver) {
            super(RegularFile.class);
            this.fileResolver = fileResolver;
        }

        public Class<?> publicType() {
            return RegularFileProperty.class;
        }

        public int getFactoryId() {
            return ManagedFactories.RegularFilePropertyManagedFactory.FACTORY_ID;
        }

        @Override
        protected RegularFile fromFile(File file) {
            return new FixedFile(this.fileResolver.resolve((Object)file));
        }
    }

    static abstract class AbstractFileVar<T extends FileSystemLocation, THIS extends FileSystemLocationProperty<T>>
    extends DefaultProperty<T>
    implements FileSystemLocationProperty<T> {
        public AbstractFileVar(Class<T> type) {
            super(type);
        }

        protected abstract T fromFile(File var1);

        public Provider<File> getAsFile() {
            return new ToFileProvider((ProviderInternal<? extends FileSystemLocation>)this);
        }

        public void setFromAnyValue(Object object) {
            if (object instanceof File) {
                this.set((File)object);
            } else {
                super.setFromAnyValue(object);
            }
        }

        public THIS value(T value) {
            super.value(value);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast((Object)((Object)this)));
        }

        public THIS value(Provider<? extends T> provider) {
            super.value(provider);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast((Object)((Object)this)));
        }

        public void set(File file) {
            if (file == null) {
                this.set(null);
                return;
            }
            this.set(this.fromFile(file));
        }

        public THIS fileValue(@Nullable File file) {
            this.set(file);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast((Object)((Object)this)));
        }

        public THIS fileProvider(Provider<File> provider) {
            this.set(provider.map(file -> this.fromFile((File)file)));
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast((Object)((Object)this)));
        }

        public THIS convention(T value) {
            super.convention(value);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast((Object)((Object)this)));
        }

        public THIS convention(Provider<? extends T> valueProvider) {
            super.convention(valueProvider);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast((Object)((Object)this)));
        }

        public Provider<T> getLocationOnly() {
            return new AbstractMinimalProvider<T>(){

                @Nullable
                public Class<T> getType() {
                    return this.getType();
                }

                protected ValueSupplier.Value<? extends T> calculateOwnValue() {
                    return this.calculateOwnValue();
                }
            };
        }
    }

    static class ResolvingRegularFileProvider
    extends AbstractMappingProvider<RegularFile, CharSequence> {
        private final PathToFileResolver resolver;

        ResolvingRegularFileProvider(PathToFileResolver resolver, ProviderInternal<? extends CharSequence> path) {
            super(RegularFile.class, path);
            this.resolver = resolver;
        }

        protected RegularFile mapValue(CharSequence path) {
            return new FixedFile(this.resolver.resolve((Object)path));
        }
    }

    static class FixedFile
    extends DefaultFileSystemLocation
    implements RegularFile,
    Managed {
        FixedFile(File file) {
            super(file);
        }

        public boolean isImmutable() {
            return true;
        }

        public Class<?> publicType() {
            return RegularFile.class;
        }

        public Object unpackState() {
            return this.getAsFile();
        }

        public int getFactoryId() {
            return ManagedFactories.RegularFileManagedFactory.FACTORY_ID;
        }
    }

    static class FixedDirectory
    extends DefaultFileSystemLocation
    implements Directory,
    Managed {
        final FileResolver fileResolver;
        private final FileCollectionFactory fileCollectionFactory;

        FixedDirectory(File value, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory) {
            super(value);
            this.fileResolver = fileResolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        public boolean isImmutable() {
            return true;
        }

        public Class<?> publicType() {
            return Directory.class;
        }

        public Object unpackState() {
            return this.getAsFile();
        }

        public int getFactoryId() {
            return ManagedFactories.DirectoryManagedFactory.FACTORY_ID;
        }

        public Directory dir(String path) {
            File newDir = this.fileResolver.resolve(path);
            FileResolver dirResolver = this.fileResolver.newResolver(newDir);
            return new FixedDirectory(newDir, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }

        public FileTree getAsFileTree() {
            return this.fileCollectionFactory.resolving(this).getAsFileTree();
        }

        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new ResolvingDirectory(this.fileResolver, this.fileCollectionFactory, (ProviderInternal<? extends CharSequence>)Providers.internal(path));
        }

        public RegularFile file(String path) {
            return new FixedFile(this.fileResolver.resolve(path));
        }

        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new ResolvingRegularFileProvider(this.fileResolver, (ProviderInternal<? extends CharSequence>)Providers.internal(path));
        }

        public FileCollection files(Object ... paths) {
            return this.fileCollectionFactory.withResolver(this.fileResolver).resolving(paths);
        }
    }
}

