/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassPartContext;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class PropertyCodegen {
    private final GenerationState state;
    private final ClassBuilder v;
    private final FunctionCodegen functionCodegen;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final FieldOwnerContext context;
    private final MemberCodegen<?> memberCodegen;
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context2, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen2, @NotNull MemberCodegen<?> memberCodegen) {
        if (context2 == null) {
            PropertyCodegen.$$$reportNull$$$0(0);
        }
        if (v == null) {
            PropertyCodegen.$$$reportNull$$$0(1);
        }
        if (functionCodegen2 == null) {
            PropertyCodegen.$$$reportNull$$$0(2);
        }
        if (memberCodegen == null) {
            PropertyCodegen.$$$reportNull$$$0(3);
        }
        this.state = functionCodegen2.state;
        this.v = v;
        this.functionCodegen = functionCodegen2;
        this.typeMapper = this.state.getTypeMapper();
        this.bindingContext = this.state.getBindingContext();
        this.context = context2;
        this.memberCodegen = memberCodegen;
        this.kind = context2.getContextKind();
    }

    public void gen(@NotNull KtProperty property) {
        VariableDescriptor variableDescriptor;
        if (property == null) {
            PropertyCodegen.$$$reportNull$$$0(4);
        }
        if (!((variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property)) instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Property " + property.getName() + " should have a property descriptor: " + variableDescriptor, property);
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        this.gen(property, propertyDescriptor, property.getGetter(), property.getSetter());
    }

    public void genDestructuringDeclaration(@NotNull KtDestructuringDeclarationEntry entry) {
        VariableDescriptor variableDescriptor;
        if (entry == null) {
            PropertyCodegen.$$$reportNull$$$0(5);
        }
        if (!((variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, entry)) instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Destructuring declaration entry" + entry.getName() + " should have a property descriptor: " + variableDescriptor, entry);
        }
        if (!UnderscoreUtilKt.isSingleUnderscore(entry)) {
            this.genDestructuringDeclaration((PropertyDescriptor)variableDescriptor);
        }
    }

    public void generateInPackageFacade(@NotNull DeserializedPropertyDescriptor deserializedProperty) {
        if (deserializedProperty == null) {
            PropertyCodegen.$$$reportNull$$$0(6);
        }
        assert (this.context instanceof MultifileClassFacadeContext) : "should be called only for generating facade: " + this.context;
        this.genBackingFieldAndAnnotations(deserializedProperty);
        if (!JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(deserializedProperty)) {
            this.generateGetter(deserializedProperty, null);
            this.generateSetter(deserializedProperty, null);
        }
    }

    private void gen(@NotNull KtProperty declaration2, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter2, @Nullable KtPropertyAccessor setter2) {
        boolean isDefaultGetterAndSetter;
        if (declaration2 == null) {
            PropertyCodegen.$$$reportNull$$$0(7);
        }
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(8);
        }
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS || this.kind == OwnerKind.ERASED_INLINE_CLASS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        this.genBackingFieldAndAnnotations(descriptor2);
        boolean bl = isDefaultGetterAndSetter = PropertyCodegen.isDefaultAccessor(getter2) && PropertyCodegen.isDefaultAccessor(setter2);
        if (this.isAccessorNeeded(declaration2, descriptor2, getter2, isDefaultGetterAndSetter)) {
            this.generateGetter(descriptor2, getter2);
        }
        if (this.isAccessorNeeded(declaration2, descriptor2, setter2, isDefaultGetterAndSetter)) {
            this.generateSetter(descriptor2, setter2);
        }
    }

    private static boolean isDefaultAccessor(@Nullable KtPropertyAccessor accessor) {
        return accessor == null || !accessor.hasBody();
    }

    private void genDestructuringDeclaration(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(9);
        }
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        this.genBackingFieldAndAnnotations(descriptor2);
        this.generateGetter(descriptor2, null);
        this.generateSetter(descriptor2, null);
    }

    private void genBackingFieldAndAnnotations(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(10);
        }
        boolean isBackingFieldOwner = descriptor2.isConst() && !Visibilities.isPrivate(descriptor2.getVisibility()) ? !(this.context instanceof MultifileClassPartContext) : CodegenContextUtil.isImplementationOwner(this.context, descriptor2);
        this.generateBackingField(descriptor2, isBackingFieldOwner);
        this.generateSyntheticMethodIfNeeded(descriptor2, isBackingFieldOwner);
    }

    private boolean isAccessorNeeded(@NotNull KtProperty declaration2, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor accessor, boolean isDefaultGetterAndSetter) {
        if (declaration2 == null) {
            PropertyCodegen.$$$reportNull$$$0(11);
        }
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(12);
        }
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        boolean isDefaultAccessor = PropertyCodegen.isDefaultAccessor(accessor);
        if (this.kind == OwnerKind.DEFAULT_IMPLS && isDefaultAccessor) {
            return false;
        }
        if (declaration2.hasDelegate() || declaration2.getReceiverTypeReference() != null) {
            return true;
        }
        if (DescriptorUtils.isCompanionObject(descriptor2.getContainingDeclaration())) {
            return !Visibilities.isPrivate(descriptor2.getVisibility()) || !isDefaultGetterAndSetter;
        }
        if (PropertyCodegen.isTopLevelPropertyInMultifileClass(declaration2, descriptor2)) {
            return true;
        }
        if (Visibilities.isPrivate(descriptor2.getVisibility())) {
            return !isDefaultAccessor;
        }
        if (accessor != null && accessor.isSetter() && Visibilities.isPrivate(descriptor2.getSetter().getVisibility())) {
            return !isDefaultAccessor;
        }
        return true;
    }

    private static boolean isTopLevelPropertyInMultifileClass(@NotNull KtProperty declaration2, @NotNull PropertyDescriptor descriptor2) {
        if (declaration2 == null) {
            PropertyCodegen.$$$reportNull$$$0(13);
        }
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(14);
        }
        return descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration2);
    }

    private static boolean areAccessorsNeededForPrimaryConstructorProperty(@NotNull PropertyDescriptor descriptor2, @NotNull OwnerKind kind) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            PropertyCodegen.$$$reportNull$$$0(16);
        }
        if (JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        if (kind == OwnerKind.ERASED_INLINE_CLASS) {
            return false;
        }
        Visibility visibility = descriptor2.getVisibility();
        if (InlineClassesUtilsKt.isInlineClass(descriptor2.getContainingDeclaration())) {
            return visibility.isPublicAPI();
        }
        return !Visibilities.isPrivate(visibility);
    }

    public void generatePrimaryConstructorProperty(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(17);
        }
        this.genBackingFieldAndAnnotations(descriptor2);
        if (PropertyCodegen.areAccessorsNeededForPrimaryConstructorProperty(descriptor2, this.context.getContextKind())) {
            this.generateGetter(descriptor2, null);
            this.generateSetter(descriptor2, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(@NotNull KtParameter parameter, @NotNull PropertyDescriptor descriptor2, @Nullable FunctionDescriptor expectedAnnotationConstructor) {
        if (parameter == null) {
            PropertyCodegen.$$$reportNull$$$0(18);
        }
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(19);
        }
        JvmMethodGenericSignature signature = this.typeMapper.mapAnnotationParameterSignature(descriptor2);
        Method asmMethod2 = signature.getAsmMethod();
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(parameter, descriptor2), 1025, asmMethod2.getName(), asmMethod2.getDescriptor(), signature.getGenericsSignature(), null);
        PropertyGetterDescriptor getter2 = descriptor2.getGetter();
        assert (getter2 != null) : "Annotation property should have a getter: " + descriptor2;
        this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter2, asmMethod2);
        AnnotationCodegen.forMethod(mv, this.memberCodegen, this.state).genAnnotations(getter2, asmMethod2.getReturnType(), null);
        KtExpression defaultValue2 = this.loadAnnotationArgumentDefaultValue(parameter, descriptor2, expectedAnnotationConstructor);
        if (defaultValue2 != null) {
            ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(defaultValue2, this.bindingContext, true, this.state.getShouldInlineConstVals());
            assert (!this.state.getClassBuilderMode().generateBodies || constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue2.getText();
            if (constant != null) {
                AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(mv, this.memberCodegen, this.state);
                annotationCodegen.generateAnnotationDefaultValue(constant, descriptor2.getType());
            }
        }
        mv.visitEnd();
    }

    private KtExpression loadAnnotationArgumentDefaultValue(@NotNull KtParameter ktParameter, @NotNull PropertyDescriptor descriptor2, @Nullable FunctionDescriptor expectedAnnotationConstructor) {
        KtExpression value2;
        if (ktParameter == null) {
            PropertyCodegen.$$$reportNull$$$0(20);
        }
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(21);
        }
        if ((value2 = ktParameter.getDefaultValue()) != null) {
            return value2;
        }
        if (expectedAnnotationConstructor != null) {
            ValueParameterDescriptor expectedParameter = (ValueParameterDescriptor)CollectionsKt.single(expectedAnnotationConstructor.getValueParameters(), parameter -> parameter.getName().equals(descriptor2.getName()));
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(expectedParameter);
            if (!(element instanceof KtParameter)) {
                this.state.getDiagnostics().report(Errors.EXPECTED_FUNCTION_SOURCE_WITH_DEFAULT_ARGUMENTS_NOT_FOUND.on(ktParameter));
                return null;
            }
            return ((KtParameter)element).getDefaultValue();
        }
        return null;
    }

    private void generateBackingField(@NotNull PropertyDescriptor descriptor2, boolean isBackingFieldOwner) {
        Object defaultValue2;
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(22);
        }
        if (JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration()) || this.kind == OwnerKind.DEFAULT_IMPLS || this.kind == OwnerKind.ERASED_INLINE_CLASS) {
            return;
        }
        boolean isDelegate = descriptor2.isDelegated();
        if (isDelegate) {
            defaultValue2 = null;
        } else if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            ConstantValue<?> initializer2;
            defaultValue2 = this.shouldWriteFieldInitializer(descriptor2) ? ((initializer2 = descriptor2.getCompileTimeInitializer()) == null ? null : initializer2.getValue()) : null;
        } else {
            return;
        }
        this.generateBackingField(descriptor2, isDelegate, defaultValue2, isBackingFieldOwner);
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor2, boolean isBackingFieldOwner) {
        Annotations annotations2;
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(23);
        }
        if ((annotations2 = descriptor2.getAnnotations()).isEmpty()) {
            return;
        }
        Method signature = this.typeMapper.mapSyntheticMethodForPropertyAnnotations(descriptor2);
        if (this.kind != OwnerKind.DEFAULT_IMPLS && CodegenContextUtil.isImplementationOwner(this.context, descriptor2)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2, signature);
        }
        if (isBackingFieldOwner && (!DescriptorUtils.isInterface(this.context.getContextDescriptor()) || FunctionCodegen.processInterfaceMethod(descriptor2, this.kind, false, true, this.state.getJvmDefaultMode()))) {
            this.memberCodegen.generateSyntheticAnnotationsMethod(descriptor2, signature, annotations2);
        }
    }

    private void generateBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate, @Nullable Object defaultValue2, boolean isBackingFieldOwner) {
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(24);
        }
        FieldDescriptor annotatedField = isDelegate ? propertyDescriptor.getDelegateField() : propertyDescriptor.getBackingField();
        int modifiers2 = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.FIELD_FLAGS) {
            modifiers2 |= flagAnnotation.getJvmFlag(annotatedField);
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers2 |= 8;
        }
        if (!(propertyDescriptor.isLateInit() || propertyDescriptor.isVar() && !isDelegate)) {
            modifiers2 |= 0x10;
        }
        if (JvmAnnotationUtilKt.hasJvmSyntheticAnnotation(propertyDescriptor)) {
            modifiers2 |= 0x1000;
        }
        KotlinType kotlinType = isDelegate ? PropertyCodegen.getDelegateTypeForProperty(propertyDescriptor, this.bindingContext) : propertyDescriptor.getType();
        Type type2 = this.typeMapper.mapType(kotlinType);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor)) {
            modifiers2 |= 8;
            if (JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
                ImplementationBodyCodegen codegen2 = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
                builder = codegen2.v;
                backingFieldContext = codegen2.context;
            }
        }
        modifiers2 |= AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegate);
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addCompanionObjectPropertyToCopy(propertyDescriptor, defaultValue2);
        }
        String name = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor, new Pair((Object)type2, (Object)name));
        if (isBackingFieldOwner) {
            FieldVisitor fv = builder.newField(JvmDeclarationOriginKt.OtherOrigin(propertyDescriptor), modifiers2, name, type2.getDescriptor(), isDelegate ? null : this.typeMapper.mapFieldSignature(kotlinType, propertyDescriptor), defaultValue2);
            if (annotatedField != null) {
                AnnotationCodegen.forField(fv, this.memberCodegen, this.state).genAnnotations(annotatedField, type2, propertyDescriptor.getType());
            }
        }
    }

    @NotNull
    public static KotlinType getDelegateTypeForProperty(@NotNull PropertyDescriptor propertyDescriptor, @NotNull BindingContext bindingContext) {
        KtExpression delegateExpression2;
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(25);
        }
        if (bindingContext == null) {
            PropertyCodegen.$$$reportNull$$$0(26);
        }
        ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
        KtProperty property = (KtProperty)DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
        KtExpression ktExpression = delegateExpression2 = property != null ? property.getDelegateExpression() : null;
        KotlinType delegateType = provideDelegateResolvedCall != null ? provideDelegateResolvedCall.getResultingDescriptor().getReturnType() : (delegateExpression2 != null ? bindingContext.getType(delegateExpression2) : null);
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        KotlinType kotlinType = delegateType;
        if (kotlinType == null) {
            PropertyCodegen.$$$reportNull$$$0(27);
        }
        return kotlinType;
    }

    private boolean shouldWriteFieldInitializer(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(28);
        }
        if (!descriptor2.isConst() && this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.NoConstantValueAttributeForNonConstVals)) {
            return false;
        }
        if (!descriptor2.isVar()) {
            Type type2 = this.typeMapper.mapType(descriptor2);
            return AsmUtil.isPrimitive(type2) || "java.lang.String".equals(type2.getClassName());
        }
        return false;
    }

    private void generateGetter(@NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(29);
        }
        this.generateAccessor(getter2, descriptor2.getGetter() != null ? descriptor2.getGetter() : DescriptorFactory.createDefaultGetter(descriptor2, Annotations.Companion.getEMPTY()));
    }

    private void generateSetter(@NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor setter2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(30);
        }
        if (!descriptor2.isVar()) {
            return;
        }
        this.generateAccessor(setter2, descriptor2.getSetter() != null ? descriptor2.getSetter() : DescriptorFactory.createDefaultSetter(descriptor2, Annotations.Companion.getEMPTY(), Annotations.Companion.getEMPTY()));
    }

    private void generateAccessor(@Nullable KtPropertyAccessor accessor, @NotNull PropertyAccessorDescriptor descriptor2) {
        boolean isDelegated;
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(31);
        }
        if (this.context instanceof MultifileClassFacadeContext && (Visibilities.isPrivate(descriptor2.getVisibility()) || AsmUtil.getVisibilityAccessFlag(descriptor2) == 2)) {
            return;
        }
        FunctionGenerationStrategy.CodegenBased strategy = accessor == null || !accessor.hasBody() ? ((isDelegated = descriptor2.getCorrespondingProperty().isDelegated()) ? new DelegatedPropertyAccessorStrategy(this.state, descriptor2) : new DefaultPropertyAccessorStrategy(this.state, descriptor2)) : new FunctionGenerationStrategy.FunctionDefault(this.state, accessor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(descriptor2), descriptor2, strategy);
    }

    public static StackValue invokeDelegatedPropertyConventionMethod(@NotNull ExpressionCodegen codegen2, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, @NotNull StackValue receiver, @NotNull PropertyDescriptor propertyDescriptor) {
        if (codegen2 == null) {
            PropertyCodegen.$$$reportNull$$$0(32);
        }
        if (resolvedCall2 == null) {
            PropertyCodegen.$$$reportNull$$$0(33);
        }
        if (receiver == null) {
            PropertyCodegen.$$$reportNull$$$0(34);
        }
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(35);
        }
        codegen2.tempVariables.put(resolvedCall2.getCall().getValueArguments().get(1).asElement(), PropertyCodegen.getDelegatedPropertyMetadata(propertyDescriptor, codegen2.getBindingContext()));
        return codegen2.invokeFunction(resolvedCall2, receiver);
    }

    @NotNull
    public static StackValue getDelegatedPropertyMetadata(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull BindingContext bindingContext) {
        int index2;
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(36);
        }
        if (bindingContext == null) {
            PropertyCodegen.$$$reportNull$$$0(37);
        }
        if (Boolean.TRUE == bindingContext.get(CodegenBinding.DELEGATED_PROPERTY_WITH_OPTIMIZED_METADATA, descriptor2)) {
            StackValue stackValue = StackValue.constant(null, AsmTypes.K_PROPERTY_TYPE);
            if (stackValue == null) {
                PropertyCodegen.$$$reportNull$$$0(38);
            }
            return stackValue;
        }
        Type owner = bindingContext.get(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, descriptor2);
        assert (owner != null) : "Delegated property owner not found: " + descriptor2;
        List<VariableDescriptorWithAccessors> allDelegatedProperties = bindingContext.get(CodegenBinding.DELEGATED_PROPERTIES_WITH_METADATA, owner);
        int n = index2 = allDelegatedProperties == null ? -1 : allDelegatedProperties.indexOf(descriptor2);
        if (index2 < 0) {
            throw new AssertionError((Object)("Delegated property not found in " + owner + ": " + descriptor2));
        }
        StackValue.Field array = StackValue.field(Type.getType("[" + AsmTypes.K_PROPERTY_TYPE), owner, "$$delegatedProperties", true, StackValue.none());
        StackValue stackValue = StackValue.arrayElement(AsmTypes.K_PROPERTY_TYPE, null, array, StackValue.constant(index2));
        if (stackValue == null) {
            PropertyCodegen.$$$reportNull$$$0(39);
        }
        return stackValue;
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate, @NotNull PropertyDescriptor delegateTo, @NotNull StackValue field) {
        PropertySetterDescriptor setter2;
        if (delegate == null) {
            PropertyCodegen.$$$reportNull$$$0(40);
        }
        if (delegateTo == null) {
            PropertyCodegen.$$$reportNull$$$0(41);
        }
        if (field == null) {
            PropertyCodegen.$$$reportNull$$$0(42);
        }
        ClassDescriptor toClass = (ClassDescriptor)delegateTo.getContainingDeclaration();
        PropertyGetterDescriptor getter2 = delegate.getGetter();
        if (getter2 != null) {
            this.functionCodegen.genDelegate(getter2, delegateTo.getGetter().getOriginal(), toClass, field);
        }
        if ((setter2 = delegate.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter2, delegateTo.getSetter().getOriginal(), toClass, field);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 38: 
            case 39: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCodegen";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberCodegen";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deserializedProperty";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktParameter";
                break;
            }
            case 24: 
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 27: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/PropertyCodegen";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateTo";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/PropertyCodegen";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegateTypeForProperty";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegatedPropertyMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "gen";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "genDestructuringDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateInPackageFacade";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "genBackingFieldAndAnnotations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAccessorNeeded";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelPropertyInMultifileClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areAccessorsNeededForPrimaryConstructorProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generatePrimaryConstructorProperty";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateConstructorPropertyAsMethodForAnnotationClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadAnnotationArgumentDefaultValue";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "generateBackingField";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateSyntheticMethodIfNeeded";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDelegateTypeForProperty";
                break;
            }
            case 27: 
            case 38: 
            case 39: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldWriteFieldInitializer";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "generateGetter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "generateSetter";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "generateAccessor";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "invokeDelegatedPropertyConventionMethod";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDelegatedPropertyMetadata";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "genDelegate";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 27: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegatedPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DelegatedPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor2) {
            if (state == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(1);
            }
            super(state);
            this.propertyAccessorDescriptor = descriptor2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
            if (codegen2 == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(2);
            }
            if (signature == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(3);
            }
            InstructionAdapter v = codegen2.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.propertyAccessorDescriptor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + signature.toString();
            PropertyDescriptor propertyDescriptor = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property property = codegen2.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            StackValue.Property delegate = property.getDelegateOrNull();
            assert (delegate != null) : "No delegate for delegated property: " + propertyDescriptor;
            StackValue lastValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(codegen2, resolvedCall2, delegate, propertyDescriptor);
            Type asmType = signature.getReturnType();
            KotlinType kotlinReturnType = this.propertyAccessorDescriptor.getOriginal().getReturnType();
            lastValue.put(asmType, kotlinReturnType, v);
            v.areturn(asmType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doGenerateBody";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor2) {
            if (state == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(1);
            }
            super(state);
            this.propertyAccessorDescriptor = descriptor2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
            if (codegen2 == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(2);
            }
            if (signature == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(3);
            }
            InstructionAdapter v = codegen2.v;
            PropertyDescriptor propertyDescriptor = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property property = codegen2.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            PsiElement jetProperty = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
            if (jetProperty instanceof KtProperty || jetProperty instanceof KtParameter) {
                codegen2.markLineNumber((KtElement)jetProperty, false);
            }
            if (this.propertyAccessorDescriptor instanceof PropertyGetterDescriptor) {
                Type type2 = signature.getReturnType();
                property.put(type2, v);
                v.areturn(type2);
            } else if (this.propertyAccessorDescriptor instanceof PropertySetterDescriptor) {
                List<ValueParameterDescriptor> valueParameters2 = this.propertyAccessorDescriptor.getValueParameters();
                assert (valueParameters2.size() == 1) : "Property setter should have only one value parameter but has " + this.propertyAccessorDescriptor;
                int parameterIndex = codegen2.lookupLocalIndex(valueParameters2.get(0));
                assert (parameterIndex >= 0) : "Local index for setter parameter should be positive or zero: " + this.propertyAccessorDescriptor;
                Type type3 = codegen2.typeMapper.mapType(propertyDescriptor);
                property.store(StackValue.local(parameterIndex, type3), codegen2.v);
                v.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.propertyAccessorDescriptor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doGenerateBody";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

