/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.synthetic.SyntheticMemberDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.BuiltInsProviderKt;
import org.jetbrains.kotlin.resolve.calls.components.CompletionModeCalculator;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.components.TrivialConstraintTypeInferenceOracle;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.AllCandidatesResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.CandidateWithDiagnostics;
import org.jetbrains.kotlin.resolve.calls.model.CompletedCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.ErrorCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ManyCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.NoneCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.PartialCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedToSamWithVarargDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.SimpleCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.model.SingleCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J:\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002J.\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010!\u001a\u00020\u0016*\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001e\u0010#\u001a\u00020\u0016*\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010$\u001a\u00020\n*\u00020\r2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020&J\u0014\u0010'\u001a\u00020\u0016*\u00020\r2\u0006\u0010(\u001a\u00020&H\u0002J\f\u0010)\u001a\u00020 *\u00020\rH\u0002J$\u0010\u0015\u001a\u00020\n*\u00020\r2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010\u000f*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;", "", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "trivialConstraintTypeInferenceOracle", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "(Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;)V", "createAllCandidatesResult", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "candidates", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "prepareCandidateForCompletion", "factory", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "runCompletion", "", "resolvedCallAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter$ConstraintSystemCompletionMode;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "collectAllCandidatesMode", "", "addExpectedTypeConstraint", "returnType", "addExpectedTypeFromCastConstraint", "asCallResolutionResult", "type", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder$SimpleHolder;", "checkSamWithVararg", "diagnosticHolder", "isErrorCandidate", "completionType", "substitutedReturnType", "resolution"})
public final class KotlinCallCompleter {
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;
    private final TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle;

    @NotNull
    public final CallResolutionResult runCompletion(@NotNull SimpleCandidateFactory factory2, @NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        if (candidates2.isEmpty()) {
            diagnosticHolder.addDiagnostic(new NoneCandidatesCallDiagnostic(factory2.getKotlinCall()));
        } else if (candidates2.size() > 1) {
            diagnosticHolder.addDiagnostic(new ManyCandidatesCallDiagnostic(factory2.getKotlinCall(), candidates2));
        }
        KotlinResolutionCandidate candidate2 = this.prepareCandidateForCompletion(factory2, candidates2, resolutionCallbacks);
        UnwrappedType returnType2 = this.substitutedReturnType(candidate2);
        this.addExpectedTypeConstraint(candidate2, returnType2, expectedType);
        this.addExpectedTypeFromCastConstraint(candidate2, returnType2, resolutionCallbacks);
        this.checkSamWithVararg(candidate2, diagnosticHolder);
        return resolutionCallbacks.getInferenceSession().shouldRunCompletion(candidate2) ? this.runCompletion(candidate2, CompletionModeCalculator.Companion.computeCompletionMode(candidate2, expectedType, returnType2, this.trivialConstraintTypeInferenceOracle), diagnosticHolder, resolutionCallbacks) : this.asCallResolutionResult(candidate2, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL, diagnosticHolder);
    }

    private final void checkSamWithVararg(@NotNull KotlinResolutionCandidate $this$checkSamWithVararg, KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder) {
        boolean samConversionPerArgumentWithWarningsForVarargAfterSam;
        boolean bl = samConversionPerArgumentWithWarningsForVarargAfterSam = $this$checkSamWithVararg.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.SamConversionPerArgument) && !$this$checkSamWithVararg.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitVarargAsArrayAfterSamArgument);
        if (samConversionPerArgumentWithWarningsForVarargAfterSam && $this$checkSamWithVararg.getResolvedCall().getCandidateDescriptor() instanceof SyntheticMemberDescriptor) {
            Object t = ((SyntheticMemberDescriptor)((Object)$this$checkSamWithVararg.getResolvedCall().getCandidateDescriptor())).getBaseDescriptorForSynthetic();
            if (!(t instanceof FunctionDescriptor)) {
                t = null;
            }
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)t;
            if (functionDescriptor == null) {
                return;
            }
            FunctionDescriptor declarationDescriptor = functionDescriptor;
            List<ValueParameterDescriptor> list2 = declarationDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"declarationDescriptor.valueParameters");
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.lastOrNull(list2);
            if (valueParameterDescriptor != null) {
                if (ArgumentsUtilsKt.isVararg(valueParameterDescriptor)) {
                    KotlinCallArgument kotlinCallArgument = (KotlinCallArgument)CollectionsKt.lastOrNull($this$checkSamWithVararg.getResolvedCall().getAtom().getArgumentsInParenthesis());
                    if (kotlinCallArgument == null) {
                        return;
                    }
                    diagnosticHolder.addDiagnostic(new ResolvedToSamWithVarargDiagnostic(kotlinCallArgument));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CallResolutionResult createAllCandidatesResult(@NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Iterable $this$map$iv = candidates2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void candidate2;
            KotlinResolutionCandidate kotlinResolutionCandidate = (KotlinResolutionCandidate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder = new KotlinDiagnosticsHolder.SimpleHolder();
            this.addExpectedTypeConstraint((KotlinResolutionCandidate)candidate2, this.substitutedReturnType((KotlinResolutionCandidate)candidate2), expectedType);
            this.runCompletion(candidate2.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticsHolder, candidate2.getSystem(), resolutionCallbacks, true);
            CandidateWithDiagnostics candidateWithDiagnostics = new CandidateWithDiagnostics((KotlinResolutionCandidate)candidate2, CollectionsKt.plus((Collection)diagnosticsHolder.getDiagnostics(), (Iterable)candidate2.getDiagnosticsFromResolutionParts()));
            collection.add(candidateWithDiagnostics);
        }
        List completedCandidates = (List)destination$iv$iv;
        return new AllCandidatesResolutionResult(completedCandidates);
    }

    private final CallResolutionResult runCompletion(@NotNull KotlinResolutionCandidate $this$runCompletion, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionType, KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder, KotlinResolutionCallbacks resolutionCallbacks) {
        if (this.isErrorCandidate($this$runCompletion)) {
            KotlinCallCompleter.runCompletion$default(this, $this$runCompletion.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticHolder, $this$runCompletion.getSystem(), resolutionCallbacks, false, 32, null);
            return this.asCallResolutionResult($this$runCompletion, completionType, diagnosticHolder);
        }
        KotlinCallCompleter.runCompletion$default(this, $this$runCompletion.getResolvedCall(), completionType, diagnosticHolder, $this$runCompletion.getSystem(), resolutionCallbacks, false, 32, null);
        return this.asCallResolutionResult($this$runCompletion, completionType, diagnosticHolder);
    }

    private final void runCompletion(ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionMode, KotlinDiagnosticsHolder diagnosticsHolder, NewConstraintSystem constraintSystem, KotlinResolutionCallbacks resolutionCallbacks, boolean collectAllCandidatesMode) {
        UnwrappedType unwrappedType = ResolutionAtomsKt.getFreshReturnType(resolvedCallAtom);
        if (unwrappedType == null) {
            SimpleType simpleType2 = BuiltInsProviderKt.getBuiltIns(constraintSystem).getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"constraintSystem.builtIns.unitType");
            unwrappedType = simpleType2;
        }
        UnwrappedType returnType2 = unwrappedType;
        this.kotlinConstraintSystemCompleter.runCompletion(constraintSystem.asConstraintSystemCompleterContext(), completionMode, CollectionsKt.listOf((Object)resolvedCallAtom), returnType2, (Function1<? super PostponedResolvedAtom, Unit>)((Function1)new Function1<PostponedResolvedAtom, Unit>(this, collectAllCandidatesMode, constraintSystem, resolutionCallbacks, diagnosticsHolder){
            final /* synthetic */ KotlinCallCompleter this$0;
            final /* synthetic */ boolean $collectAllCandidatesMode;
            final /* synthetic */ NewConstraintSystem $constraintSystem;
            final /* synthetic */ KotlinResolutionCallbacks $resolutionCallbacks;
            final /* synthetic */ KotlinDiagnosticsHolder $diagnosticsHolder;

            public final void invoke(@NotNull PostponedResolvedAtom it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (this.$collectAllCandidatesMode) {
                    it.setEmptyAnalyzedResults();
                } else {
                    KotlinCallCompleter.access$getPostponedArgumentsAnalyzer$p(this.this$0).analyze(this.$constraintSystem.asPostponedArgumentsAnalyzerContext(), this.$resolutionCallbacks, it, this.$diagnosticsHolder);
                }
            }
            {
                this.this$0 = kotlinCallCompleter;
                this.$collectAllCandidatesMode = bl;
                this.$constraintSystem = newConstraintSystem;
                this.$resolutionCallbacks = kotlinResolutionCallbacks;
                this.$diagnosticsHolder = kotlinDiagnosticsHolder;
                super(1);
            }
        }));
        Iterable $this$forEach$iv = constraintSystem.getDiagnostics();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCallDiagnostic p1 = (KotlinCallDiagnostic)element$iv;
            boolean bl = false;
            diagnosticsHolder.addDiagnostic(p1);
        }
    }

    static /* synthetic */ void runCompletion$default(KotlinCallCompleter kotlinCallCompleter, ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode constraintSystemCompletionMode, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, NewConstraintSystem newConstraintSystem, KotlinResolutionCallbacks kotlinResolutionCallbacks, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinCallCompleter.runCompletion(resolvedCallAtom, constraintSystemCompletionMode, kotlinDiagnosticsHolder, newConstraintSystem, kotlinResolutionCallbacks, bl);
    }

    private final KotlinResolutionCandidate prepareCandidateForCompletion(SimpleCandidateFactory factory2, Collection<KotlinResolutionCandidate> candidates2, KotlinResolutionCallbacks resolutionCallbacks) {
        KotlinResolutionCandidate kotlinResolutionCandidate;
        KotlinResolutionCandidate candidate2 = (KotlinResolutionCandidate)CollectionsKt.singleOrNull((Iterable)candidates2);
        Object object = candidate2;
        if (object != null && (object = ((KotlinResolutionCandidate)object).getResolvedCall()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            resolutionCallbacks.bindStubResolvedCallForCandidate((ResolvedCallAtom)it);
            resolutionCallbacks.disableContractsIfNecessary((ResolvedCallAtom)it);
        }
        if ((kotlinResolutionCandidate = candidate2) == null) {
            kotlinResolutionCandidate = (KotlinResolutionCandidate)TowerUtilsKt.forceResolution((Candidate)factory2.createErrorCandidate());
        }
        return kotlinResolutionCandidate;
    }

    private final UnwrappedType substitutedReturnType(@NotNull KotlinResolutionCandidate $this$substitutedReturnType) {
        KotlinType kotlinType = $this$substitutedReturnType.getResolvedCall().getCandidateDescriptor().getReturnType();
        if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
            return null;
        }
        KotlinType returnType2 = kotlinType;
        return $this$substitutedReturnType.getResolvedCall().getFreshVariablesSubstitutor().safeSubstitute((UnwrappedType)returnType2);
    }

    private final void addExpectedTypeConstraint(@NotNull KotlinResolutionCandidate $this$addExpectedTypeConstraint, UnwrappedType returnType2, UnwrappedType expectedType) {
        if (returnType2 == null) {
            return;
        }
        if (expectedType == null || TypeUtils.noExpectedType(expectedType) && expectedType != TypeUtils.UNIT_EXPECTED_TYPE) {
            return;
        }
        if ($this$addExpectedTypeConstraint.getCsBuilder$resolution().currentStorage().getNotFixedTypeVariables().isEmpty()) {
            return;
        }
        if (expectedType == TypeUtils.UNIT_EXPECTED_TYPE) {
            ConstraintSystemBuilder constraintSystemBuilder = $this$addExpectedTypeConstraint.getCsBuilder$resolution();
            KotlinTypeMarker kotlinTypeMarker = returnType2;
            SimpleType simpleType2 = BuiltInsProviderKt.getBuiltIns($this$addExpectedTypeConstraint.getCsBuilder$resolution()).getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"csBuilder.builtIns.unitType");
            ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(constraintSystemBuilder, kotlinTypeMarker, simpleType2, new ExpectedTypeConstraintPosition($this$addExpectedTypeConstraint.getResolvedCall().getAtom()));
        } else {
            $this$addExpectedTypeConstraint.getCsBuilder$resolution().addSubtypeConstraint(returnType2, expectedType, new ExpectedTypeConstraintPosition($this$addExpectedTypeConstraint.getResolvedCall().getAtom()));
        }
    }

    private final void addExpectedTypeFromCastConstraint(@NotNull KotlinResolutionCandidate $this$addExpectedTypeFromCastConstraint, UnwrappedType returnType2, KotlinResolutionCallbacks resolutionCallbacks) {
        if (!$this$addExpectedTypeFromCastConstraint.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.ExpectedTypeFromCast)) {
            return;
        }
        if (returnType2 == null) {
            return;
        }
        UnwrappedType unwrappedType = resolutionCallbacks.getExpectedTypeFromAsExpressionAndRecordItInTrace($this$addExpectedTypeFromCastConstraint.getResolvedCall());
        if (unwrappedType == null) {
            return;
        }
        UnwrappedType expectedType = unwrappedType;
        $this$addExpectedTypeFromCastConstraint.getCsBuilder$resolution().addSubtypeConstraint(returnType2, expectedType, new ExpectedTypeConstraintPosition($this$addExpectedTypeFromCastConstraint.getResolvedCall().getAtom()));
    }

    @NotNull
    public final CallResolutionResult asCallResolutionResult(@NotNull KotlinResolutionCandidate $this$asCallResolutionResult, @NotNull KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode type2, @NotNull KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asCallResolutionResult, (String)"$this$asCallResolutionResult");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type2), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        ConstraintStorage systemStorage = $this$asCallResolutionResult.getSystem().asReadOnlyStorage();
        List allDiagnostics = CollectionsKt.plus((Collection)diagnosticsHolder.getDiagnostics(), (Iterable)$this$asCallResolutionResult.getDiagnosticsFromResolutionParts());
        if (this.isErrorCandidate($this$asCallResolutionResult)) {
            return new ErrorCallResolutionResult($this$asCallResolutionResult.getResolvedCall(), allDiagnostics, systemStorage);
        }
        return type2 == KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL ? (SingleCallResolutionResult)new CompletedCallResolutionResult($this$asCallResolutionResult.getResolvedCall(), allDiagnostics, systemStorage) : (SingleCallResolutionResult)new PartialCallResolutionResult($this$asCallResolutionResult.getResolvedCall(), allDiagnostics, systemStorage);
    }

    private final boolean isErrorCandidate(@NotNull KotlinResolutionCandidate $this$isErrorCandidate) {
        return ErrorUtils.isError($this$isErrorCandidate.getResolvedCall().getCandidateDescriptor()) || ConstraintStorage.Empty.INSTANCE.getHasContradiction();
    }

    public KotlinCallCompleter(@NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter, @NotNull TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle) {
        Intrinsics.checkParameterIsNotNull((Object)postponedArgumentsAnalyzer, (String)"postponedArgumentsAnalyzer");
        Intrinsics.checkParameterIsNotNull((Object)kotlinConstraintSystemCompleter, (String)"kotlinConstraintSystemCompleter");
        Intrinsics.checkParameterIsNotNull((Object)trivialConstraintTypeInferenceOracle, (String)"trivialConstraintTypeInferenceOracle");
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
        this.trivialConstraintTypeInferenceOracle = trivialConstraintTypeInferenceOracle;
    }

    public static final /* synthetic */ PostponedArgumentsAnalyzer access$getPostponedArgumentsAnalyzer$p(KotlinCallCompleter $this) {
        return $this.postponedArgumentsAnalyzer;
    }
}

