/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.invocation.Gradle;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.kotlin.dsl.accessors.AccessorsClassPathKt;
import org.gradle.kotlin.dsl.execution.CompiledScript;
import org.gradle.kotlin.dsl.execution.EvalOption;
import org.gradle.kotlin.dsl.execution.EvalOptionKt;
import org.gradle.kotlin.dsl.execution.ExecutableProgram;
import org.gradle.kotlin.dsl.execution.Interpreter$Host$WhenMappings;
import org.gradle.kotlin.dsl.execution.InterpreterKt;
import org.gradle.kotlin.dsl.execution.Packaged;
import org.gradle.kotlin.dsl.execution.PartialEvaluator;
import org.gradle.kotlin.dsl.execution.Program;
import org.gradle.kotlin.dsl.execution.ProgramId;
import org.gradle.kotlin.dsl.execution.ProgramKind;
import org.gradle.kotlin.dsl.execution.ProgramParser;
import org.gradle.kotlin.dsl.execution.ProgramSource;
import org.gradle.kotlin.dsl.execution.ProgramTarget;
import org.gradle.kotlin.dsl.execution.ResidualProgram;
import org.gradle.kotlin.dsl.execution.ResidualProgramCompiler;
import org.gradle.kotlin.dsl.execution.ResidualProgramCompilerKt;
import org.gradle.kotlin.dsl.execution.TemporaryScriptFilesKt;
import org.gradle.kotlin.dsl.support.GradleExtensionsKt;
import org.gradle.kotlin.dsl.support.KotlinScriptHost;
import org.gradle.kotlin.dsl.support.ProjectExtensionsKt;
import org.gradle.kotlin.dsl.support.ScriptCompilationException;
import org.gradle.kotlin.dsl.support.SettingsExtensionsKt;
import org.gradle.kotlin.dsl.support.UnsafeLazyKt;
import org.gradle.plugin.management.internal.PluginRequests;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003567B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JV\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JR\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0012\b\u0002\u0010#\u001a\f\u0012\u0004\u0012\u00020%0$j\u0002`&J:\u0010'\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00122\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010.\u001a\u00060\u0006R\u00020\u00002\u0010\u0010#\u001a\f\u0012\u0004\u0012\u00020%0$j\u0002`&H\u0002J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002J>\u00100\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020*H\u0002J\u0018\u00103\u001a\u0002042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0012H\u0002R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00068"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter;", "", "host", "Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;)V", "defaultProgramHost", "Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "getHost", "()Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "emitSpecializedProgramFor", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "templateId", "", "parentClassLoader", "Ljava/lang/ClassLoader;", "targetScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "baseScope", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "eval", "", "target", "scriptHandler", "Lorg/gradle/api/initialization/dsl/ScriptHandler;", "topLevelScript", "", "options", "Ljava/util/EnumSet;", "Lorg/gradle/kotlin/dsl/execution/EvalOption;", "Lorg/gradle/kotlin/dsl/execution/EvalOptions;", "loadClassInChildScopeOf", "scriptPath", "classesDir", "Ljava/io/File;", "scriptTemplateId", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "programHostFor", "programTargetFor", "scriptHostFor", "stage1SubDirOf", "cachedDir", "startCompilerOperationFor", "Ljava/lang/AutoCloseable;", "FirstStageOnlyProgramHost", "Host", "ProgramHost", "gradle-kotlin-dsl"})
public final class Interpreter {
    private final ProgramHost defaultProgramHost;
    @NotNull
    private final Host host;

    public final void eval(@NotNull Object target, @NotNull ScriptSource scriptSource, @NotNull HashCode sourceHash, @NotNull ScriptHandler scriptHandler, @NotNull ClassLoaderScope targetScope, @NotNull ClassLoaderScope baseScope, boolean topLevelScript, @NotNull EnumSet<EvalOption> options) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)scriptSource, (String)"scriptSource");
        Intrinsics.checkParameterIsNotNull((Object)sourceHash, (String)"sourceHash");
        Intrinsics.checkParameterIsNotNull((Object)scriptHandler, (String)"scriptHandler");
        Intrinsics.checkParameterIsNotNull((Object)targetScope, (String)"targetScope");
        Intrinsics.checkParameterIsNotNull((Object)baseScope, (String)"baseScope");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        ProgramKind programKind = topLevelScript ? ProgramKind.TopLevel : ProgramKind.ScriptPlugin;
        ProgramTarget programTarget = this.programTargetFor(target);
        String templateId = InterpreterKt.templateIdFor(programTarget, programKind, "stage1");
        ClassLoader classLoader = baseScope.getExportClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"baseScope.exportClassLoader");
        ClassLoader parentClassLoader = classLoader;
        ProgramId programId = new ProgramId(templateId, sourceHash, parentClassLoader, null, 8, null);
        CompiledScript cachedProgram = this.host.cachedClassFor(programId);
        KotlinScriptHost<Object> scriptHost = this.scriptHostFor(programTarget, target, scriptSource, scriptHandler, targetScope, baseScope);
        ProgramHost programHost = this.programHostFor(options);
        if (cachedProgram != null) {
            programHost.eval(cachedProgram.getProgramFor(), scriptHost);
            return;
        }
        CompiledScript specializedProgram = this.emitSpecializedProgramFor(scriptHost, scriptSource, sourceHash, templateId, parentClassLoader, targetScope, baseScope, programKind, programTarget);
        this.host.cache(specializedProgram, programId);
        programHost.eval(specializedProgram.getProgramFor(), scriptHost);
    }

    public static /* synthetic */ void eval$default(Interpreter interpreter2, Object object, ScriptSource scriptSource, HashCode hashCode, ScriptHandler scriptHandler, ClassLoaderScope classLoaderScope, ClassLoaderScope classLoaderScope2, boolean bl, EnumSet enumSet, int n, Object object2) {
        if ((n & 0x80) != 0) {
            enumSet = EvalOptionKt.getDefaultEvalOptions();
        }
        interpreter2.eval(object, scriptSource, hashCode, scriptHandler, classLoaderScope, classLoaderScope2, bl, enumSet);
    }

    private final ProgramTarget programTargetFor(Object target) {
        ProgramTarget programTarget;
        Object object = target;
        if (object instanceof Settings) {
            programTarget = ProgramTarget.Settings;
        } else if (object instanceof Project) {
            programTarget = ProgramTarget.Project;
        } else if (object instanceof Gradle) {
            programTarget = ProgramTarget.Gradle;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported target: " + target);
        }
        return programTarget;
    }

    private final KotlinScriptHost<Object> scriptHostFor(ProgramTarget programTarget, Object target, ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope) {
        return new KotlinScriptHost<Object>(target, scriptSource, scriptHandler, targetScope, baseScope, this.host.serviceRegistryFor(programTarget, target));
    }

    private final ProgramHost programHostFor(EnumSet<EvalOption> options) {
        return options.contains((Object)EvalOption.SkipBody) ? (ProgramHost)new FirstStageOnlyProgramHost() : this.defaultProgramHost;
    }

    private final CompiledScript emitSpecializedProgramFor(KotlinScriptHost<? extends Object> scriptHost, ScriptSource scriptSource, HashCode sourceHash, String templateId, ClassLoader parentClassLoader, ClassLoaderScope targetScope, ClassLoaderScope baseScope, ProgramKind programKind, ProgramTarget programTarget) {
        KProperty kProperty = null;
        Lazy pluginAccessorsClassPath2 = UnsafeLazyKt.unsafeLazy((Function0)new Function0<ClassPath>(this, programTarget, programKind, scriptHost){
            final /* synthetic */ Interpreter this$0;
            final /* synthetic */ ProgramTarget $programTarget;
            final /* synthetic */ ProgramKind $programKind;
            final /* synthetic */ KotlinScriptHost $scriptHost;

            @Nullable
            public final ClassPath invoke() {
                return ResidualProgramCompilerKt.requiresAccessors(this.$programTarget, this.$programKind) ? this.this$0.getHost().pluginAccessorsFor(this.$scriptHost) : null;
            }
            {
                this.this$0 = interpreter2;
                this.$programTarget = programTarget;
                this.$programKind = programKind;
                this.$scriptHost = kotlinScriptHost;
                super(0);
            }
        });
        String scriptPath = scriptHost.getFileName();
        File cachedDir2 = this.host.cachedDirFor(scriptHost, templateId, sourceHash, parentClassLoader, null, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this, scriptSource, templateId, scriptPath, programKind, programTarget, targetScope, sourceHash, pluginAccessorsClassPath2, kProperty){
            final /* synthetic */ Interpreter this$0;
            final /* synthetic */ ScriptSource $scriptSource;
            final /* synthetic */ String $templateId;
            final /* synthetic */ String $scriptPath;
            final /* synthetic */ ProgramKind $programKind;
            final /* synthetic */ ProgramTarget $programTarget;
            final /* synthetic */ ClassLoaderScope $targetScope;
            final /* synthetic */ HashCode $sourceHash;
            final /* synthetic */ Lazy $pluginAccessorsClassPath;
            final /* synthetic */ KProperty $pluginAccessorsClassPath$metadata;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull File cachedDir2) {
                Intrinsics.checkParameterIsNotNull((Object)cachedDir2, (String)"cachedDir");
                AutoCloseable autoCloseable = Interpreter.access$startCompilerOperationFor(this.this$0, this.$scriptSource, this.$templateId);
                boolean bl = false;
                Throwable throwable = null;
                try {
                    String sourceText;
                    AutoCloseable it = autoCloseable;
                    boolean bl2 = false;
                    File file = Interpreter.access$stage1SubDirOf(this.this$0, cachedDir2);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    File $this$apply = file;
                    boolean bl5 = false;
                    $this$apply.mkdir();
                    File outputDir = file;
                    TextResource textResource = this.$scriptSource.getResource();
                    if (textResource == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = sourceText = textResource.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sourceText");
                    ProgramSource programSource = new ProgramSource(this.$scriptPath, string2);
                    Packaged<Program> program2 = ProgramParser.INSTANCE.parse(programSource, this.$programKind, this.$programTarget);
                    Packaged<U> residualProgram2 = program2.map((Function1)new Function1<Program, ResidualProgram>(new PartialEvaluator(this.$programKind, this.$programTarget)){

                        @NotNull
                        public final ResidualProgram invoke(@NotNull Program p1) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            return ((PartialEvaluator)this.receiver).reduce(p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(PartialEvaluator.class);
                        }

                        public final String getName() {
                            return "reduce";
                        }

                        public final String getSignature() {
                            return "reduce(Lorg/gradle/kotlin/dsl/execution/Program;)Lorg/gradle/kotlin/dsl/execution/ResidualProgram;";
                        }
                    });
                    ScriptSource $this$withLocationAwareExceptionHandling$iv = this.$scriptSource;
                    boolean $i$f$withLocationAwareExceptionHandling = false;
                    try {
                        boolean bl6 = false;
                        Host host = this.this$0.getHost();
                        ClassLoaderScope classLoaderScope = this.$targetScope.getParent();
                        Intrinsics.checkExpressionValueIsNotNull((Object)classLoaderScope, (String)"targetScope.parent");
                        Lazy lazy = this.$pluginAccessorsClassPath;
                        Object var16_21 = null;
                        KProperty kProperty = this.$pluginAccessorsClassPath$metadata;
                        Function3 function3 = (Function3)new Function3<String, String, Function0<? extends String>, String>(this.this$0.getHost()){

                            @NotNull
                            public final String invoke(@NotNull String p1, @NotNull String p2, @NotNull Function0<String> p3) {
                                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                                Intrinsics.checkParameterIsNotNull(p3, (String)"p3");
                                return ((Host)this.receiver).runCompileBuildOperation(p1, p2, p3);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(Host.class);
                            }

                            public final String getName() {
                                return "runCompileBuildOperation";
                            }

                            public final String getSignature() {
                                return "runCompileBuildOperation(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/String;";
                            }
                        };
                        Logger logger2 = InterpreterKt.getInterpreterLogger();
                        List<String> list2 = this.this$0.getHost().getImplicitImports();
                        ProgramTarget programTarget = this.$programTarget;
                        ProgramKind programKind = this.$programKind;
                        HashCode hashCode = this.$sourceHash;
                        ClassPath classPath = host.compilationClassPathOf(classLoaderScope);
                        File file2 = outputDir;
                        boolean bl7 = false;
                        Object object = lazy.getValue();
                        ClassPath classPath2 = (ClassPath)object;
                        if (classPath2 == null) {
                            ClassPath classPath3 = ClassPath.EMPTY;
                            classPath2 = classPath3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)classPath3, (String)"ClassPath.EMPTY");
                        }
                        String string3 = residualProgram2.getPackageName();
                        ClassPath classPath4 = classPath2;
                        Function3 function32 = function3;
                        Logger logger3 = logger2;
                        List<String> list3 = list2;
                        ProgramTarget programTarget2 = programTarget;
                        ProgramKind programKind2 = programKind;
                        HashCode hashCode2 = hashCode;
                        ClassPath classPath5 = classPath;
                        File file3 = file2;
                        new ResidualProgramCompiler(file3, classPath5, hashCode2, programKind2, programTarget2, list3, logger3, (Function3<? super String, ? super String, ? super Function0<String>, String>)function32, classPath4, string3).compile((ResidualProgram)residualProgram2.getDocument());
                        Unit unit2 = Unit.INSTANCE;
                    }
                    catch (ScriptCompilationException e$iv) {
                        throw (Throwable)new LocationAwareException((Throwable)e$iv, $this$withLocationAwareExceptionHandling$iv, e$iv.getFirstErrorLine());
                    }
                    Unit unit3 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = interpreter2;
                this.$scriptSource = scriptSource;
                this.$templateId = string2;
                this.$scriptPath = string3;
                this.$programKind = programKind;
                this.$programTarget = programTarget;
                this.$targetScope = classLoaderScope;
                this.$sourceHash = hashCode;
                this.$pluginAccessorsClassPath = lazy;
                this.$pluginAccessorsClassPath$metadata = kProperty;
                super(1);
            }
        }));
        File classesDir = this.stage1SubDirOf(cachedDir2);
        Lazy lazy = pluginAccessorsClassPath2;
        Object var16_16 = null;
        String string2 = templateId;
        File file = classesDir;
        String string3 = scriptPath;
        ClassLoaderScope classLoaderScope = baseScope;
        Interpreter interpreter2 = this;
        boolean bl = false;
        Object object = lazy.getValue();
        return interpreter2.loadClassInChildScopeOf(classLoaderScope, string3, file, string2, (ClassPath)object, scriptSource);
    }

    private final File stage1SubDirOf(File cachedDir2) {
        return FilesKt.resolve((File)cachedDir2, (String)"stage-1");
    }

    private final CompiledScript loadClassInChildScopeOf(ClassLoaderScope baseScope, String scriptPath, File classesDir, String scriptTemplateId, ClassPath accessorsClassPath, ScriptSource scriptSource) {
        InterpreterKt.access$logClassLoadingOf(scriptTemplateId, scriptSource);
        String string2 = "Program";
        File file = classesDir;
        ClassPath classPath = accessorsClassPath;
        return this.host.loadClassInChildScopeOf(baseScope, InterpreterKt.access$classLoaderScopeIdFor(scriptPath, scriptTemplateId), file, string2, classPath);
    }

    private final AutoCloseable startCompilerOperationFor(ScriptSource scriptSource, String scriptTemplateId) {
        InterpreterKt.access$logCompilationOf(scriptTemplateId, scriptSource);
        String string2 = scriptSource.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"scriptSource.displayName");
        return this.host.startCompilerOperation(string2);
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    public Interpreter(@NotNull Host host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.host = host;
        this.defaultProgramHost = new ProgramHost();
    }

    public static final /* synthetic */ AutoCloseable access$startCompilerOperationFor(Interpreter $this, ScriptSource scriptSource, String scriptTemplateId) {
        return $this.startCompilerOperationFor(scriptSource, scriptTemplateId);
    }

    public static final /* synthetic */ File access$stage1SubDirOf(Interpreter $this, File cachedDir2) {
        return $this.stage1SubDirOf(cachedDir2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u001c\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&JJ\u0010\u0016\u001a\u00020\u00172\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b0 H&J\u0014\u0010!\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H&J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001eH&J2\u0010'\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH&J\u001c\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030.H&J\u0014\u0010/\u001a\u00020\u001e2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J&\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000404H&J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0001H\u0016J\u0014\u0010:\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0004H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006>"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "", "implicitImports", "", "", "getImplicitImports", "()Ljava/util/List;", "applyBasePluginsTo", "", "project", "Lorg/gradle/api/Project;", "applyPluginsTo", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "pluginRequests", "Lorg/gradle/plugin/management/internal/PluginRequests;", "cache", "specializedProgram", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "programId", "Lorg/gradle/kotlin/dsl/execution/ProgramId;", "cachedClassFor", "cachedDirFor", "Ljava/io/File;", "templateId", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "parentClassLoader", "Ljava/lang/ClassLoader;", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "initializer", "Lkotlin/Function1;", "closeTargetScopeOf", "compilationClassPathOf", "classLoaderScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "hashOf", "classPath", "loadClassInChildScopeOf", "childScopeId", "location", "className", "onScriptClassLoaded", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "Ljava/lang/Class;", "pluginAccessorsFor", "runCompileBuildOperation", "scriptPath", "stage", "action", "Lkotlin/Function0;", "serviceRegistryFor", "Lorg/gradle/internal/service/ServiceRegistry;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "target", "setupEmbeddedKotlinFor", "startCompilerOperation", "Ljava/lang/AutoCloseable;", "description", "gradle-kotlin-dsl"})
    public static interface Host {
        @Nullable
        public CompiledScript cachedClassFor(@NotNull ProgramId var1);

        public void cache(@NotNull CompiledScript var1, @NotNull ProgramId var2);

        @NotNull
        public File cachedDirFor(@NotNull KotlinScriptHost<?> var1, @NotNull String var2, @NotNull HashCode var3, @NotNull ClassLoader var4, @Nullable ClassPath var5, @NotNull Function1<? super File, Unit> var6);

        @NotNull
        public AutoCloseable startCompilerOperation(@NotNull String var1);

        @NotNull
        public ClassPath compilationClassPathOf(@NotNull ClassLoaderScope var1);

        @NotNull
        public ClassPath pluginAccessorsFor(@NotNull KotlinScriptHost<?> var1);

        @NotNull
        public CompiledScript loadClassInChildScopeOf(@NotNull ClassLoaderScope var1, @NotNull String var2, @NotNull File var3, @NotNull String var4, @Nullable ClassPath var5);

        public void applyPluginsTo(@NotNull KotlinScriptHost<?> var1, @NotNull PluginRequests var2);

        public void applyBasePluginsTo(@NotNull Project var1);

        public void setupEmbeddedKotlinFor(@NotNull KotlinScriptHost<?> var1);

        public void closeTargetScopeOf(@NotNull KotlinScriptHost<?> var1);

        @NotNull
        public HashCode hashOf(@NotNull ClassPath var1);

        @NotNull
        public String runCompileBuildOperation(@NotNull String var1, @NotNull String var2, @NotNull Function0<String> var3);

        public void onScriptClassLoaded(@NotNull ScriptSource var1, @NotNull Class<?> var2);

        @NotNull
        public List<String> getImplicitImports();

        @NotNull
        public ServiceRegistry serviceRegistryFor(@NotNull ProgramTarget var1, @NotNull Object var2);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            @NotNull
            public static ServiceRegistry serviceRegistryFor(Host $this, @NotNull ProgramTarget programTarget, @NotNull Object target) {
                ServiceRegistry serviceRegistry;
                Intrinsics.checkParameterIsNotNull((Object)((Object)programTarget), (String)"programTarget");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                switch (Interpreter$Host$WhenMappings.$EnumSwitchMapping$0[programTarget.ordinal()]) {
                    case 1: {
                        serviceRegistry = ProjectExtensionsKt.serviceRegistryOf((Project)target);
                        break;
                    }
                    case 2: {
                        serviceRegistry = SettingsExtensionsKt.serviceRegistryOf((Settings)target);
                        break;
                    }
                    case 3: {
                        serviceRegistry = GradleExtensionsKt.serviceRegistryOf((Gradle)target);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return serviceRegistry;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$FirstStageOnlyProgramHost;", "Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "Lorg/gradle/kotlin/dsl/execution/Interpreter;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter;)V", "evaluateSecondStageOf", "", "program", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$StagedProgram;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "scriptTemplateId", "", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "gradle-kotlin-dsl"})
    private final class FirstStageOnlyProgramHost
    extends ProgramHost {
        @Override
        public void evaluateSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @Nullable ClassPath accessorsClassPath) {
            Intrinsics.checkParameterIsNotNull((Object)program2, (String)"program");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Intrinsics.checkParameterIsNotNull((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkParameterIsNotNull((Object)sourceHash, (String)"sourceHash");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016JF\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J6\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0016J(\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u001e2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0014\u0010$\u001a\u00020%2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u0014\u0010&\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a8\u0006'"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$Host;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter;)V", "accessorsClassPathFor", "Lorg/gradle/internal/classpath/ClassPath;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "applyBasePluginsTo", "", "project", "Lorg/gradle/api/Project;", "applyPluginsTo", "pluginRequests", "Lorg/gradle/plugin/management/internal/PluginRequests;", "closeTargetScopeOf", "compileSecondStageOf", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "program", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$StagedProgram;", "scriptTemplateId", "", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "accessorsClassPath", "eval", "specializedProgram", "Ljava/lang/Class;", "evaluateSecondStageOf", "handleScriptException", "exception", "", "scriptClass", "instantiate", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram;", "setupEmbeddedKotlinFor", "gradle-kotlin-dsl"})
    private class ProgramHost
    implements ExecutableProgram.Host {
        @Override
        public void setupEmbeddedKotlinFor(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Interpreter.this.getHost().setupEmbeddedKotlinFor(scriptHost);
        }

        @Override
        public void applyPluginsTo(@NotNull KotlinScriptHost<?> scriptHost, @NotNull PluginRequests pluginRequests) {
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Intrinsics.checkParameterIsNotNull((Object)pluginRequests, (String)"pluginRequests");
            Interpreter.this.getHost().applyPluginsTo(scriptHost, pluginRequests);
        }

        @Override
        public void applyBasePluginsTo(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Interpreter.this.getHost().applyBasePluginsTo(project);
        }

        @Override
        public void handleScriptException(@NotNull Throwable exception, @NotNull Class<?> scriptClass, @NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            Intrinsics.checkParameterIsNotNull(scriptClass, (String)"scriptClass");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Void void_ = InterpreterKt.access$locationAwareExceptionHandlingFor(exception, scriptClass, scriptHost.getScriptSource());
            throw null;
        }

        @Override
        public void closeTargetScopeOf(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Interpreter.this.getHost().closeTargetScopeOf(scriptHost);
        }

        @Override
        public void evaluateSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @Nullable ClassPath accessorsClassPath) {
            HashCode hashCode;
            Intrinsics.checkParameterIsNotNull((Object)program2, (String)"program");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Intrinsics.checkParameterIsNotNull((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkParameterIsNotNull((Object)sourceHash, (String)"sourceHash");
            ClassLoaderScope targetScope = scriptHost.getTargetScope();
            ClassLoader classLoader = targetScope.getExportClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"targetScope.exportClassLoader");
            ClassLoader parentClassLoader = classLoader;
            ClassPath classPath = accessorsClassPath;
            if (classPath != null) {
                ClassPath classPath2 = classPath;
                boolean bl = false;
                boolean bl2 = false;
                ClassPath it = classPath2;
                boolean bl3 = false;
                hashCode = Interpreter.this.getHost().hashOf(it);
            } else {
                hashCode = null;
            }
            HashCode classPathHash = hashCode;
            ProgramId programId = new ProgramId(scriptTemplateId, sourceHash, parentClassLoader, classPathHash);
            CompiledScript cachedProgram = Interpreter.this.getHost().cachedClassFor(programId);
            if (cachedProgram != null) {
                this.eval(cachedProgram.getProgramFor(), scriptHost);
                return;
            }
            CompiledScript specializedProgram = program2.loadSecondStageFor(this, scriptHost, scriptTemplateId, sourceHash, accessorsClassPath);
            Interpreter.this.getHost().cache(specializedProgram, programId);
            this.eval(specializedProgram.getProgramFor(), scriptHost);
        }

        @Override
        @NotNull
        public ClassPath accessorsClassPathFor(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Object obj = scriptHost.getTarget();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.Project");
            }
            return AccessorsClassPathKt.projectAccessorsClassPath((Project)obj, Interpreter.this.getHost().compilationClassPathOf(scriptHost.getTargetScope())).getBin();
        }

        @Override
        @NotNull
        public CompiledScript compileSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @NotNull ProgramKind programKind, @NotNull ProgramTarget programTarget, @Nullable ClassPath accessorsClassPath) {
            Intrinsics.checkParameterIsNotNull((Object)program2, (String)"program");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Intrinsics.checkParameterIsNotNull((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkParameterIsNotNull((Object)sourceHash, (String)"sourceHash");
            Intrinsics.checkParameterIsNotNull((Object)((Object)programKind), (String)"programKind");
            Intrinsics.checkParameterIsNotNull((Object)((Object)programTarget), (String)"programTarget");
            String originalScriptPath = scriptHost.getFileName();
            ClassLoaderScope targetScope = scriptHost.getTargetScope();
            ClassLoader classLoader = targetScope.getExportClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"targetScope.exportClassLoader");
            ClassLoader parentClassLoader = classLoader;
            ScriptSource scriptSource = scriptHost.getScriptSource();
            File cacheDir2 = Interpreter.this.getHost().cachedDirFor(scriptHost, scriptTemplateId, sourceHash, parentClassLoader, accessorsClassPath, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this, scriptSource, scriptTemplateId, targetScope, accessorsClassPath, originalScriptPath, program2, sourceHash, programKind, programTarget){
                final /* synthetic */ ProgramHost this$0;
                final /* synthetic */ ScriptSource $scriptSource;
                final /* synthetic */ String $scriptTemplateId;
                final /* synthetic */ ClassLoaderScope $targetScope;
                final /* synthetic */ ClassPath $accessorsClassPath;
                final /* synthetic */ String $originalScriptPath;
                final /* synthetic */ ExecutableProgram.StagedProgram $program;
                final /* synthetic */ HashCode $sourceHash;
                final /* synthetic */ ProgramKind $programKind;
                final /* synthetic */ ProgramTarget $programTarget;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull File outputDir) {
                    Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
                    AutoCloseable autoCloseable = Interpreter.access$startCompilerOperationFor(this.this$0.Interpreter.this, this.$scriptSource, this.$scriptTemplateId);
                    boolean bl = false;
                    Throwable throwable = null;
                    try {
                        Object it;
                        ClassPath classPath;
                        block19: {
                            ClassPath targetScopeClassPath;
                            block18: {
                                AutoCloseable it2 = autoCloseable;
                                boolean bl2 = false;
                                targetScopeClassPath = this.this$0.Interpreter.this.getHost().compilationClassPathOf(this.$targetScope);
                                classPath = this.$accessorsClassPath;
                                if (classPath == null) break block18;
                                ClassPath classPath2 = classPath;
                                boolean bl3 = false;
                                boolean bl4 = false;
                                it = classPath2;
                                boolean bl5 = false;
                                classPath = targetScopeClassPath.plus(it);
                                if (classPath != null) break block19;
                            }
                            classPath = targetScopeClassPath;
                        }
                        ClassPath compilationClassPath = classPath;
                        ScriptSource $this$withLocationAwareExceptionHandling$iv = this.$scriptSource;
                        boolean $i$f$withLocationAwareExceptionHandling = false;
                        try {
                            boolean bl6 = false;
                            it = this.$originalScriptPath;
                            String scriptText$iv = this.$program.getSecondStageScriptText();
                            boolean $i$f$withTemporaryScriptFileFor = false;
                            File file = FilesKt.createTempDir$default((String)"gradle-kotlin-dsl-", null, null, (int)6, null);
                            boolean bl7 = false;
                            boolean bl8 = false;
                            File tempDir$iv = file;
                            boolean bl9 = false;
                            try {
                                Unit unit2;
                                void scriptPath$iv;
                                File tempFile$iv = TemporaryScriptFilesKt.access$canonicalScriptFileFor(tempDir$iv, (String)scriptPath$iv, scriptText$iv);
                                try {
                                    File scriptFile = tempFile$iv;
                                    boolean bl10 = false;
                                    new ResidualProgramCompiler(outputDir, compilationClassPath, this.$sourceHash, this.$programKind, this.$programTarget, this.this$0.Interpreter.this.getHost().getImplicitImports(), InterpreterKt.getInterpreterLogger(), (Function3)new Function3<String, String, Function0<? extends String>, String>(this.this$0.Interpreter.this.getHost()){

                                        @NotNull
                                        public final String invoke(@NotNull String p1, @NotNull String p2, @NotNull Function0<String> p3) {
                                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                                            Intrinsics.checkParameterIsNotNull(p3, (String)"p3");
                                            return ((Host)this.receiver).runCompileBuildOperation(p1, p2, p3);
                                        }

                                        public final KDeclarationContainer getOwner() {
                                            return Reflection.getOrCreateKotlinClass(Host.class);
                                        }

                                        public final String getName() {
                                            return "runCompileBuildOperation";
                                        }

                                        public final String getSignature() {
                                            return "runCompileBuildOperation(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/String;";
                                        }
                                    }, null, null, 768, null).emitStage2ProgramFor(scriptFile, this.$originalScriptPath);
                                    unit2 = Unit.INSTANCE;
                                }
                                finally {
                                    tempFile$iv.delete();
                                }
                                Unit unit3 = unit2;
                            }
                            finally {
                                tempDir$iv.delete();
                            }
                            Unit unit4 = Unit.INSTANCE;
                        }
                        catch (ScriptCompilationException e$iv) {
                            throw (Throwable)new LocationAwareException((Throwable)e$iv, $this$withLocationAwareExceptionHandling$iv, e$iv.getFirstErrorLine());
                        }
                        Unit unit5 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
                {
                    this.this$0 = programHost;
                    this.$scriptSource = scriptSource;
                    this.$scriptTemplateId = string2;
                    this.$targetScope = classLoaderScope;
                    this.$accessorsClassPath = classPath;
                    this.$originalScriptPath = string3;
                    this.$program = stagedProgram;
                    this.$sourceHash = hashCode;
                    this.$programKind = programKind;
                    this.$programTarget = programTarget;
                    super(1);
                }
            }));
            return Interpreter.this.loadClassInChildScopeOf(targetScope, originalScriptPath, cacheDir2, scriptTemplateId, accessorsClassPath, scriptSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eval(@NotNull Class<?> specializedProgram, @NotNull KotlinScriptHost<?> scriptHost) {
            Thread currentThread$iv;
            Intrinsics.checkParameterIsNotNull(specializedProgram, (String)"specializedProgram");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            ClassLoader classLoader = specializedProgram.getClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"specializedProgram.classLoader");
            ClassLoader classLoader$iv = classLoader;
            boolean $i$f$withContextClassLoader = false;
            Thread thread = currentThread$iv = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
            ClassLoader previous$iv = thread.getContextClassLoader();
            try {
                currentThread$iv.setContextClassLoader(classLoader$iv);
                boolean bl = false;
                Interpreter.this.getHost().onScriptClassLoaded(scriptHost.getScriptSource(), specializedProgram);
                this.instantiate(specializedProgram).execute(this, scriptHost);
            }
            finally {
                currentThread$iv.setContextClassLoader(previous$iv);
            }
        }

        private final ExecutableProgram instantiate(Class<?> specializedProgram) {
            Object obj = specializedProgram.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.kotlin.dsl.execution.ExecutableProgram");
            }
            return (ExecutableProgram)obj;
        }
    }
}

