/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.ProcessLauncher;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.file.FileSystems;
import net.rubygrapefruit.platform.file.Files;
import net.rubygrapefruit.platform.file.PosixFiles;
import net.rubygrapefruit.platform.file.WindowsFiles;
import net.rubygrapefruit.platform.internal.DefaultMemory;
import net.rubygrapefruit.platform.internal.DefaultOsxMemory;
import net.rubygrapefruit.platform.internal.DefaultPosixFiles;
import net.rubygrapefruit.platform.internal.DefaultProcess;
import net.rubygrapefruit.platform.internal.DefaultProcessLauncher;
import net.rubygrapefruit.platform.internal.DefaultSystemInfo;
import net.rubygrapefruit.platform.internal.DefaultWindowsFiles;
import net.rubygrapefruit.platform.internal.DefaultWindowsRegistry;
import net.rubygrapefruit.platform.internal.MutableTypeInfo;
import net.rubygrapefruit.platform.internal.NativeLibraryLoader;
import net.rubygrapefruit.platform.internal.PosixFileSystems;
import net.rubygrapefruit.platform.internal.PosixTerminals;
import net.rubygrapefruit.platform.internal.WindowsProcessLauncher;
import net.rubygrapefruit.platform.internal.WindowsTerminals;
import net.rubygrapefruit.platform.internal.WrapperProcess;
import net.rubygrapefruit.platform.internal.WrapperProcessLauncher;
import net.rubygrapefruit.platform.internal.jni.AbstractFileEventFunctions;
import net.rubygrapefruit.platform.internal.jni.LinuxFileEventFunctions;
import net.rubygrapefruit.platform.internal.jni.OsxFileEventFunctions;
import net.rubygrapefruit.platform.internal.jni.PosixTypeFunctions;
import net.rubygrapefruit.platform.internal.jni.TerminfoFunctions;
import net.rubygrapefruit.platform.internal.jni.WindowsFileEventFunctions;
import net.rubygrapefruit.platform.memory.Memory;
import net.rubygrapefruit.platform.memory.OsxMemory;
import net.rubygrapefruit.platform.terminal.Terminals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Platform {
    private static Platform platform;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Platform current() {
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (platform == null) {
                String osName = Platform.getOperatingSystem().toLowerCase();
                String arch = Platform.getArchitecture();
                if (osName.contains("windows")) {
                    if (arch.equals("x86")) {
                        platform = new Window32Bit();
                    } else if (arch.equals("amd64")) {
                        platform = new Window64Bit();
                    }
                } else if (osName.contains("linux")) {
                    if (arch.equals("amd64") || arch.equals("x86_64")) {
                        platform = new Linux64Bit();
                    } else if (arch.equals("i386") || arch.equals("x86")) {
                        platform = new Linux32Bit();
                    } else if (arch.equals("aarch64")) {
                        platform = new LinuxAarch64();
                    }
                } else if (osName.contains("os x") || osName.contains("darwin")) {
                    if (arch.equals("i386")) {
                        platform = new MacOs32Bit();
                    } else if (arch.equals("x86_64") || arch.equals("amd64") || arch.equals("universal")) {
                        platform = new MacOs64Bit();
                    }
                } else if (osName.contains("freebsd")) {
                    if (arch.equals("amd64")) {
                        platform = new FreeBSD64Bit();
                    } else if (arch.equals("i386") || arch.equals("x86")) {
                        platform = new FreeBSD32Bit();
                    }
                }
                if (platform == null) {
                    platform = new Unsupported();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    public boolean isLinux() {
        return false;
    }

    public boolean isMacOs() {
        return false;
    }

    public boolean isFreeBSD() {
        return false;
    }

    public boolean isWindows() {
        return false;
    }

    public String toString() {
        return String.format("%s %s", Platform.getOperatingSystem(), Platform.getArchitecture());
    }

    public <T extends NativeIntegration> Class<? extends T> canonicalise(Class<T> type) {
        return type;
    }

    public <T extends NativeIntegration> T get(Class<T> type, NativeLibraryLoader nativeLibraryLoader) {
        throw new NativeIntegrationUnavailableException(String.format("Native integration %s is not supported for %s.", type.getSimpleName(), this.toString()));
    }

    public String getLibraryName() {
        throw new NativeIntegrationUnavailableException(String.format("Native integration is not available for %s.", this.toString()));
    }

    public String getFileEventsLibraryName() {
        throw new NativeIntegrationUnavailableException(String.format("Native file events integration is not available for %s.", this.toString()));
    }

    public List<String> getLibraryVariants() {
        return Collections.singletonList(this.getId());
    }

    public abstract String getId();

    private static String getOperatingSystem() {
        return System.getProperty("os.name");
    }

    private static String getArchitecture() {
        return System.getProperty("os.arch");
    }

    protected void initFileEventFunctions(NativeLibraryLoader nativeLibraryLoader) {
        nativeLibraryLoader.load(this.getFileEventsLibraryName(), this.getLibraryVariants());
        String nativeVersion = AbstractFileEventFunctions.getVersion();
        if (!nativeVersion.equals("481b90ef2c2b5ab96622bab5346fdaaafe5c91895d4d4de1c4fe4b2e89a8011f")) {
            throw new NativeException(String.format("Unexpected native file events library version loaded. Expected %s, was %s.", nativeVersion, "481b90ef2c2b5ab96622bab5346fdaaafe5c91895d4d4de1c4fe4b2e89a8011f"));
        }
    }

    private static class Unsupported
    extends Platform {
        private Unsupported() {
        }

        public String getId() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MacOs64Bit
    extends MacOs {
        private MacOs64Bit() {
        }

        public String getId() {
            return "osx-amd64";
        }
    }

    private static class MacOs32Bit
    extends MacOs {
        private MacOs32Bit() {
        }

        public String getId() {
            return "osx-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MacOs
    extends Posix {
        private MacOs() {
        }

        @Override
        public boolean isMacOs() {
            return true;
        }

        @Override
        public String getLibraryName() {
            return "libnative-platform.dylib";
        }

        @Override
        public String getFileEventsLibraryName() {
            return "libnative-platform-file-events.dylib";
        }

        @Override
        String getCursesLibraryName() {
            return "libnative-platform-curses.dylib";
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type, NativeLibraryLoader nativeLibraryLoader) {
            if (type.equals(OsxMemory.class)) {
                return (T)((NativeIntegration)type.cast(new DefaultOsxMemory()));
            }
            if (type.equals(Memory.class)) {
                return (T)((NativeIntegration)type.cast(new DefaultMemory()));
            }
            if (type.equals(OsxFileEventFunctions.class)) {
                this.initFileEventFunctions(nativeLibraryLoader);
                return (T)((NativeIntegration)type.cast(new OsxFileEventFunctions()));
            }
            return super.get(type, nativeLibraryLoader);
        }
    }

    private static class FreeBSD64Bit
    extends FreeBSD {
        private FreeBSD64Bit() {
        }

        public String getId() {
            return "freebsd-amd64";
        }
    }

    private static class FreeBSD32Bit
    extends FreeBSD {
        private FreeBSD32Bit() {
        }

        public String getId() {
            return "freebsd-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class FreeBSD
    extends Unix {
        private FreeBSD() {
        }

        @Override
        public List<String> getLibraryVariants() {
            return Arrays.asList(this.getId() + "-libcpp", this.getId() + "-libstdcpp");
        }

        @Override
        public boolean isFreeBSD() {
            return true;
        }
    }

    private static class LinuxAarch64
    extends Linux {
        private LinuxAarch64() {
        }

        public String getId() {
            return "linux-aarch64";
        }
    }

    private static class Linux64Bit
    extends Linux {
        private Linux64Bit() {
        }

        public String getId() {
            return "linux-amd64";
        }
    }

    private static class Linux32Bit
    extends Linux {
        private Linux32Bit() {
        }

        public String getId() {
            return "linux-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Linux
    extends Unix {
        private Linux() {
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type, NativeLibraryLoader nativeLibraryLoader) {
            if (type.equals(LinuxFileEventFunctions.class)) {
                this.initFileEventFunctions(nativeLibraryLoader);
                return (T)((NativeIntegration)type.cast(new LinuxFileEventFunctions()));
            }
            return super.get(type, nativeLibraryLoader);
        }

        @Override
        List<String> getCursesVariants() {
            return Arrays.asList(this.getId() + "-ncurses5", this.getId() + "-ncurses6");
        }

        @Override
        public boolean isLinux() {
            return true;
        }

        @Override
        public String getFileEventsLibraryName() {
            return "libnative-platform-file-events.so";
        }
    }

    private static abstract class Unix
    extends Posix {
        private Unix() {
        }

        public String getLibraryName() {
            return "libnative-platform.so";
        }

        String getCursesLibraryName() {
            return "libnative-platform-curses.so";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Posix
    extends Platform {
        private Posix() {
        }

        abstract String getCursesLibraryName();

        List<String> getCursesVariants() {
            return this.getLibraryVariants();
        }

        @Override
        public <T extends NativeIntegration> Class<? extends T> canonicalise(Class<T> type) {
            if (type.equals(Files.class)) {
                return PosixFiles.class.asSubclass(type);
            }
            return super.canonicalise(type);
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type, NativeLibraryLoader nativeLibraryLoader) {
            if (type.equals(PosixFiles.class)) {
                return (T)((NativeIntegration)type.cast(new DefaultPosixFiles()));
            }
            if (type.equals(Process.class)) {
                return (T)((NativeIntegration)type.cast(new WrapperProcess(new DefaultProcess(), false)));
            }
            if (type.equals(ProcessLauncher.class)) {
                return (T)((NativeIntegration)type.cast(new WrapperProcessLauncher(new DefaultProcessLauncher())));
            }
            if (type.equals(Terminals.class)) {
                nativeLibraryLoader.load(this.getCursesLibraryName(), this.getCursesVariants());
                String nativeVersion = TerminfoFunctions.getVersion();
                if (!nativeVersion.equals("481b90ef2c2b5ab96622bab5346fdaaafe5c91895d4d4de1c4fe4b2e89a8011f")) {
                    throw new NativeException(String.format("Unexpected native library version loaded. Expected %s, was %s.", nativeVersion, "481b90ef2c2b5ab96622bab5346fdaaafe5c91895d4d4de1c4fe4b2e89a8011f"));
                }
                return (T)((NativeIntegration)type.cast(new PosixTerminals()));
            }
            if (type.equals(SystemInfo.class)) {
                return (T)((NativeIntegration)type.cast(new DefaultSystemInfo()));
            }
            if (type.equals(FileSystems.class)) {
                return (T)((NativeIntegration)type.cast(new PosixFileSystems()));
            }
            if (type.equals(MutableTypeInfo.class)) {
                MutableTypeInfo typeInfo = new MutableTypeInfo();
                PosixTypeFunctions.getNativeTypeInfo(typeInfo);
                return (T)((NativeIntegration)type.cast(typeInfo));
            }
            return super.get(type, nativeLibraryLoader);
        }
    }

    private static class Window64Bit
    extends Windows {
        private Window64Bit() {
        }

        public String getId() {
            return "windows-amd64";
        }
    }

    private static class Window32Bit
    extends Windows {
        private Window32Bit() {
        }

        public String getId() {
            return "windows-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Windows
    extends Platform {
        private Windows() {
        }

        @Override
        public boolean isWindows() {
            return true;
        }

        @Override
        public String getLibraryName() {
            return "native-platform.dll";
        }

        @Override
        public String getFileEventsLibraryName() {
            return "native-platform-file-events.dll";
        }

        @Override
        public List<String> getLibraryVariants() {
            return Arrays.asList(this.getId(), this.getId() + "-min");
        }

        @Override
        public <T extends NativeIntegration> Class<? extends T> canonicalise(Class<T> type) {
            if (type.equals(Files.class)) {
                return WindowsFiles.class.asSubclass(type);
            }
            return super.canonicalise(type);
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type, NativeLibraryLoader nativeLibraryLoader) {
            if (type.equals(WindowsFiles.class)) {
                return (T)((NativeIntegration)type.cast(new DefaultWindowsFiles()));
            }
            if (type.equals(Process.class)) {
                return (T)((NativeIntegration)type.cast(new WrapperProcess(new DefaultProcess(), true)));
            }
            if (type.equals(Terminals.class)) {
                return (T)((NativeIntegration)type.cast(new WindowsTerminals()));
            }
            if (type.equals(ProcessLauncher.class)) {
                return (T)((NativeIntegration)type.cast(new WrapperProcessLauncher(new WindowsProcessLauncher(new DefaultProcessLauncher()))));
            }
            if (type.equals(SystemInfo.class)) {
                return (T)((NativeIntegration)type.cast(new DefaultSystemInfo()));
            }
            if (type.equals(FileSystems.class)) {
                return (T)((NativeIntegration)type.cast(new PosixFileSystems()));
            }
            if (type.equals(WindowsRegistry.class)) {
                return (T)((NativeIntegration)type.cast(new DefaultWindowsRegistry()));
            }
            if (type.equals(WindowsFileEventFunctions.class)) {
                this.initFileEventFunctions(nativeLibraryLoader);
                return (T)((NativeIntegration)type.cast(new WindowsFileEventFunctions()));
            }
            return super.get(type, nativeLibraryLoader);
        }
    }
}

