/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.jni.LinuxFileEventFunctions;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.vfs.AbstractEventDrivenFileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;
import org.gradle.internal.vfs.watch.WatchRootUtil;
import org.gradle.internal.vfs.watch.WatchingNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFileWatcherRegistry
extends AbstractEventDrivenFileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxFileWatcherRegistry.class);
    private final Multiset<String> watchedRoots = HashMultiset.create();
    private final Set<String> mustWatchDirectories = new HashSet<String>();
    private final Map<String, ImmutableList<String>> watchedRootsForSnapshot = new HashMap<String, ImmutableList<String>>();

    public LinuxFileWatcherRegistry(FileWatcherRegistry.ChangeHandler handler) {
        super(callback -> ((LinuxFileEventFunctions)Native.get(LinuxFileEventFunctions.class)).startWatcher(callback), handler);
    }

    public void changed(Collection<CompleteFileSystemLocationSnapshot> removedSnapshots, Collection<CompleteFileSystemLocationSnapshot> addedSnapshots) {
        HashMap<String, Integer> changedWatchedDirectories = new HashMap<String, Integer>();
        removedSnapshots.forEach(snapshot -> {
            ImmutableList<String> previousWatchedRoots = this.watchedRootsForSnapshot.remove(snapshot.getAbsolutePath());
            previousWatchedRoots.forEach(path -> LinuxFileWatcherRegistry.decrement(path, changedWatchedDirectories));
            snapshot.accept((FileSystemSnapshotVisitor)new OnlyVisitSubDirectories(path -> LinuxFileWatcherRegistry.decrement(path, changedWatchedDirectories)));
        });
        addedSnapshots.forEach(snapshot -> {
            ImmutableList directoriesToWatchForRoot = ImmutableList.copyOf((Collection)WatchRootUtil.getDirectoriesToWatch((CompleteFileSystemLocationSnapshot)snapshot).stream().map(Path::toString).collect(Collectors.toList()));
            this.watchedRootsForSnapshot.put(snapshot.getAbsolutePath(), (ImmutableList<String>)directoriesToWatchForRoot);
            directoriesToWatchForRoot.forEach(path -> LinuxFileWatcherRegistry.increment(path, changedWatchedDirectories));
            snapshot.accept((FileSystemSnapshotVisitor)new OnlyVisitSubDirectories(path -> LinuxFileWatcherRegistry.increment(path, changedWatchedDirectories)));
        });
        this.updateWatchedDirectories(changedWatchedDirectories);
    }

    public void updateMustWatchDirectories(Collection<File> updatedWatchDirectories) {
        HashMap<String, Integer> changedDirectories = new HashMap<String, Integer>();
        this.mustWatchDirectories.forEach(path -> LinuxFileWatcherRegistry.decrement(path, changedDirectories));
        this.mustWatchDirectories.clear();
        updatedWatchDirectories.stream().filter(File::isDirectory).map(File::getAbsolutePath).forEach(this.mustWatchDirectories::add);
        this.mustWatchDirectories.forEach(path -> LinuxFileWatcherRegistry.increment(path, changedDirectories));
        this.updateWatchedDirectories(changedDirectories);
    }

    private void updateWatchedDirectories(Map<String, Integer> changedWatchDirectories) {
        if (changedWatchDirectories.isEmpty()) {
            return;
        }
        HashSet watchRootsToRemove = new HashSet();
        HashSet watchRootsToAdd = new HashSet();
        changedWatchDirectories.forEach((absolutePath, value) -> {
            int contained;
            int count = value;
            if (count < 0) {
                int toRemove = -count;
                int contained2 = this.watchedRoots.remove(absolutePath, toRemove);
                if (contained2 <= toRemove) {
                    watchRootsToRemove.add(new File((String)absolutePath));
                }
            } else if (count > 0 && (contained = this.watchedRoots.add(absolutePath, count)) == 0) {
                watchRootsToAdd.add(new File((String)absolutePath));
            }
        });
        if (this.watchedRoots.isEmpty()) {
            LOGGER.info("Not watching anything anymore");
        }
        LOGGER.info("Watching {} directory hierarchies to track changes", (Object)this.watchedRoots.entrySet().size());
        try {
            this.getWatcher().stopWatching(watchRootsToRemove);
            this.getWatcher().startWatching(watchRootsToAdd);
        }
        catch (NativeException e) {
            if (e.getMessage().contains("Already watching path: ")) {
                throw new WatchingNotSupportedException("Unable to watch same file twice via different paths: " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    private static void decrement(String path, Map<String, Integer> changedWatchedDirectories) {
        changedWatchedDirectories.compute(path, (key, value) -> value == null ? -1 : value - 1);
    }

    private static void increment(String path, Map<String, Integer> changedWatchedDirectories) {
        changedWatchedDirectories.compute(path, (key, value) -> value == null ? 1 : value + 1);
    }

    private static class OnlyVisitSubDirectories
    implements FileSystemSnapshotVisitor {
        private final Consumer<String> subDirectoryConsumer;
        boolean root;

        public OnlyVisitSubDirectories(Consumer<String> subDirectoryConsumer) {
            this.subDirectoryConsumer = subDirectoryConsumer;
            this.root = true;
        }

        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            if (!this.root) {
                this.subDirectoryConsumer.accept(directorySnapshot.getAbsolutePath());
            }
            this.root = false;
            return true;
        }

        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
        }

        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
        }
    }

    public static class Factory
    implements FileWatcherRegistryFactory {
        public FileWatcherRegistry startWatcher(FileWatcherRegistry.ChangeHandler handler) {
            return new LinuxFileWatcherRegistry(handler);
        }
    }
}

